/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.spi.RemoveOnlyCollection;
import org.jboss.osgi.resolver.spi.ResolverHookException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Resource;

public class ResolverHookProcessor {
    private static ThreadLocal<ResolverHookProcessor> processorAssociation = new ThreadLocal();
    private final BundleContext syscontext;
    private List<ResolverHookRegistration> registrations;
    private Collection<BundleRevision> candidates;

    public ResolverHookProcessor(BundleContext syscontext, Collection<XBundle> unresolved) {
        this.syscontext = syscontext;
        this.candidates = new ArrayList<BundleRevision>();
        if (unresolved != null) {
            for (XBundle bundle2 : unresolved) {
                this.candidates.add(bundle2.getBundleRevision());
            }
        }
        this.candidates = new RemoveOnlyCollection<BundleRevision>(this.candidates);
        Collection srefs = null;
        try {
            srefs = syscontext.getServiceReferences(ResolverHookFactory.class, null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        ArrayList sorted = new ArrayList(srefs);
        Collections.reverse(sorted);
        for (ServiceReference sref : sorted) {
            if (this.registrations == null) {
                this.registrations = new ArrayList<ResolverHookRegistration>();
            }
            this.registrations.add(new ResolverHookRegistration((ServiceReference<ResolverHookFactory>)sref));
        }
    }

    public static ResolverHookProcessor getCurrentProcessor() {
        return processorAssociation.get();
    }

    public boolean hasResolverHooks() {
        return this.registrations != null;
    }

    public boolean hasBundleRevision(BundleRevision brev) {
        return this.candidates != null && this.candidates.contains(brev);
    }

    public boolean hasResource(Resource res) {
        return this.candidates != null && this.candidates.contains(res);
    }

    public void begin(Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        processorAssociation.set(this);
        Collection<BundleRevision> triggers = new ArrayList<BundleRevision>();
        this.addTriggers(mandatory, triggers);
        this.addTriggers(optional, triggers);
        triggers = new RemoveOnlyCollection<BundleRevision>(triggers);
        if (this.registrations != null) {
            for (ResolverHookRegistration hookreg : this.registrations) {
                try {
                    ResolverHookFactory hookFactory = (ResolverHookFactory)this.syscontext.getService(hookreg.sref);
                    if (!hookreg.isRegistered()) continue;
                    hookreg.hook = hookFactory.begin(triggers);
                }
                catch (RuntimeException ex) {
                    hookreg.lastException = ex;
                    throw new ResolverHookException(ex);
                }
            }
        }
    }

    private void addTriggers(Collection<? extends Resource> resources, Collection<BundleRevision> triggers) {
        if (resources != null) {
            for (Resource resource : resources) {
                XBundleRevision brev = (XBundleRevision)resource;
                if (brev.getBundle().getState() == 1) continue;
                triggers.add(brev);
            }
        }
    }

    public void filterResolvable() {
        if (this.registrations != null) {
            for (ResolverHookRegistration hookreg : this.registrations) {
                try {
                    ResolverHook hook = hookreg.getResolverHook();
                    if (hook == null || hookreg.lastException != null) continue;
                    HashSet<BundleRevision> before = new HashSet<BundleRevision>(this.candidates);
                    hook.filterResolvable(this.candidates);
                    for (BundleRevision aux : before) {
                        if (this.candidates.contains(aux)) continue;
                        ResolverLogger.LOGGER.debugf("ResolverHook filtered resolvable: %s", aux);
                    }
                }
                catch (RuntimeException ex) {
                    hookreg.lastException = ex;
                    throw new ResolverHookException(ex);
                }
            }
        }
    }

    public void filterSingletonCollisions(SingletonLocator locator) {
        if (this.registrations != null) {
            HashMap<BundleCapability, Collection<BundleCapability>> collisionCandidates = new HashMap<BundleCapability, Collection<BundleCapability>>();
            for (BundleRevision bundleRevision : this.candidates) {
                BundleCapability bcap;
                List bcaps = bundleRevision.getDeclaredCapabilities("osgi.identity");
                if (bcaps.size() != 1 || !Boolean.parseBoolean((String)(bcap = (BundleCapability)bcaps.get(0)).getDirectives().get("singleton"))) continue;
                this.populateCollisionCandidates(bcap, collisionCandidates, locator);
            }
            for (Map.Entry entry : collisionCandidates.entrySet()) {
                BundleCapability bcap = (BundleCapability)entry.getKey();
                Collection collisions = (Collection)entry.getValue();
                HashSet<BundleCapability> reverse = new HashSet<BundleCapability>();
                for (BundleCapability aux : collisions) {
                    BundleRevision resource = aux.getResource();
                    BundleWiring wiring = (BundleWiring)resource.getBundle().adapt(BundleWiring.class);
                    if (wiring == null) continue;
                    reverse.add(aux);
                }
                if (this.processCollisionCandidates(bcap, collisions) && this.processReverseCollisionCandidates(bcap, reverse)) continue;
                BundleRevision brev = bcap.getResource();
                ResolverLogger.LOGGER.debugf("ResolverHook found singleton collision of %s with %s", bcap, collisions);
                ResolverLogger.LOGGER.debugf("ResolverHook removed resolution candidate %s", brev);
                this.candidates.remove(brev);
            }
        }
    }

    private boolean processReverseCollisionCandidates(BundleCapability bcap, Collection<BundleCapability> reverse) {
        for (BundleCapability aux : reverse) {
            HashSet<BundleCapability> collisions;
            if (this.processCollisionCandidates(aux, new RemoveOnlyCollection<BundleCapability>((Collection<BundleCapability>)(collisions = new HashSet<BundleCapability>(Collections.singleton(bcap)))))) continue;
            return false;
        }
        return true;
    }

    private boolean processCollisionCandidates(BundleCapability bcap, Collection<BundleCapability> collisions) {
        Iterator<BundleCapability> iterator = collisions.iterator();
        while (iterator.hasNext()) {
            BundleRevision brev = iterator.next().getResource();
            if (brev.getBundle().getState() != 2 || this.candidates.contains(brev)) continue;
            iterator.remove();
        }
        for (ResolverHookRegistration hookreg : this.registrations) {
            try {
                ResolverHook hook = hookreg.getResolverHook();
                if (hook == null || hookreg.lastException != null) continue;
                hook.filterSingletonCollisions(bcap, collisions);
            }
            catch (RuntimeException ex) {
                hookreg.lastException = ex;
                throw new ResolverHookException(ex);
            }
        }
        return collisions.isEmpty();
    }

    private void populateCollisionCandidates(BundleCapability bcap, Map<BundleCapability, Collection<BundleCapability>> map, SingletonLocator locator) {
        if (!map.containsKey(bcap)) {
            Collection<BundleCapability> candidates = locator.findCollisionCandidates(bcap);
            map.put(bcap, new RemoveOnlyCollection<BundleCapability>(candidates));
        }
    }

    public void filterMatches(BundleRequirement breq, Collection<BundleCapability> matching) {
        if (this.registrations != null) {
            for (ResolverHookRegistration hookreg : this.registrations) {
                try {
                    ResolverHook hook = hookreg.getResolverHook();
                    if (hook == null || hookreg.lastException != null) continue;
                    HashSet<BundleCapability> before = new HashSet<BundleCapability>(matching);
                    hook.filterMatches(breq, matching);
                    for (BundleCapability aux : before) {
                        if (matching.contains(aux)) continue;
                        ResolverLogger.LOGGER.debugf("ResolverHook filtered match: %s", aux);
                    }
                }
                catch (RuntimeException ex) {
                    hookreg.lastException = ex;
                    throw new ResolverHookException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ResolverHookException endException = null;
        try {
            if (this.registrations != null) {
                for (ResolverHookRegistration hookreg : this.registrations) {
                    try {
                        ResolverHook hook = hookreg.getResolverHook();
                        if (hook == null) continue;
                        hook.end();
                    }
                    catch (RuntimeException ex) {
                        hookreg.lastException = ex;
                        if (endException != null) continue;
                        endException = new ResolverHookException(ex);
                    }
                }
            }
        }
        finally {
            processorAssociation.remove();
        }
        if (endException != null) {
            throw endException;
        }
    }

    class ResolverHookRegistration {
        private final ServiceReference<ResolverHookFactory> sref;
        private RuntimeException lastException;
        private ResolverHook hook;

        ResolverHookRegistration(ServiceReference<ResolverHookFactory> sref) {
            this.sref = sref;
        }

        boolean isRegistered() {
            return ResolverHookProcessor.this.syscontext.getService(this.sref) != null;
        }

        ResolverHook getResolverHook() {
            if (!this.isRegistered()) {
                throw ResolverMessages.MESSAGES.illegalStateResolverHookUnregistered(this.sref);
            }
            return this.hook;
        }
    }

    public static interface SingletonLocator {
        public Collection<BundleCapability> findCollisionCandidates(BundleCapability var1);
    }
}

