/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.participant.at;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.jbossts.xts.recovery.XTSRecoveryModule;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;
import org.jboss.jbossts.xts.recovery.participant.at.ATParticipantRecoveryRecord;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManagerImple;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATSubordinateRecoveryModule;

public class ATParticipantRecoveryModule
implements XTSRecoveryModule {
    private XTSATSubordinateRecoveryModule subordinateRecoveryModule;
    private String _participantType = ATParticipantRecoveryRecord.type();
    private Vector _participantUidVector = null;
    private static RecoveryStore _recoveryStore = null;

    public ATParticipantRecoveryModule() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"ATParticipantRecoveryModule created - default");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._participantType = ATParticipantRecoveryRecord.type();
    }

    @Override
    public void install() {
        if (!XTSATRecoveryManagerImple.isRecoveryManagerInitialised()) {
            XTSATRecoveryManager.setRecoveryManager(new XTSATRecoveryManagerImple((TxLog)_recoveryStore));
        }
        this.subordinateRecoveryModule = new XTSATSubordinateRecoveryModule();
        XTSATRecoveryManager.getRecoveryManager().registerRecoveryModule(this.subordinateRecoveryModule);
    }

    @Override
    public void uninstall() {
        XTSATRecoveryManager.getRecoveryManager().unregisterRecoveryModule(this.subordinateRecoveryModule);
    }

    public void periodicWorkFirstPass() {
        boolean ATParticipants = false;
        InputObjectState acc_uids = new InputObjectState();
        try {
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)"ATParticipantRecoveryModule: first pass");
            }
            ATParticipants = _recoveryStore.allObjUids(this._participantType, acc_uids);
        }
        catch (ObjectStoreException ex) {
            RecoveryLogger.i18NLogger.warn_participant_at_ATParticipantRecoveryModule_1(ex);
        }
        if (ATParticipants) {
            this._participantUidVector = this.processParticipants(acc_uids);
        }
    }

    public void periodicWorkSecondPass() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"ATParticipantRecoveryModule: Second pass");
        }
        this.processParticipantsStatus();
    }

    private void doRecoverParticipant(Uid recoverUid) {
        block10: {
            XTSATRecoveryManager recoveryManager;
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)("participant type is " + this._participantType + " uid is " + recoverUid.toString()));
            }
            if (!(recoveryManager = XTSATRecoveryManager.getRecoveryManager()).isParticipantPresent(recoverUid)) {
                try {
                    InputObjectState inputState = _recoveryStore.read_committed(recoverUid, this._participantType);
                    if (inputState != null) {
                        try {
                            String participantRecordClazzName = inputState.unpackString();
                            try {
                                Class<?> participantRecordClazz = Class.forName(participantRecordClazzName);
                                ATParticipantRecoveryRecord participantRecord = (ATParticipantRecoveryRecord)participantRecordClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                participantRecord.restoreState(inputState);
                                XTSATRecoveryManager.getRecoveryManager().addParticipantRecoveryRecord(recoverUid, participantRecord);
                                break block10;
                            }
                            catch (ClassNotFoundException cnfe) {
                                RecoveryLogger.i18NLogger.error_participant_at_ATParticipantRecoveryModule_4(participantRecordClazzName, recoverUid, cnfe);
                                break block10;
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                RecoveryLogger.i18NLogger.error_participant_at_ATParticipantRecoveryModule_5(participantRecordClazzName, recoverUid, e);
                            }
                        }
                        catch (IOException ioe) {
                            RecoveryLogger.i18NLogger.error_participant_at_ATParticipantRecoveryModule_6(recoverUid, ioe);
                        }
                        break block10;
                    }
                    RecoveryLogger.i18NLogger.error_participant_at_ATParticipantRecoveryModule_7(recoverUid);
                }
                catch (ObjectStoreException ose) {
                    RecoveryLogger.i18NLogger.error_participant_at_ATParticipantRecoveryModule_8(recoverUid, ose);
                }
            }
        }
    }

    private Vector processParticipants(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("processing " + this._participantType + " WS-AT participants"));
        }
        Uid NULL_UID = Uid.nullUid();
        Uid theUid = null;
        while (true) {
            try {
                theUid = UidHelper.unpackFrom((InputBuffer)uids);
            }
            catch (Exception ex) {
                break;
            }
            if (theUid.equals(NULL_UID)) break;
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)("found WS-AT participant " + theUid));
            }
            uidVector.addElement(theUid);
        }
        return uidVector;
    }

    private void processParticipantsStatus() {
        if (this._participantUidVector != null) {
            Enumeration participantUidEnum = this._participantUidVector.elements();
            while (participantUidEnum.hasMoreElements()) {
                Uid currentUid = (Uid)participantUidEnum.nextElement();
                try {
                    if (_recoveryStore.currentState(currentUid, this._participantType) == -1) continue;
                    this.doRecoverParticipant(currentUid);
                }
                catch (ObjectStoreException ex) {
                    RecoveryLogger.i18NLogger.warn_participant_at_ATParticipantRecoveryModule_3(currentUid, ex);
                }
            }
        }
        XTSATRecoveryManager.getRecoveryManager().recoverParticipants();
    }
}

