/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.perf;

import io.narayana.perf.Averager;
import io.narayana.perf.RegressionChecker;
import io.narayana.perf.WorkerLifecycle;
import io.narayana.perf.WorkerWorkload;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Measurement<T>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(String.valueOf(Measurement.class));
    String name;
    int numberOfMeasurements = 1;
    int numberOfCalls;
    int numberOfThreads = 1;
    int batchSize = 1;
    private long maxTestTime = 0L;
    private int numberOfWarmupCalls = 0;
    private String info;
    RegressionChecker config;
    private T context;
    private final Set<T> contexts = new HashSet<T>();
    int numberOfErrors = 0;
    long totalMillis = 0L;
    int one = 0;
    double throughput = 0.0;
    private boolean cancelled;
    private boolean mayInterruptIfRunning;
    int numberOfBatches = 0;
    boolean regression;
    boolean failOnRegression;
    private Exception exception;

    public Measurement(int numberOfThreads, int numberOfCalls) {
        this(numberOfThreads, numberOfCalls, 10);
    }

    public Measurement(int numberOfThreads, int numberOfCalls, int batchSize) {
        this(0L, numberOfThreads, numberOfCalls, batchSize);
    }

    public Measurement(long maxTestTime, int numberOfThreads, int numberOfCalls, int batchSize) {
        this(new Builder("").maxTestTime(maxTestTime).numberOfThreads(numberOfThreads).numberOfCalls(numberOfCalls).batchSize(batchSize).construct());
    }

    public Measurement(Measurement result) {
        this(result.maxTestTime, result.numberOfThreads, result.numberOfCalls, result.batchSize);
    }

    private Measurement(Builder builder) {
        this.name = builder.name;
        this.numberOfMeasurements = builder.numberOfMeasurements;
        this.numberOfCalls = builder.numberOfCalls;
        this.numberOfThreads = builder.numberOfThreads;
        this.batchSize = builder.batchSize;
        this.maxTestTime = builder.maxTestTime;
        this.numberOfWarmupCalls = builder.numberOfWarmupCalls;
        this.numberOfBatches = builder.numberOfBatches;
        this.config = builder.config;
        this.info = builder.info;
        this.failOnRegression = this.config == null ? false : this.config.isFailOnRegression();
    }

    public boolean isRegression() {
        return this.regression;
    }

    public boolean isFailOnRegression() {
        return this.failOnRegression;
    }

    public boolean shouldFail() {
        return this.isFailOnRegression() && this.isRegression();
    }

    public void setRegression(boolean regression) {
        this.regression = regression;
    }

    public void setContext(T value) {
        this.context = value;
    }

    public T getContext() {
        return this.context;
    }

    public Set<T> getContexts() {
        return this.contexts;
    }

    void addContext(T t) {
        this.contexts.add(t);
    }

    public int getNumberOfMeasurements() {
        return this.numberOfMeasurements;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    void setNumberOfCalls(int numberOfCalls) {
        this.numberOfCalls = numberOfCalls;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    int getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public long getTotalMillis() {
        return this.totalMillis;
    }

    public long getOne() {
        return this.one;
    }

    public void setTotalMillis(long totalMillis) {
        this.totalMillis = totalMillis;
        if (totalMillis != 0L) {
            this.one = totalMillis > 0L ? (int)(totalMillis / (long)this.numberOfCalls) : 0;
            this.throughput = 1000.0 * (double)this.numberOfCalls / (double)totalMillis;
        }
    }

    public double getThroughput() {
        return this.throughput;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public void incrementErrorCount() {
        ++this.numberOfErrors;
    }

    public void incrementErrorCount(int delta) {
        this.numberOfErrors += delta;
    }

    public String toString() {
        return String.format("%f calls / second (%d calls in %d ms using %d threads. %d errors)", this.getThroughput(), this.getNumberOfCalls(), this.getTotalMillis(), this.getNumberOfThreads(), this.getNumberOfErrors());
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        this.mayInterruptIfRunning = mayInterruptIfRunning;
    }

    public void cancel(String reason, boolean mayInterruptIfRunning) {
        this.setInfo(reason);
        this.cancelled = true;
        this.mayInterruptIfRunning = mayInterruptIfRunning;
    }

    void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isMayInterruptIfRunning() {
        return this.mayInterruptIfRunning;
    }

    public long getMaxTestTime() {
        return this.maxTestTime;
    }

    public int getNumberOfWarmupCalls() {
        return this.numberOfWarmupCalls;
    }

    public boolean isTimedOut() {
        return this.isCancelled() || this.getTotalMillis() > this.maxTestTime;
    }

    public Measurement<T> measure(WorkerWorkload<T> workload) {
        return this.measure(null, workload);
    }

    public Measurement<T> measure(WorkerLifecycle<T> lifecycle, WorkerWorkload<T> workload) {
        if (workload == null) {
            throw new IllegalArgumentException("workload must not be null");
        }
        if (lifecycle != null) {
            lifecycle.init();
        }
        if (this.numberOfWarmupCalls > 0) {
            System.out.printf("Test Warm Up: %s: (%d calls using %d threads)%n", this.name, this.numberOfWarmupCalls, this.numberOfThreads);
            this.doWork(workload, new Measurement<T>(this.maxTestTime, 1, this.numberOfWarmupCalls, 1));
        }
        System.out.printf("Test Run: %s (%d calls using %d threads)%n", this.name, this.numberOfCalls, this.numberOfThreads);
        if (this.config == null) {
            for (int i = 0; i < this.numberOfMeasurements; ++i) {
                this.doWork(workload, this);
            }
        } else {
            boolean wasFailOnRegression = this.config.isFailOnRegression();
            ArrayList<Double> metrics = new ArrayList<Double>();
            if (wasFailOnRegression) {
                this.config.setFailOnRegression(false);
                this.failOnRegression = false;
            }
            for (int i = 0; i < this.numberOfMeasurements; ++i) {
                this.doWork(workload, this);
                metrics.add(this.getThroughput());
            }
            this.config.setFailOnRegression(wasFailOnRegression);
            this.failOnRegression = wasFailOnRegression;
            this.throughput = Averager.getAverage(metrics);
        }
        if (lifecycle != null) {
            lifecycle.fini();
        }
        StringBuilder sb = new StringBuilder();
        if (this.config != null) {
            this.setRegression(!this.config.updateMetric(sb, this.name, this.getThroughput(), true));
        }
        this.setInfo(sb.toString());
        return this;
    }

    private Measurement<T> doWork(final WorkerWorkload<T> workload, final Measurement<T> opts) {
        ExecutorService executor = Executors.newFixedThreadPool(opts.getNumberOfThreads());
        final AtomicInteger count = new AtomicInteger(opts.getNumberOfBatches());
        final ArrayList tasks = new ArrayList();
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(opts.getNumberOfThreads() + 1);
        this.totalMillis = 0L;
        for (int i = 0; i < opts.getNumberOfThreads(); ++i) {
            tasks.add(executor.submit(new Callable<Measurement<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Measurement<T> call() throws Exception {
                    Measurement res = new Measurement(opts.getMaxTestTime(), opts.getNumberOfThreads(), opts.getNumberOfCalls(), opts.getBatchSize());
                    int errorCount = 0;
                    try {
                        cyclicBarrier.await();
                        long start = System.nanoTime();
                        while (count.decrementAndGet() >= 0) {
                            res.setNumberOfCalls(opts.getBatchSize());
                            try {
                                res.setContext(workload.doWork(res.getContext(), opts.getBatchSize(), res));
                                errorCount += res.getNumberOfErrors();
                            }
                            catch (Exception e) {
                                if (res.getException() == null) {
                                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                                }
                                res.setException(e);
                                errorCount += opts.getBatchSize();
                                res.setCancelled(true);
                            }
                            if (!res.isCancelled()) continue;
                            for (Future task : tasks) {
                                if (task.equals(this)) continue;
                                task.cancel(res.isMayInterruptIfRunning());
                            }
                            opts.setContext(res.getContext());
                            if (res.getException() == null) break;
                            opts.setException(res.getException());
                            break;
                        }
                        cyclicBarrier.await();
                        res.setTotalMillis((System.nanoTime() - start) / 1000000L);
                        if (res.getTotalMillis() < 0L) {
                            res.setTotalMillis(-res.getTotalMillis());
                        }
                        res.setNumberOfErrors(errorCount);
                    }
                    finally {
                        workload.finishWork(res);
                    }
                    return res;
                }
            }));
        }
        opts.setNumberOfErrors(0);
        long start = System.nanoTime();
        try {
            cyclicBarrier.await();
            if (opts.getMaxTestTime() > 0L) {
                cyclicBarrier.await(opts.getMaxTestTime(), TimeUnit.MILLISECONDS);
            } else {
                cyclicBarrier.await();
            }
            long tot = System.nanoTime() - start;
            if (tot < 0L) {
                tot = -tot;
            }
            opts.setTotalMillis(tot / 1000000L);
        }
        catch (InterruptedException e) {
            opts.incrementErrorCount();
            throw new RuntimeException(e);
        }
        catch (BrokenBarrierException e) {
            opts.incrementErrorCount();
            opts.setCancelled(true);
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            opts.incrementErrorCount();
            opts.setCancelled(true);
            throw new RuntimeException(e);
        }
        for (Future future : tasks) {
            try {
                Measurement outcome = (Measurement)future.get();
                T context = outcome.getContext();
                if (context != null) {
                    opts.addContext(context);
                }
                if (outcome.getException() != null) {
                    opts.setException(outcome.getException());
                }
                opts.incrementErrorCount(outcome.getNumberOfErrors());
            }
            catch (CancellationException e) {
                opts.incrementErrorCount(opts.getBatchSize());
                opts.setCancelled(true);
            }
            catch (ExecutionException e) {
                System.out.printf("ExecutionException exception: %s%n", e.getMessage());
                opts.incrementErrorCount(opts.getBatchSize());
                opts.setCancelled(true);
            }
            catch (Exception e) {
                System.err.printf("Performance test exception: %s%n", e.getMessage());
                opts.incrementErrorCount(opts.getBatchSize());
            }
        }
        executor.shutdownNow();
        return opts;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public static final class Builder<T> {
        private String name;
        private int numberOfCalls = 10;
        private int numberOfThreads = 1;
        private int batchSize = 1;
        private long maxTestTime = 0L;
        private int numberOfWarmupCalls = 0;
        private int numberOfBatches;
        private int numberOfMeasurements = 1;
        private String info;
        RegressionChecker config;

        public Builder(String name) {
            this.name(name);
        }

        public Builder name(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name must be null");
            }
            this.name = name;
            return this;
        }

        public Builder numberOfMeasurements(int numberOfMeasurements) {
            this.numberOfMeasurements = numberOfMeasurements;
            return this;
        }

        public Builder numberOfCalls(int numberOfCalls) {
            this.numberOfCalls = numberOfCalls;
            return this;
        }

        public Builder numberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder maxTestTime(long maxTestTime) {
            this.maxTestTime = maxTestTime;
            return this;
        }

        public Builder numberOfWarmupCalls(int numberOfWarmupCalls) {
            this.numberOfWarmupCalls = numberOfWarmupCalls;
            return this;
        }

        public Builder info(String info) {
            this.info = info;
            return this;
        }

        public Builder config() throws IOException {
            return this.config(new RegressionChecker());
        }

        public Builder config(RegressionChecker config) {
            this.config = config;
            return this;
        }

        private Builder construct() {
            if (this.config == null && RegressionChecker.isRegressionCheckEnabled()) {
                try {
                    this.config = new RegressionChecker();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.config != null) {
                String[] xargs = this.config.getTestArgs(this.name);
                this.numberOfMeasurements = this.config.getArg(this.name, xargs, 0, this.numberOfMeasurements, Integer.class);
                this.maxTestTime = this.config.getArg(this.name, xargs, 1, this.maxTestTime, Long.class);
                this.numberOfWarmupCalls = this.config.getArg(this.name, xargs, 2, this.numberOfWarmupCalls, Integer.class);
                this.numberOfCalls = this.config.getArg(this.name, xargs, 3, this.numberOfCalls, Integer.class);
                this.numberOfThreads = this.config.getArg(this.name, xargs, 4, this.numberOfThreads, Integer.class);
                this.batchSize = this.config.getArg(this.name, xargs, 5, this.batchSize, Integer.class);
            }
            if (this.batchSize <= 0) {
                System.err.printf("Invalid batch size (%d) setting to 1%n", this.batchSize);
                this.batchSize = 1;
            }
            if (this.numberOfCalls < this.batchSize) {
                System.err.println("Updating call count (request size less than batch size)");
                this.numberOfCalls = this.batchSize;
            }
            this.numberOfBatches = this.numberOfCalls / this.batchSize;
            if (this.numberOfBatches < this.numberOfThreads) {
                System.err.printf("Too few batches - reducing thread count (%d %d %d)%n", this.numberOfThreads, this.numberOfBatches, this.numberOfCalls);
                this.numberOfThreads = this.numberOfBatches;
            }
            return this;
        }

        public <T> Measurement<T> build() {
            this.construct();
            return new Measurement(this);
        }
    }
}

