/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.perf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Averager {
    public static void main(String[] args) {
        Double[][] tests;
        for (Double[] vals : tests = new Double[][]{{2.0, 5.0, 6.0, 9.0, 12.0}, {2.0, 5.0, 6.0, 9.0, 12.0, 26.0}, {2.0}}) {
            ArrayList<Double> v1 = new ArrayList<Double>(Arrays.asList(vals));
            ArrayList<Double> v2 = new ArrayList<Double>(Arrays.asList(vals));
            double median = Averager.getMedian(v1, 0, v1.size() - 1);
            double q1 = Averager.getQ1(v1);
            double q3 = Averager.getQ3(v1);
            Averager.removeOutliers(v1);
            for (Double d : v2) {
                System.out.printf("%f, ", d);
            }
            System.out.printf("%nq1=%f q2=%f median=%f%n", q1, q3, median);
            System.out.printf("Outliers:%n", new Object[0]);
            for (Double d : v2) {
                if (v1.contains(d)) continue;
                System.out.printf("\t%f%n", d);
            }
        }
    }

    static double getAverage(List<Double> values) {
        double tot = 0.0;
        for (Double d : values) {
            tot += d.doubleValue();
        }
        return tot / (double)values.size();
    }

    static void removeOutliers(List<Double> values) {
        Collections.sort(values);
        double q1 = Averager.getQ1(values);
        double q3 = Averager.getQ3(values);
        double iqr = q3 - q1;
        double outlier = 1.5 * iqr;
        double lb = q1 - outlier;
        double ub = q3 + outlier;
        Iterator<Double> i = values.iterator();
        while (i.hasNext()) {
            double value = i.next();
            if (!(value < lb) && !(value > ub)) continue;
            i.remove();
        }
    }

    static Double getMedian(List<Double> values, int from, int to) {
        int sz = to - from + 1;
        if (sz % 2 == 0) {
            return (values.get(from + sz / 2) + values.get(from + sz / 2 - 1)) / 2.0;
        }
        return values.get(from + sz / 2);
    }

    static double getQ1(List<Double> values) {
        int sz = values.size();
        if (sz == 1) {
            return values.get(0);
        }
        if (sz % 2 == 0) {
            return Averager.getMedian(values, 0, sz / 2 - 1);
        }
        return Averager.getMedian(values, 0, sz / 2 - 1);
    }

    static double getQ3(List<Double> values) {
        int sz = values.size();
        if (sz == 1) {
            return values.get(0);
        }
        if (sz % 2 == 0) {
            return Averager.getMedian(values, sz / 2, sz - 1);
        }
        return Averager.getMedian(values, sz / 2 + 1, sz - 1);
    }
}

