/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.tm.listener.EventType;
import org.jboss.tm.listener.TransactionEvent;
import org.jboss.tm.listener.TransactionListener;
import org.jboss.tm.listener.TransactionListenerRegistry;
import org.jboss.tm.listener.TransactionTypeNotSupported;

public abstract class BaseTransactionManagerDelegate
implements TransactionManager,
TransactionLocalDelegate,
TransactionTimeoutConfiguration,
TransactionListenerRegistry {
    private static final String LISTENER_MAP_KEY = "__TX_LISTENERS";
    private final TransactionManager transactionManager;
    private final String LOCKS_MAP = "__LOCKS_MAP";

    protected BaseTransactionManagerDelegate(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.notifyAssociationListeners(this.getTransaction(), EnumSet.of(EventType.DISASSOCIATING));
        this.transactionManager.commit();
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.transactionManager.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction == null) {
            this.suspend();
        } else {
            this.transactionManager.resume(transaction);
            this.notifyAssociationListeners(transaction, EnumSet.of(EventType.ASSOCIATED));
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.notifyAssociationListeners(this.getTransaction(), EnumSet.of(EventType.DISASSOCIATING));
        this.transactionManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.transactionManager.setTransactionTimeout(timeout);
    }

    public void addListener(Transaction transaction, TransactionListener listener, EnumSet<EventType> types) throws TransactionTypeNotSupported {
        if (transaction == null) {
            throw new NullPointerException();
        }
        if (!(transaction instanceof com.arjuna.ats.jta.transaction.Transaction)) {
            throw new TransactionTypeNotSupported("Unsupported transaction type");
        }
        Collection<TransactionListener> listeners = this.getListeners(transaction, true);
        if (listeners != null) {
            listeners.add(listener);
            try {
                if (transaction.equals(this.getTransaction()) && types.contains(EventType.ASSOCIATED)) {
                    listener.onEvent(new TransactionEvent(transaction, EnumSet.of(EventType.ASSOCIATED)));
                }
            }
            catch (SystemException e) {
                // empty catch block
            }
        }
    }

    public Transaction suspend() throws SystemException {
        if (this.getStatus() != 6) {
            this.notifyAssociationListeners(this.getTransaction(), EnumSet.of(EventType.DISASSOCIATING));
        }
        return this.transactionManager.suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TransactionListener> getListeners(Transaction transaction, boolean create) {
        Object resource;
        com.arjuna.ats.jta.transaction.Transaction txn = (com.arjuna.ats.jta.transaction.Transaction)transaction;
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            resource = txn.getTxLocalResource((Object)LISTENER_MAP_KEY);
            if (resource == null && create) {
                ConcurrentLinkedQueue<TransactionListener> listeners = new ConcurrentLinkedQueue<TransactionListener>();
                txn.putTxLocalResource((Object)LISTENER_MAP_KEY, listeners);
                return listeners;
            }
        }
        if (resource != null && !(resource instanceof ConcurrentLinkedQueue)) {
            throw new IllegalStateException("Invalid transaction local resource associated with key");
        }
        return (Collection)resource;
    }

    private void notifyAssociationListeners(Transaction transaction, EnumSet<EventType> reasons) {
        if (transaction != null) {
            Collection<TransactionListener> listeners = this.getListeners(transaction, false);
            TransactionEvent event = new TransactionEvent(transaction, reasons);
            if (listeners != null) {
                for (TransactionListener s : listeners) {
                    s.onEvent(event);
                }
            }
        }
    }

    public boolean containsValue(TransactionLocal transactionLocal, Transaction transaction) {
        com.arjuna.ats.jta.transaction.Transaction transactionImple = (com.arjuna.ats.jta.transaction.Transaction)transaction;
        if (transactionImple.isAlive()) {
            return transactionImple.getTxLocalResource((Object)transactionLocal) != null;
        }
        return false;
    }

    public Object getValue(TransactionLocal transactionLocal, Transaction transaction) {
        com.arjuna.ats.jta.transaction.Transaction transactionImple = (com.arjuna.ats.jta.transaction.Transaction)transaction;
        if (transactionImple.isAlive()) {
            return transactionImple.getTxLocalResource((Object)transactionLocal);
        }
        return null;
    }

    public void storeValue(TransactionLocal transactionLocal, Transaction transaction, Object value) {
        com.arjuna.ats.jta.transaction.Transaction transactionImple = (com.arjuna.ats.jta.transaction.Transaction)transaction;
        if (!transactionImple.isAlive()) {
            throw new IllegalStateException("Can't store value in a TransactionLocal after the Transaction has ended");
        }
        transactionImple.putTxLocalResource((Object)transactionLocal, value);
    }

    public void lock(TransactionLocal local, Transaction transaction) throws InterruptedException {
        TransactionLocalLock lock;
        com.arjuna.ats.jta.transaction.Transaction transactionImple = (com.arjuna.ats.jta.transaction.Transaction)transaction;
        if (transactionImple.isAlive() && (lock = this.findLock(local, transaction)).lock(transactionImple)) {
            return;
        }
        throw new IllegalStateException("Can't lock a TransactionLocal after the Transaction has ended");
    }

    public void unlock(TransactionLocal local, Transaction transaction) {
        TransactionLocalLock lock = this.findLock(local, transaction);
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private TransactionLocalLock findLock(TransactionLocal local, Transaction transaction) {
        TransactionLocalLock transactionLocalLock;
        com.arjuna.ats.jta.transaction.Transaction transactionImple = (com.arjuna.ats.jta.transaction.Transaction)transaction;
        HashMap<TransactionLocal, TransactionLocalLock> locks = (HashMap<TransactionLocal, TransactionLocalLock>)transactionImple.getTxLocalResource((Object)"__LOCKS_MAP");
        if (locks == null) {
            String string = "__LOCKS_MAP";
            // MONITORENTER : "__LOCKS_MAP"
            locks = (Map)transactionImple.getTxLocalResource((Object)"__LOCKS_MAP");
            if (locks == null) {
                locks = new HashMap<TransactionLocal, TransactionLocalLock>();
                transactionImple.putTxLocalResource((Object)"__LOCKS_MAP", locks);
            }
            // MONITOREXIT : string
        }
        if ((transactionLocalLock = (TransactionLocalLock)locks.get(local)) != null) return transactionLocalLock;
        HashMap<TransactionLocal, TransactionLocalLock> hashMap = locks;
        // MONITORENTER : hashMap
        transactionLocalLock = (TransactionLocalLock)locks.get(local);
        if (transactionLocalLock == null) {
            transactionLocalLock = new TransactionLocalLock();
            locks.put(local, transactionLocalLock);
        }
        // MONITOREXIT : hashMap
        return transactionLocalLock;
    }

    private class TransactionLocalLock {
        private Thread lockingThread;
        private int lockCount;
        private byte[] lock = new byte[0];

        private TransactionLocalLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lock(com.arjuna.ats.jta.transaction.Transaction tx) {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                Thread currentThread = Thread.currentThread();
                if (currentThread == this.lockingThread) {
                    ++this.lockCount;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                while (this.lockingThread != null) {
                    try {
                        long timeout = 0L;
                        try {
                            timeout = BaseTransactionManagerDelegate.this.getTransactionTimeout();
                        }
                        catch (SystemException e) {
                            // empty catch block
                        }
                        this.lock.wait(timeout + 1000L);
                        if (tx.isAlive()) continue;
                        this.lockingThread = null;
                        this.lockCount = 0;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                this.lockingThread = currentThread;
                ++this.lockCount;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                if (this.lockCount == 0 && this.lockingThread == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                Thread currentThread = Thread.currentThread();
                if (currentThread != this.lockingThread) {
                    throw new IllegalStateException("Unlock called from wrong thread.  Locking thread: " + this.lockingThread + ", current thread: " + currentThread);
                }
                if (--this.lockCount == 0) {
                    this.lockingThread = null;
                    this.lock.notify();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

