/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.internal.jdbc.IsSameRMOverrideXAResource;
import com.arjuna.ats.internal.jdbc.TransactionalDriverXAConnection;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.jndi;
import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class IndirectRecoverableConnection
implements RecoverableXAConnection,
ConnectionControl,
TransactionalDriverXAConnection {
    private String _dbName;
    private String _user;
    private String _passwd;
    private XAConnection _theConnection;
    private XADataSource _theDataSource;
    private XAResource _theXAResource;
    private Transaction _theTransaction;
    private ConnectionImple _theArjunaConnection;
    private ConnectionModifier _theModifier;

    public IndirectRecoverableConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.IndirectRecoverableConnection ()");
        }
        this._dbName = null;
        this._user = null;
        this._passwd = null;
        this._theConnection = null;
        this._theDataSource = null;
        this._theXAResource = null;
        this._theTransaction = null;
        this._theArjunaConnection = null;
        this._theModifier = null;
    }

    public IndirectRecoverableConnection(String dbName, String user, String passwd, ConnectionImple conn) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("IndirectRecoverableConnection.IndirectRecoverableConnection ( " + dbName + ", " + user + ", " + passwd + " )"));
        }
        this._dbName = dbName;
        this._user = user;
        this._passwd = passwd;
        this._theConnection = null;
        this._theDataSource = null;
        this._theXAResource = null;
        this._theTransaction = null;
        this._theArjunaConnection = conn;
        jndi jndiModifier = new jndi();
        this._dbName = jndiModifier.initialise(this._dbName);
        this._theModifier = null;
        this.createDataSource();
    }

    public void finalize() {
        try {
            if (this._theConnection != null) {
                this._theConnection.close();
                this._theConnection = null;
            }
        }
        catch (SQLException e) {
            jdbcLogger.i18NLogger.warn_drcdest(e);
        }
    }

    @Override
    public boolean packInto(OutputObjectState os) {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.packInto ()");
        }
        try {
            os.packString(this._dbName);
            os.packString(this._user);
            os.packString(this._passwd);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean unpackFrom(InputObjectState os) {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.unpackFrom ()");
        }
        try {
            this._dbName = os.unpackString();
            this._user = os.unpackString();
            this._passwd = os.unpackString();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    @Override
    public XAResource getResource() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.getResource ()");
        }
        try {
            if (this._theXAResource == null) {
                this._theXAResource = this._theModifier != null && this._theModifier.requiresSameRMOverride() ? new IsSameRMOverrideXAResource(this.getConnection().getXAResource()) : this.getConnection().getXAResource();
            }
            return this._theXAResource;
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    @Override
    public final void close() {
        this.reset();
    }

    @Override
    public final void reset() {
        this._theXAResource = null;
        this._theTransaction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransaction(Transaction tx) {
        IndirectRecoverableConnection indirectRecoverableConnection = this;
        synchronized (indirectRecoverableConnection) {
            if (this._theTransaction == null) {
                this._theTransaction = tx;
                return true;
            }
        }
        return this.validTransaction(tx);
    }

    @Override
    public boolean validTransaction(Transaction tx) {
        boolean valid = true;
        if (this._theTransaction != null) {
            valid = this._theTransaction.equals(tx);
        }
        return valid;
    }

    @Override
    public XAConnection getCurrentConnection() throws SQLException {
        return this._theConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCloseCurrentConnection() throws SQLException {
        IndirectRecoverableConnection indirectRecoverableConnection = this;
        synchronized (indirectRecoverableConnection) {
            if (this._theConnection != null) {
                this._theConnection.close();
                this._theConnection = null;
                this._theXAResource = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAConnection getConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.getConnection ()");
        }
        try {
            IndirectRecoverableConnection indirectRecoverableConnection = this;
            synchronized (indirectRecoverableConnection) {
                if (this._theConnection == null) {
                    this.createConnection();
                }
            }
            return this._theConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    @Override
    public XADataSource getDataSource() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.getDataSource ()");
        }
        return this._theDataSource;
    }

    @Override
    public boolean inuse() {
        return this._theXAResource != null;
    }

    @Override
    public String user() {
        return this._user;
    }

    @Override
    public String password() {
        return this._passwd;
    }

    @Override
    public String url() {
        return this._dbName;
    }

    @Override
    public String dynamicClass() {
        return "";
    }

    @Override
    public String dataSourceName() {
        if (this._theDataSource != null) {
            return this._theDataSource.toString();
        }
        return "";
    }

    @Override
    public Transaction transaction() {
        return this._theTransaction;
    }

    @Override
    public void setModifier(ConnectionModifier cm) {
        this._theModifier = cm;
        if (this._theModifier != null) {
            this._dbName = this._theModifier.initialise(this._dbName);
        }
    }

    @Override
    public XADataSource xaDataSource() {
        return this._theDataSource;
    }

    private final void createDataSource() throws SQLException {
        try {
            if (this._theDataSource == null) {
                Hashtable env = jdbcPropertyManager.getJDBCEnvironmentBean().getJndiProperties();
                InitialContext ctx = new InitialContext(env);
                this._theDataSource = (XADataSource)ctx.lookup(this._dbName);
            }
            if (this._theDataSource == null) {
                throw new SQLException(jdbcLogger.i18NLogger.get_jndierror());
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            jdbcLogger.logger.error((Object)e);
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    private final void createConnection() throws SQLException {
        try {
            if (this._theDataSource == null) {
                this.createDataSource();
            }
            this._theConnection = (this._user == null || this._user.isEmpty()) && (this._passwd == null || this._passwd.isEmpty()) ? this._theDataSource.getXAConnection() : this._theDataSource.getXAConnection(this._user, this._passwd);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    private final String translate(String name) {
        try {
            if (name.equals("Context.APPLET")) {
                return "java.naming.applet";
            }
            if (name.equals("Context.AUTHORITATIVE")) {
                return "java.naming.authoritative";
            }
            if (name.equals("Context.BATCHSIZE")) {
                return "java.naming.batchsize";
            }
            if (name.equals("Context.DNS_URL")) {
                return "java.naming.dns.url";
            }
            if (name.equals("Context.INITIAL_CONTEXT_FACTORY")) {
                return "java.naming.factory.initial";
            }
            if (name.equals("Context.LANGUAGE")) {
                return "java.naming.language";
            }
            if (name.equals("Context.OBJECT_FACTORIES")) {
                return "java.naming.factory.object";
            }
            if (name.equals("Context.PROVIDER_URL")) {
                return "java.naming.provider.url";
            }
            if (name.equals("Context.REFERRAL")) {
                return "java.naming.referral";
            }
            if (name.equals("Context.SECURITY_AUTHENTICATION")) {
                return "java.naming.security.authentication";
            }
            if (name.equals("Context.SECURITY_CREDENTIALS")) {
                return "java.naming.security.credentials";
            }
            if (name.equals("Context.SECURITY_PRINCIPAL")) {
                return "java.naming.security.principal";
            }
            if (name.equals("Context.SECURITY_PROTOCOL")) {
                return "java.naming.security.protocol";
            }
            if (name.equals("Context.STATE_FACTORIES")) {
                return "java.naming.factory.state";
            }
            if (name.equals("Context.URL_PKG_PREFIXES")) {
                return "java.naming.factory.url.pkgs";
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return name;
    }
}

