/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateXidImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TransactionImporterImple
implements TransactionImporter {
    private static ConcurrentHashMap<SubordinateXidImple, AtomicReference<TransactionImple>> _transactions = new ConcurrentHashMap();

    @Override
    public SubordinateTransaction importTransaction(Xid xid) throws XAException {
        return this.importTransaction(xid, 0);
    }

    @Override
    public SubordinateTransaction importTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        return this.addImportedTransaction(null, this.convertXid(xid), xid, timeout);
    }

    @Override
    public TransactionImple recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple recovered = new TransactionImple(actId);
        if (recovered.baseXid() == null) {
            throw new IllegalArgumentException();
        }
        return this.addImportedTransaction(recovered, recovered.baseXid(), null, 0);
    }

    @Override
    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        TransactionImple tx;
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        AtomicReference<TransactionImple> holder = _transactions.get(new SubordinateXidImple(xid));
        TransactionImple transactionImple = tx = holder == null ? null : holder.get();
        if (tx == null) {
            return null;
        }
        try {
            if (tx.getStatus() == 4) {
                throw new XAException(100);
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
            throw new XAException(100);
        }
        if (!tx.activated()) {
            tx.recover();
            return tx;
        }
        return tx;
    }

    @Override
    public void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        _transactions.remove(new SubordinateXidImple(xid));
    }

    public Set<Xid> getInflightXids(String parentNodeName) {
        Iterator<AtomicReference<TransactionImple>> iterator = _transactions.values().iterator();
        HashSet<Xid> toReturn = new HashSet<Xid>();
        while (iterator.hasNext()) {
            AtomicReference<TransactionImple> holder = iterator.next();
            TransactionImple imported = holder.get();
            if (imported == null || !imported.getParentNodeName().equals(parentNodeName)) continue;
            toReturn.add(imported.baseXid());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionImple addImportedTransaction(TransactionImple importedTransaction, Xid mapKey, Xid xid, int timeout) {
        TransactionImple txn;
        SubordinateXidImple importedXid = new SubordinateXidImple(mapKey);
        AtomicReference<TransactionImple> holder = new AtomicReference<TransactionImple>();
        AtomicReference existing = _transactions.putIfAbsent(importedXid, holder);
        if (existing != null) {
            holder = existing;
        }
        if ((txn = (TransactionImple)holder.get()) == null) {
            AtomicReference<TransactionImple> atomicReference = holder;
            synchronized (atomicReference) {
                txn = (TransactionImple)holder.get();
                if (txn == null) {
                    if (importedTransaction != null) {
                        importedTransaction.recordTransaction();
                        txn = importedTransaction;
                    } else {
                        txn = new TransactionImple(timeout, xid);
                    }
                    holder.set(txn);
                }
            }
        }
        return txn;
    }

    private XidImple convertXid(Xid xid) {
        if (xid != null && xid.getFormatId() == 131077) {
            XidImple toImport = new XidImple(xid);
            XATxConverter.setSubordinateNodeName(toImport.getXID(), TxControl.getXANodeName());
            return new XidImple(toImport);
        }
        return new XidImple(xid);
    }
}

