/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.xa;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecordWrappingPlugin;
import com.arjuna.ats.internal.jta.xa.XID;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XATxConverter {
    private static XAResourceRecordWrappingPlugin xaResourceRecordWrappingPlugin = jtaPropertyManager.getJTAEnvironmentBean().getXAResourceRecordWrappingPlugin();
    public static final int FORMAT_ID = 131077;

    static XID getXid(Uid uid, boolean branch, Integer eisName) throws IllegalStateException {
        if (branch) {
            return XATxConverter.getXid(uid, new Uid(), 131077, eisName);
        }
        return XATxConverter.getXid(uid, Uid.nullUid(), 131077, eisName);
    }

    public static Xid getXid(Uid uid, boolean branch, int formatId) throws IllegalStateException {
        XID xid = branch ? XATxConverter.getXid(uid, new Uid(), formatId, null) : XATxConverter.getXid(uid, Uid.nullUid(), formatId, null);
        return new XidImple(xid);
    }

    private static XID getXid(Uid uid, Uid branch, int formatId, Integer eisName) throws IllegalStateException {
        if (uid == null) {
            throw new IllegalStateException();
        }
        XID xid = new XID();
        xid.formatID = formatId;
        byte[] gtridUid = uid.getBytes();
        if (gtridUid.length > 64) {
            throw new IllegalStateException();
        }
        String nodeName = TxControl.getXANodeName();
        if (nodeName == null) {
            throw new IllegalStateException(jtaLogger.i18NLogger.get_nodename_null());
        }
        int nodeNameLengthToUse = nodeName.getBytes().length;
        xid.gtrid_length = gtridUid.length + nodeNameLengthToUse;
        System.arraycopy(gtridUid, 0, xid.data, 0, gtridUid.length);
        System.arraycopy(nodeName.getBytes(), 0, xid.data, gtridUid.length, nodeNameLengthToUse);
        if (branch.notEquals(Uid.nullUid())) {
            byte[] bqualUid = branch.getBytes();
            if (bqualUid.length > 64) {
                throw new IllegalStateException();
            }
            int spareBqualBytes = 64 - (bqualUid.length + 4);
            xid.bqual_length = bqualUid.length + 4 + 4;
            int offset = xid.gtrid_length;
            System.arraycopy(bqualUid, 0, xid.data, offset, bqualUid.length);
            XATxConverter.setEisName(xid, eisName);
        } else {
            xid.data[xid.gtrid_length] = 0;
            xid.bqual_length = 64;
        }
        return xid;
    }

    public static Uid getUid(XID xid) {
        if (xid == null || xid.formatID != 131077) {
            return Uid.nullUid();
        }
        Uid tx = new Uid(xid.data);
        return tx;
    }

    public static String getNodeName(XID xid) {
        if (xid.formatID != 131077 && xid.formatID != 131072 && xid.formatID != 131080) {
            return null;
        }
        XidImple xidImple = new XidImple(xid);
        byte[] globalTransactionId = xidImple.getGlobalTransactionId();
        int offset = 28;
        return new String(Arrays.copyOfRange(globalTransactionId, offset, globalTransactionId.length));
    }

    public static void setSubordinateNodeName(XID theXid, String xaNodeName) {
        if (theXid == null || theXid.formatID != 131077) {
            return;
        }
        int length = 0;
        if (xaNodeName != null) {
            length = xaNodeName.length();
        }
        int offset = theXid.gtrid_length + 28 + 4;
        theXid.data[offset++] = (byte)(length >>> 24);
        theXid.data[offset++] = (byte)(length >>> 16);
        theXid.data[offset++] = (byte)(length >>> 8);
        theXid.data[offset++] = (byte)(length >>> 0);
        if (length > 0) {
            byte[] nameAsBytes = xaNodeName.getBytes();
            System.arraycopy(nameAsBytes, 0, theXid.data, offset, length);
        }
        theXid.bqual_length = 36 + length;
    }

    public static String getSubordinateNodeName(XID xid) {
        int length;
        if (xid.formatID != 131077) {
            return null;
        }
        XidImple xidImple = new XidImple(xid);
        byte[] branchQualifier = xidImple.getBranchQualifier();
        int offset = 32;
        if ((length = (branchQualifier[offset++] << 24) + ((branchQualifier[offset++] & 0xFF) << 16) + ((branchQualifier[offset++] & 0xFF) << 8) + (branchQualifier[offset++] & 0xFF)) > 0) {
            return new String(Arrays.copyOfRange(branchQualifier, offset, offset + length));
        }
        return null;
    }

    public static void setBranchUID(XID xid, Uid uid) {
        if (xid == null || xid.formatID != 131077) {
            return;
        }
        byte[] bqual = uid.getBytes();
        System.arraycopy(bqual, 0, xid.data, xid.gtrid_length, 28);
    }

    public static Uid getBranchUid(XID xid) {
        if (xid == null || xid.formatID != 131077) {
            return Uid.nullUid();
        }
        byte[] bqual = new byte[xid.bqual_length];
        System.arraycopy(xid.data, xid.gtrid_length, bqual, 0, xid.bqual_length);
        Uid tx = new Uid(bqual);
        return tx;
    }

    public static void setEisName(XID theXid, Integer eisName) {
        if (theXid == null || theXid.formatID != 131077) {
            return;
        }
        if (eisName == null) {
            eisName = 0;
        }
        int offset = theXid.gtrid_length + 28;
        theXid.data[offset + 0] = (byte)(eisName >>> 24);
        theXid.data[offset + 1] = (byte)(eisName >>> 16);
        theXid.data[offset + 2] = (byte)(eisName >>> 8);
        theXid.data[offset + 3] = (byte)(eisName >>> 0);
    }

    public static Integer getEISName(XID xid) {
        if (xid == null || xid.formatID != 131077) {
            return -1;
        }
        int offset = xid.gtrid_length + 28;
        return (xid.data[offset + 0] << 24) + ((xid.data[offset + 1] & 0xFF) << 16) + ((xid.data[offset + 2] & 0xFF) << 8) + (xid.data[offset + 3] & 0xFF);
    }

    public static String getXIDString(XID xid) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("< formatId=");
        stringBuilder.append(xid.formatID);
        stringBuilder.append(", gtrid_length=");
        stringBuilder.append(xid.gtrid_length);
        stringBuilder.append(", bqual_length=");
        stringBuilder.append(xid.bqual_length);
        stringBuilder.append(", tx_uid=");
        stringBuilder.append(XATxConverter.getUid(xid).stringForm());
        stringBuilder.append(", node_name=");
        stringBuilder.append(XATxConverter.getNodeName(xid));
        stringBuilder.append(", branch_uid=");
        stringBuilder.append(XATxConverter.getBranchUid(xid));
        stringBuilder.append(", subordinatenodename=");
        stringBuilder.append(XATxConverter.getSubordinateNodeName(xid));
        stringBuilder.append(", eis_name=");
        if (xaResourceRecordWrappingPlugin != null) {
            stringBuilder.append(xaResourceRecordWrappingPlugin.getEISName(XATxConverter.getEISName(xid)));
        } else {
            stringBuilder.append(XATxConverter.getEISName(xid));
        }
        stringBuilder.append(" >");
        return stringBuilder.toString();
    }
}

