/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.objectstore.StateType;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCImple;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStoreEnvironmentBean;
import java.io.IOException;
import java.io.SyncFailedException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class JDBCStore
implements ObjectStoreAPI {
    protected boolean _isValid;
    protected JDBCImple _theImple;
    private JDBCAccess _jdbcAccess;
    private String _jdbcTableName;
    private static String _defaultTableName = "JBossTSTable";
    protected final JDBCStoreEnvironmentBean jdbcStoreEnvironmentBean;
    protected static final HashMap _theImples = new HashMap();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException {
        return this.allObjUids(s, buff, -1);
    }

    @Override
    public boolean fullCommitNeeded() {
        return true;
    }

    @Override
    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    @Override
    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this.currentState(u, tn) == st;
    }

    @Override
    public String getStoreName() {
        if (this.storeValid()) {
            return this.getJDBCAccess().getClass().getName() + ":" + this.getTableName();
        }
        return "Invalid";
    }

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.commit_state(" + objUid + ", " + tName + ")"));
        }
        if (!this.storeValid()) {
            return false;
        }
        return this._theImple.commit_state(objUid, tName, this.getTableName());
    }

    @Override
    public boolean hide_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.hide_state(" + objUid + ", " + tName + ")"));
        }
        if (this.storeValid()) {
            return this._theImple.hide_state(objUid, tName, this.getTableName());
        }
        return false;
    }

    @Override
    public boolean reveal_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.reveal_state(" + objUid + ", " + tName + ")"));
        }
        if (this.storeValid()) {
            return this._theImple.reveal_state(objUid, tName, this.getTableName());
        }
        return false;
    }

    @Override
    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        if (this.storeValid()) {
            return this._theImple.currentState(objUid, tName, this.getTableName());
        }
        return -1;
    }

    @Override
    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.read_committed(" + storeUid + ", " + tName + ")"));
        }
        return this.read_state(storeUid, tName, 1);
    }

    @Override
    public InputObjectState read_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.read_uncommitted(" + storeUid + ", " + tName + ")"));
        }
        return this.read_state(storeUid, tName, 2);
    }

    @Override
    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.remove_committed(" + storeUid + ", " + tName + ")"));
        }
        return this.remove_state(storeUid, tName, 1);
    }

    @Override
    public boolean remove_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.remove_uncommitted(" + storeUid + ", " + tName + ")"));
        }
        return this.remove_state(storeUid, tName, 2);
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.write_committed(" + storeUid + ", " + tName + ")"));
        }
        return this.write_state(storeUid, tName, state, 1);
    }

    @Override
    public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.write_uncommitted(" + storeUid + ", " + tName + ", " + state + ")"));
        }
        return this.write_state(storeUid, tName, state, 2);
    }

    public final boolean storeValid() {
        return this._isValid;
    }

    @Override
    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.allObjUids(" + tName + ", " + state + ", " + match + ")"));
        }
        if (this.storeValid()) {
            return this._theImple.allObjUids(tName, state, match, this.getTableName());
        }
        return false;
    }

    @Override
    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.allTypes(" + foundTypes + ")"));
        }
        if (this.storeValid()) {
            return this._theImple.allTypes(foundTypes, this.getTableName());
        }
        return false;
    }

    public synchronized void packInto(OutputBuffer buff) throws IOException {
        buff.packString(this.getTableName());
    }

    public synchronized void unpackFrom(InputBuffer buff) throws IOException {
        this.setTableName(buff.unpackString());
    }

    protected InputObjectState read_state(Uid objUid, String tName, int ft) throws ObjectStoreException {
        if (!this.storeValid()) {
            return null;
        }
        return this._theImple.read_state(objUid, tName, ft, this.getTableName());
    }

    protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCStore.remove_state(" + objUid + ", " + name + ", " + StateType.stateTypeString(ft) + ")"));
        }
        if (!this.storeValid()) {
            return false;
        }
        return this._theImple.remove_state(objUid, name, ft, this.getTableName());
    }

    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int s) throws ObjectStoreException {
        if (!this.storeValid()) {
            return false;
        }
        return this._theImple.write_state(objUid, tName, state, s, this.getTableName());
    }

    protected JDBCStore(JDBCStoreEnvironmentBean jdbcStoreEnvironmentBean) throws ObjectStoreException {
        this.jdbcStoreEnvironmentBean = jdbcStoreEnvironmentBean;
        this.initialise();
    }

    protected String getDefaultTableName() {
        return _defaultTableName;
    }

    protected JDBCAccess getJDBCAccess() {
        return this._jdbcAccess;
    }

    protected void setJDBCAccess(JDBCAccess jdbcAccess) {
        this._jdbcAccess = jdbcAccess;
    }

    protected String getTableName() {
        return this._jdbcTableName;
    }

    protected void setTableName(String tableName) {
        this._jdbcTableName = tableName;
    }

    protected void initialise() throws ObjectStoreException {
        if (this.jdbcStoreEnvironmentBean.getJdbcUserDbAccess() == null) {
            throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_JDBCStore_5());
        }
        this.setJDBCAccess(this.jdbcStoreEnvironmentBean.getJdbcUserDbAccess());
        try {
            this.setupStore();
        }
        catch (Exception e) {
            tsLogger.i18NLogger.fatal_objectstore_JDBCStore_1(this.getJDBCAccess().toString(), this.getTableName());
            throw new ObjectStoreException(e);
        }
        this._isValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupStore() throws Exception {
        String impleTableName = this.getDefaultTableName();
        String jdbcAccessTableName = this.getJDBCAccess().tableName();
        if (jdbcAccessTableName != null && jdbcAccessTableName.length() > 0) {
            impleTableName = jdbcAccessTableName;
        }
        this.setTableName(impleTableName);
        String impleKey = this.getStoreName();
        HashMap hashMap = _theImples;
        synchronized (hashMap) {
            Object currentImple = _theImples.get(impleKey);
            if (currentImple != null) {
                this._theImple = (JDBCImple)currentImple;
            } else {
                try {
                    Connection connection;
                    try {
                        connection = this.getJDBCAccess().getConnection();
                    }
                    catch (SQLException sqle) {
                        tsLogger.i18NLogger.fatal_objectstore_JDBCStore_2("getConnection()", sqle);
                        throw sqle;
                    }
                    if (connection == null) {
                        tsLogger.i18NLogger.fatal_objectstore_JDBCStore_1(this.getJDBCAccess().toString(), this.getTableName());
                        throw new SQLException("getConnection returned null");
                    }
                    boolean success = false;
                    try {
                        JDBCImple jdbcImple;
                        connection.setAutoCommit(true);
                        try {
                            Class jdbcImpleClass = this.getJDBCClass(connection);
                            jdbcImple = (JDBCImple)jdbcImpleClass.newInstance();
                        }
                        catch (Exception ex) {
                            tsLogger.i18NLogger.fatal_objectstore_JDBCStore_2(this.getJDBCAccess().toString(), ex);
                            throw ex;
                        }
                        if (!jdbcImple.initialise(connection, this.getJDBCAccess(), impleTableName, this.jdbcStoreEnvironmentBean)) {
                            tsLogger.i18NLogger.warn_objectstore_JDBCStore_3();
                            throw new ObjectStoreException();
                        }
                        _theImples.put(impleKey, jdbcImple);
                        this._theImple = jdbcImple;
                        success = true;
                    }
                    finally {
                        if (!success) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sqle) {}
                        }
                    }
                }
                catch (Exception e) {
                    tsLogger.logger.warn((Object)e);
                    throw e;
                }
            }
            this._isValid = true;
        }
    }

    protected Class getJDBCClass(Connection conn) throws ClassNotFoundException, SQLException {
        DatabaseMetaData md = conn.getMetaData();
        String name = md.getDriverName();
        int major = md.getDriverMajorVersion();
        int minor = md.getDriverMinorVersion();
        int index = name.indexOf(32);
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.replaceAll("-", "_");
        name = name.toLowerCase();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String packageName = this.getClass().getPackage().getName() + ".jdbc.";
        try {
            return classLoader.loadClass(packageName + name + "_" + major + "_" + minor + "_driver");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return classLoader.loadClass(packageName + name + "_" + major + "_driver");
            }
            catch (ClassNotFoundException cnfe2) {
                return classLoader.loadClass(packageName + name + "_driver");
            }
        }
    }

    protected boolean supressEntry(String name) {
        return true;
    }
}

