/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStore;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStoreEnvironmentBean;

public class JDBCActionStore
extends JDBCStore {
    private JDBCAccess _txJDBCAccess;
    private String _txClassName;
    private String _txTableName;
    private static String _defaultTxTableName = "JBossTSTxTable";

    @Override
    public synchronized boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.commit_state(" + objUid + ", " + tName + ")"));
        }
        boolean result = false;
        if (!this.storeValid()) {
            return false;
        }
        if (this.currentState(objUid, tName) == 1) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.hide_state(" + u + ", " + tn + ")"));
        }
        return false;
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.reveal_state(" + u + ", " + tn + ")"));
        }
        return false;
    }

    @Override
    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.read_committed(" + storeUid + ", " + tName + ")"));
        }
        return super.read_committed(storeUid, tName);
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.read_uncommitted(" + u + ", " + tn + ")"));
        }
        return null;
    }

    @Override
    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.remove_committed(" + storeUid + ", " + tName + ")"));
        }
        return super.remove_committed(storeUid, tName);
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.remove_uncommitted(" + u + ", " + tn + ")"));
        }
        return false;
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.write_committed(" + storeUid + ", " + tName + ")"));
        }
        return super.write_committed(storeUid, tName, state);
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("JDBCActionStore.write_uncommitted(" + u + ", " + tn + ", " + s + ")"));
        }
        return false;
    }

    public JDBCActionStore(JDBCStoreEnvironmentBean jdbcStoreEnvironmentBean) throws ObjectStoreException {
        super(jdbcStoreEnvironmentBean);
        this._txClassName = jdbcStoreEnvironmentBean.getJdbcTxDbAccessClassName();
    }

    protected String getAccessClassName() {
        return this._txClassName;
    }

    protected void setAccessClassName(String txClassName) {
        this._txClassName = txClassName;
    }

    @Override
    protected String getDefaultTableName() {
        return _defaultTxTableName;
    }

    @Override
    protected JDBCAccess getJDBCAccess() {
        return this._txJDBCAccess;
    }

    @Override
    protected void setJDBCAccess(JDBCAccess jdbcAccess) {
        this._txJDBCAccess = jdbcAccess;
    }

    @Override
    protected String getTableName() {
        return this._txTableName;
    }

    @Override
    protected void setTableName(String tableName) {
        this._txTableName = tableName;
    }
}

