/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreIterator;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ObjStoreBrowser
implements ObjStoreBrowserMBean {
    private static final String STORE_MBEAN_NAME = "jboss.jta:type=ObjectStore";
    private static final String OS_BEAN_PROPFILE = "osmbean.properties";
    private Properties typeHandlers;
    private Map<String, List<UidWrapper>> allUids;

    public static void main(String[] args) throws Exception {
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        String logDir = System.getProperty("objectstore.dir");
        ObjStoreBrowser browser = new ObjStoreBrowser(logDir);
        browser.start();
        while (true) {
            System.out.println("> ");
            System.out.flush();
            String[] req = br.readLine().split("\\s+");
            if (req.length == 0 || "quit".equals(req[0])) break;
            browser.probe();
            if ("dump".equals(req[0])) {
                if (req.length == 1) {
                    System.out.println("Uid not found");
                    continue;
                }
                UidWrapper w = browser.findUid(req[1]);
                if (w != null) {
                    System.out.println("Attributes: " + w.toString("", new StringBuilder()));
                    continue;
                }
                System.out.println("Uid not found: " + req[1]);
                continue;
            }
            if (!"list".equals(req[0])) continue;
            System.out.println(browser.dump(new StringBuilder()));
        }
    }

    public static Properties loadProperties(String fname) {
        Properties properties = new Properties();
        URL url = ClassLoader.getSystemResource(fname);
        try {
            if (url != null) {
                properties.load(url.openStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public void start() {
        JMXServer.getAgent().registerMBean(STORE_MBEAN_NAME, this);
    }

    public void stop() {
        for (List<UidWrapper> uids : this.allUids.values()) {
            Iterator<UidWrapper> i = uids.iterator();
            while (i.hasNext()) {
                UidWrapper w = i.next();
                i.remove();
                w.unregister();
            }
        }
        JMXServer.getAgent().unregisterMBean(STORE_MBEAN_NAME);
    }

    public void setTypes(Map<String, String> types) {
        for (Map.Entry<String, String> entry : types.entrySet()) {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("ObjStoreBrowser: adding type handler " + entry.getKey() + "," + entry.getValue()));
            }
            this.typeHandlers.put(entry.getKey(), entry.getValue());
        }
    }

    private void init(String logDir) {
        if (logDir != null) {
            arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreDir(logDir);
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ObjectStoreDir: " + arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir()));
        }
        this.allUids = new HashMap<String, List<UidWrapper>>();
        this.typeHandlers = ObjStoreBrowser.loadProperties(OS_BEAN_PROPFILE);
        if (this.typeHandlers.size() == 0) {
            this.typeHandlers = ObjStoreBrowser.loadProperties("META-INF/osmbean.properties");
        }
    }

    public ObjStoreBrowser() {
        this.init(null);
    }

    public ObjStoreBrowser(String logDir) {
        this.init(logDir);
    }

    public StringBuilder dump(StringBuilder sb) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.allUids.entrySet()) {
            sb.append(typeEntry.getKey()).append('\n');
            for (UidWrapper uid : typeEntry.getValue()) {
                uid.toString("\t", sb);
            }
        }
        return sb;
    }

    public UidWrapper findUid(Uid uid) {
        return this.findUid(uid.stringForm());
    }

    public UidWrapper findUid(String uid) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.allUids.entrySet()) {
            for (UidWrapper w : typeEntry.getValue()) {
                if (!w.getUid().stringForm().equals(uid)) continue;
                return w;
            }
        }
        return null;
    }

    @Override
    public void probe() {
        block7: {
            InputObjectState types = new InputObjectState();
            try {
                if (StoreManager.getRecoveryStore().allTypes(types)) {
                    String tname;
                    do {
                        try {
                            tname = types.unpackString();
                            if (tname.length() == 0) continue;
                            List<UidWrapper> uids = this.allUids.get(tname);
                            if (uids == null) {
                                uids = new ArrayList<UidWrapper>();
                                this.allUids.put(tname, uids);
                            }
                            if (!this.typeHandlers.containsKey(tname)) continue;
                            this.updateMBeans(uids, System.currentTimeMillis(), true, tname, this.typeHandlers.getProperty(tname));
                        }
                        catch (IOException e1) {
                            tname = "";
                        }
                    } while (tname.length() != 0);
                }
            }
            catch (ObjectStoreException e2) {
                if (!tsLogger.logger.isTraceEnabled()) break block7;
                tsLogger.logger.trace((Object)e2.toString());
            }
        }
    }

    public List<UidWrapper> probe(String type, String beantype) {
        if (!this.allUids.containsKey(type)) {
            return null;
        }
        List<UidWrapper> uids = this.allUids.get(type);
        this.updateMBeans(uids, System.currentTimeMillis(), false, type, beantype);
        return uids;
    }

    private void updateMBeans(List<UidWrapper> uids, long tstamp, boolean register, String type, String thandler) {
        UidWrapper w;
        ObjectStoreIterator iter = new ObjectStoreIterator(StoreManager.getRecoveryStore(), type);
        while (true) {
            Uid u = iter.iterate();
            if (Uid.nullUid().equals(u)) break;
            w = new UidWrapper(this, thandler, type, u);
            int i = uids.indexOf(w);
            if (i == -1) {
                w.setTimestamp(tstamp);
                uids.add(w);
                w.createMBean();
                if (!register) continue;
                w.register();
                continue;
            }
            uids.get(i).setTimestamp(tstamp);
        }
        Iterator<UidWrapper> i = uids.iterator();
        while (i.hasNext()) {
            w = i.next();
            if (w.getTimestamp() == tstamp) continue;
            if (register) {
                w.unregister();
            }
            i.remove();
        }
    }
}

