/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import org.jboss.narayana.jta.jms.ConnectionProxy;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class ConnectionFactoryProxy
implements ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactoryProxy.class.getName());
    private final XAConnectionFactory xaConnectionFactory;
    private final TransactionHelper transactionHelper;

    public ConnectionFactoryProxy(XAConnectionFactory xaConnectionFactory, TransactionHelper transactionHelper) {
        this.xaConnectionFactory = xaConnectionFactory;
        this.transactionHelper = transactionHelper;
    }

    public Connection createConnection() throws JMSException {
        ConnectionProxy connection = new ConnectionProxy(this.xaConnectionFactory.createXAConnection(), this.transactionHelper);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created new proxied connection: " + connection);
        }
        return connection;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ConnectionProxy connection = new ConnectionProxy(this.xaConnectionFactory.createXAConnection(userName, password), this.transactionHelper);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created new proxied connection: " + connection);
        }
        return connection;
    }
}

