/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.wst.Aborted;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.ReadOnly;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import jakarta.resource.spi.XATerminator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.inbound.InboundBridgeManager;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class BridgeDurableParticipant
implements Durable2PCParticipant,
Serializable {
    public static final String TYPE_IDENTIFIER = "BridgeDurableParticipant_";
    public static final int XARESOURCE_FORMAT_ID = 131080;
    private volatile transient XATerminator xaTerminator;
    private volatile transient String externalTxId;
    private volatile transient boolean isAwaitingRecovery = false;
    static final long serialVersionUID = -5739871936627778072L;
    private volatile Xid xid;
    private volatile Uid subordinateTransactionId;

    BridgeDurableParticipant(String externalTxId, Xid xid) {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.<ctor>(TxId=" + externalTxId + ", Xid=" + String.valueOf(xid) + ")"));
        this.xid = xid;
        this.externalTxId = externalTxId;
        this.xaTerminator = SubordinationManager.getXATerminator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.writeObject() for Xid=" + String.valueOf(this.xid)));
        try {
            this.subordinateTransactionId = SubordinationManager.getTransactionImporter().getImportedTransaction(this.xid).get_uid();
        }
        catch (XAException xaException) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                txbridgeLogger.i18NLogger.error_ibdp_nosub(xaException);
            }
            throw new IOException(xaException);
        }
        out.writeObject(this.xid);
        out.writeObject(this.subordinateTransactionId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        txbridgeLogger.logger.trace((Object)"BridgeDurableParticipant.readObject()");
        this.xid = (Xid)in.readObject();
        this.subordinateTransactionId = (Uid)in.readObject();
        this.isAwaitingRecovery = true;
        this.xaTerminator = SubordinationManager.getXATerminator();
        try {
            SubordinationManager.getTransactionImporter().recoverTransaction(this.subordinateTransactionId);
        }
        catch (XAException xaException) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                txbridgeLogger.i18NLogger.error_ibdp_norecovery(this.subordinateTransactionId, xaException);
            }
            throw new IOException(xaException);
        }
    }

    public Vote prepare() throws WrongStateException, SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.prepare(Xid=" + String.valueOf(this.xid) + ")"));
        try {
            int result = this.xaTerminator.prepare(this.xid);
            if (result == 0) {
                txbridgeLogger.logger.trace((Object)("prepare on Xid=" + String.valueOf(this.xid) + " returning Prepared"));
                return new Prepared();
            }
            this.cleanupRefs();
            txbridgeLogger.logger.trace((Object)("prepare on Xid=" + String.valueOf(this.xid) + " returning ReadOnly"));
            return new ReadOnly();
        }
        catch (XAException e) {
            this.cleanupRefs();
            txbridgeLogger.i18NLogger.warn_ibdp_aborted(XAHelper.xidToString((Xid)this.xid), e);
            return new Aborted();
        }
    }

    public void commit() throws WrongStateException, SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.commit(Xid=" + String.valueOf(this.xid) + ")"));
        try {
            this.xaTerminator.commit(this.xid, false);
            txbridgeLogger.logger.trace((Object)("commit on Xid=" + String.valueOf(this.xid) + " OK"));
        }
        catch (XAException e) {
            txbridgeLogger.i18NLogger.error_ibdp_commitfailed(XAHelper.xidToString((Xid)this.xid), e);
        }
        finally {
            this.cleanupRefs();
        }
    }

    public void rollback() throws WrongStateException, SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.rollback(Xid=" + String.valueOf(this.xid) + ")"));
        try {
            this.xaTerminator.rollback(this.xid);
            txbridgeLogger.logger.trace((Object)("rollback on Xid=" + String.valueOf(this.xid) + " OK"));
        }
        catch (XAException e) {
            txbridgeLogger.i18NLogger.error_ibdp_rollbackfailed(XAHelper.xidToString((Xid)this.xid), e);
        }
        finally {
            this.cleanupRefs();
        }
    }

    public void unknown() throws SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.unknown(Xid=" + String.valueOf(this.xid) + "): NOT IMPLEMENTED"));
    }

    public void error() throws SystemException {
        txbridgeLogger.logger.trace((Object)("BridgeDurableParticipant.error(Xid=" + String.valueOf(this.xid) + "): NOT IMPLEMENTED"));
    }

    public boolean isAwaitingRecovery() {
        return this.isAwaitingRecovery;
    }

    public Xid getXid() {
        return this.xid;
    }

    private void cleanupRefs() {
        txbridgeLogger.logger.trace((Object)"BridgeDurableParticipant.cleanupRefs()");
        InboundBridgeManager.removeMapping(this.externalTxId);
        this.isAwaitingRecovery = false;
    }
}

