/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.server.ServerConstants;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoaderRepository
implements ServerConstants,
ClassLoaderRepository {
    protected static Vector<ClassLoader> loaders = new Vector();
    protected static LoaderRepository instance = null;
    protected Translator translator = null;
    private ConcurrentHashMap<String, Class<?>> classes = new ConcurrentHashMap();
    private static HashMap<String, Class<?>> nativeClassBySignature;
    private static final Logger log;

    public Vector<ClassLoader> getLoaders() {
        return loaders;
    }

    public URL[] getURLs() {
        return null;
    }

    public Class<?> getCachedClass(String classname) {
        return this.classes.get(classname);
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator t) {
        this.translator = t;
    }

    public int compare(LoaderRepository lr) {
        if (lr == this) {
            return 0;
        }
        return -lr.reverseCompare(this);
    }

    @Override
    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    @Override
    public abstract Class<?> loadClassWithout(ClassLoader var1, String var2) throws ClassNotFoundException;

    @Override
    public abstract Class<?> loadClassBefore(ClassLoader var1, String var2) throws ClassNotFoundException;

    public abstract RepositoryClassLoader newClassLoader(URL var1, boolean var2) throws Exception;

    public abstract RepositoryClassLoader newClassLoader(URL var1, URL var2, boolean var3) throws Exception;

    public abstract Class<?> loadClass(String var1, boolean var2, ClassLoader var3) throws ClassNotFoundException;

    public abstract URL getResource(String var1, ClassLoader var2);

    public abstract void getResources(String var1, ClassLoader var2, List<URL> var3);

    public abstract void addClassLoader(ClassLoader var1);

    public abstract boolean addClassLoaderURL(ClassLoader var1, URL var2);

    public abstract void removeClassLoader(ClassLoader var1);

    public static final Class<?> getNativeClassForName(String className) {
        return nativeClassBySignature.get(className);
    }

    protected int reverseCompare(LoaderRepository lr) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheLoadedClass(String name, Class<?> cls, ClassLoader cl) {
        ConcurrentHashMap<String, Class<?>> concurrentHashMap = this.classes;
        synchronized (concurrentHashMap) {
            this.classes.put(name, cls);
            if (log.isTraceEnabled()) {
                log.trace((Object)("cacheLoadedClass, classname: " + name + ", class: " + cls + ", cl: " + cl));
            }
        }
    }

    void clear() {
        this.classes.clear();
    }

    static {
        log = Logger.getLogger(LoaderRepository.class);
        nativeClassBySignature = new HashMap();
        nativeClassBySignature.put("boolean", Boolean.TYPE);
        nativeClassBySignature.put("byte", Byte.TYPE);
        nativeClassBySignature.put("char", Character.TYPE);
        nativeClassBySignature.put("double", Double.TYPE);
        nativeClassBySignature.put("float", Float.TYPE);
        nativeClassBySignature.put("int", Integer.TYPE);
        nativeClassBySignature.put("long", Long.TYPE);
        nativeClassBySignature.put("short", Short.TYPE);
        nativeClassBySignature.put("void", Void.TYPE);
        nativeClassBySignature.put("boolean[]", boolean[].class);
        nativeClassBySignature.put("byte[]", byte[].class);
        nativeClassBySignature.put("char[]", char[].class);
        nativeClassBySignature.put("double[]", double[].class);
        nativeClassBySignature.put("float[]", float[].class);
        nativeClassBySignature.put("int[]", int[].class);
        nativeClassBySignature.put("long[]", long[].class);
        nativeClassBySignature.put("short[]", short[].class);
    }
}

