/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.IterableLocalLoader;
import org.jboss.modules.Linkage;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.LocalLoaders;
import org.jboss.modules.Metrics;
import org.jboss.modules.ModularContentHandlerFactory;
import org.jboss.modules.ModularURLStreamHandlerProvider;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderDependency;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.PathUtils;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.Resource;
import org.jboss.modules.SecurityActions;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.Utils;
import org.jboss.modules.Version;
import org.jboss.modules._private.ModulesPrivateAccess;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.NoopModuleLogger;
import org.jboss.modules.security.ModularPermissionFactory;

public final class Module {
    private static final AtomicReference<ModuleLoader> BOOT_MODULE_LOADER;
    private static final MethodType MAIN_METHOD_TYPE;
    static final String[] systemPackages;
    static final String[] systemPaths;
    static final ModulesPrivateAccess PRIVATE_ACCESS;
    static volatile ModuleLogger log;
    private static final FastCopyHashSet<ClassFilter> EMPTY_CLASS_FILTERS;
    private static final FastCopyHashSet<PathFilter> EMPTY_PATH_FILTERS;
    private final String name;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final LocalLoader fallbackLoader;
    private final Map<String, String> properties;
    private final PermissionCollection permissionCollection;
    private final Version version;
    volatile Set<String> aliases = new HashSet<String>();
    private volatile Linkage linkage = Linkage.NONE;
    private static final RuntimePermission GET_DEPENDENCIES;
    private static final RuntimePermission GET_CLASS_LOADER;
    private static final RuntimePermission GET_BOOT_MODULE_LOADER;
    private static final RuntimePermission ACCESS_MODULE_LOGGER;
    private static final RuntimePermission ADD_CONTENT_HANDLER_FACTORY;
    private static final RuntimePermission ADD_URL_STREAM_HANDLER_FACTORY;
    private static final PermissionCollection NO_PERMISSIONS;
    static final StackWalker STACK_WALKER;

    public static ModulesPrivateAccess getPrivateAccess() {
        if (STACK_WALKER.getCallerClass() == ModularPermissionFactory.class) {
            return PRIVATE_ACCESS;
        }
        throw new SecurityException();
    }

    Module(ConcreteModuleSpec spec, ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
        this.name = spec.getName();
        this.mainClassName = spec.getMainClass();
        this.fallbackLoader = spec.getFallbackLoader();
        PermissionCollection permissionCollection = spec.getPermissionCollection();
        this.permissionCollection = permissionCollection == null ? NO_PERMISSIONS : (permissionCollection.isReadOnly() ? permissionCollection : Module.copyPermissions(permissionCollection));
        ModuleClassLoader.Configuration configuration = new ModuleClassLoader.Configuration(this, spec.getAssertionSetting(), spec.getResourceLoaders(), spec.getClassFileTransformer());
        ModuleClassLoaderFactory factory = spec.getModuleClassLoaderFactory();
        Map<String, String> properties = spec.getProperties();
        this.properties = properties.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, String>(properties);
        this.version = spec.getVersion();
        ModuleClassLoader moduleClassLoader = null;
        if (factory != null) {
            moduleClassLoader = factory.create(configuration);
        }
        if (moduleClassLoader == null) {
            moduleClassLoader = new ModuleClassLoader(configuration);
        }
        this.moduleClassLoader = moduleClassLoader;
    }

    private static PermissionCollection noPermissions() {
        Permissions permissions = new Permissions();
        permissions.setReadOnly();
        return permissions;
    }

    private static PermissionCollection copyPermissions(PermissionCollection permissionCollection) {
        Permissions permissions = new Permissions();
        Enumeration<Permission> elements = permissionCollection.elements();
        while (elements.hasMoreElements()) {
            permissions.add(elements.nextElement());
        }
        permissions.setReadOnly();
        return permissions;
    }

    LocalLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    Dependency[] getDependenciesInternal() {
        return this.linkage.getDependencies();
    }

    DependencySpec[] getDependencySpecsInternal() {
        return this.linkage.getDependencySpecs();
    }

    ModuleClassLoader getClassLoaderPrivate() {
        return this.moduleClassLoader;
    }

    public DependencySpec[] getDependencies() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_DEPENDENCIES);
        }
        return (DependencySpec[])this.getDependencySpecsInternal().clone();
    }

    @Deprecated
    public Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath);
    }

    public void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        this.run(this.mainClassName, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String className, String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        if (className == null) {
            throw new NoSuchMethodException("No main class defined for " + String.valueOf(this));
        }
        ClassLoader oldClassLoader = SecurityActions.setContextClassLoader(this.moduleClassLoader);
        try {
            MethodHandle methodHandle;
            Class<?> mainClass = Class.forName(className, false, this.moduleClassLoader);
            try {
                Class.forName(className, true, this.moduleClassLoader);
            }
            catch (Throwable t) {
                throw new InvocationTargetException(t, "Failed to initialize main class '" + className + "'");
            }
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            try {
                methodHandle = lookup.findStatic(mainClass, "main", MAIN_METHOD_TYPE);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchMethodException("The main method is not public");
            }
            try {
                methodHandle.invokeExact(args);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }
        finally {
            SecurityActions.setContextClassLoader(oldClassLoader);
        }
    }

    public String getName() {
        return this.name;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        this.getClass().getModule().addUses(serviceType);
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public <S> ServiceLoader<S> loadServiceDirectly(Class<S> serviceType) {
        this.getClass().getModule().addUses(serviceType);
        return ServiceLoader.load(serviceType, new ClassLoader(null){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                final Enumeration<Resource> resourceEnumeration = Collections.enumeration(Module.this.getClassLoader().getLocalLoader().loadResourceLocal(name));
                return new Enumeration<URL>(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return resourceEnumeration.hasMoreElements();
                    }

                    @Override
                    public URL nextElement() {
                        return ((Resource)resourceEnumeration.nextElement()).getURL();
                    }
                };
            }
        });
    }

    public static <S> ServiceLoader<S> loadServiceFromCallerModuleLoader(String name, Class<S> serviceType) throws ModuleLoadException {
        ModuleLoader ml;
        Class<?> caller = STACK_WALKER.getCallerClass();
        assert (!caller.getPackageName().equals(Module.class.getPackageName()));
        Module callerModule = Module.forClass(caller);
        if (callerModule != null && (ml = callerModule.getModuleLoader()) != null) {
            return ml.loadModule(name).loadService(serviceType);
        }
        throw new ModuleLoadException(name);
    }

    public ModuleClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASS_LOADER);
        }
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.getPathsUnchecked().keySet());
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return Module.forClassLoader(cl, false);
    }

    public static Module forClassLoader(ClassLoader cl, boolean search) {
        if (cl instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)cl).getModule();
        }
        if (search && cl != null) {
            return Module.forClassLoader(cl.getParent(), true);
        }
        return null;
    }

    public static ModuleLoader getBootModuleLoader() {
        ModuleLoader loader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_BOOT_MODULE_LOADER);
        }
        while ((loader = BOOT_MODULE_LOADER.get()) == null && !BOOT_MODULE_LOADER.compareAndSet(null, loader = DefaultBootModuleLoaderHolder.INSTANCE)) {
        }
        return loader;
    }

    public static ModuleLoader getSystemModuleLoader() {
        return Utils.JDK_MODULE_LOADER;
    }

    public static <T> Iterable<T> findServices(Class<T> type, Predicate<Class<?>> filter, ClassLoader loader) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        return Utils.findServices(type, filter, loader);
    }

    static void initBootModuleLoader(ModuleLoader loader) {
        BOOT_MODULE_LOADER.set(loader);
    }

    public static ModuleLoader getCallerModuleLoader() {
        return ModuleLoader.forClass(STACK_WALKER.getCallerClass());
    }

    public static ModuleLoader getContextModuleLoader() {
        Module module = Module.forClassLoader(Thread.currentThread().getContextClassLoader(), true);
        if (module != null) {
            return module.getModuleLoader();
        }
        return null;
    }

    public static Module getModuleFromCallerModuleLoader(String name) throws ModuleLoadException {
        Class<?> caller = STACK_WALKER.getCallerClass();
        assert (!caller.getPackageName().equals(Module.class.getPackageName()));
        ModuleLoader ml = ModuleLoader.forClass(caller);
        if (ml != null) {
            return ml.loadModule(name);
        }
        throw new ModuleLoadException(name);
    }

    public static Module getCallerModule() {
        return Module.forClass(STACK_WALKER.getCallerClass());
    }

    public Module getModule(String name) throws ModuleLoadException {
        return this.moduleLoader.loadModule(name);
    }

    public static Class<?> loadClassFromBootModuleLoader(String name, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getBootModuleLoader().loadModule(name).getClassLoaderPrivate());
    }

    public static Class<?> loadClassFromCallerModuleLoader(String name, String className) throws ModuleLoadException, ClassNotFoundException {
        Class<?> caller = STACK_WALKER.getCallerClass();
        assert (!caller.getPackageName().equals(Module.class.getPackageName()));
        ModuleLoader ml = ModuleLoader.forClass(caller);
        if (ml != null) {
            return Class.forName(className, true, ml.loadModule(name).getClassLoaderPrivate());
        }
        throw new ModuleLoadException(name);
    }

    Class<?> loadModuleClass(String className, boolean resolve) throws ClassNotFoundException {
        LocalLoader fallbackLoader;
        for (String s : systemPackages) {
            if (!className.startsWith(s)) continue;
            return this.moduleClassLoader.loadClass(className, resolve);
        }
        String path = Module.pathOfClass(className);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                Class<?> clazz = loader.loadClassLocal(className, resolve);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            return fallbackLoader.loadClassLocal(className, resolve);
        }
        return null;
    }

    URL getResource(String name) {
        Iterator<Resource> iterator;
        LocalLoader fallbackLoader;
        String canonPath = PathUtils.canonicalize(name);
        for (String s : systemPaths) {
            if (!canonPath.startsWith(s)) continue;
            return this.moduleClassLoader.getResource(canonPath);
        }
        log.trace("Attempting to find resource %s in %s", (Object)canonPath, (Object)this);
        String path = Module.pathOf(canonPath);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                Iterator<Resource> iterator2 = loader.loadResourceLocal(canonPath).iterator();
                if (!iterator2.hasNext()) continue;
                return iterator2.next().getURL();
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null && (iterator = fallbackLoader.loadResourceLocal(canonPath).iterator()).hasNext()) {
            return iterator.next().getURL();
        }
        return null;
    }

    InputStream getResourceAsStream(String name) throws IOException {
        List<Resource> resourceList;
        Iterator<Resource> iterator;
        LocalLoader fallbackLoader;
        String canonPath = PathUtils.canonicalize(name);
        for (String s : systemPaths) {
            if (!canonPath.startsWith(s)) continue;
            return this.moduleClassLoader.getResourceAsStream(canonPath);
        }
        log.trace("Attempting to find resource %s in %s", (Object)canonPath, (Object)this);
        String path = Module.pathOf(canonPath);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList2 = loader.loadResourceLocal(canonPath);
                Iterator<Resource> iterator2 = resourceList2.iterator();
                if (!iterator2.hasNext()) continue;
                return iterator2.next().openStream();
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null && (iterator = (resourceList = fallbackLoader.loadResourceLocal(canonPath)).iterator()).hasNext()) {
            return iterator.next().openStream();
        }
        return null;
    }

    Enumeration<URL> getResources(String name) {
        LocalLoader fallbackLoader;
        String canonPath = PathUtils.canonicalize(PathUtils.relativize(name));
        for (String s : systemPaths) {
            if (!canonPath.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.getResources(canonPath);
            }
            catch (IOException e) {
                return Collections.emptyEnumeration();
            }
        }
        log.trace("Attempting to find all resources %s in %s", (Object)canonPath, (Object)this);
        String path = Module.pathOf(canonPath);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        ArrayList<URL> list = new ArrayList<URL>();
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList = loader.loadResourceLocal(canonPath);
                for (Resource resource : resourceList) {
                    list.add(resource.getURL());
                }
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            List<Resource> resourceList = fallbackLoader.loadResourceLocal(canonPath);
            for (Resource resource : resourceList) {
                list.add(resource.getURL());
            }
        }
        return Collections.enumeration(list);
    }

    public URL getExportedResource(String name) {
        return this.getResource(name);
    }

    public Enumeration<URL> getExportedResources(String name) {
        return this.getResources(name);
    }

    public Iterator<Resource> iterateResources(final PathFilter filter) throws ModuleLoadException {
        Map<String, List<LocalLoader>> paths = this.getPaths();
        final Iterator<Map.Entry<String, List<LocalLoader>>> iterator = paths.entrySet().iterator();
        return new Iterator<Resource>(this){
            private String path;
            private Iterator<Resource> resourceIterator;
            private Iterator<LocalLoader> loaderIterator;
            private Resource next;
            final /* synthetic */ Module this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.resourceIterator != null) {
                        assert (this.path != null);
                        if (this.resourceIterator.hasNext()) {
                            this.next = this.resourceIterator.next();
                            return true;
                        }
                        this.resourceIterator = null;
                    }
                    if (this.loaderIterator != null) {
                        LocalLoader loader;
                        assert (this.path != null);
                        if (this.loaderIterator.hasNext() && (loader = this.loaderIterator.next()) instanceof IterableLocalLoader) {
                            this.resourceIterator = ((IterableLocalLoader)loader).iterateResources(this.path, false);
                            continue;
                        }
                        this.loaderIterator = null;
                    }
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.path = (String)entry.getKey();
                    if (!filter.accept(this.path)) continue;
                    this.loaderIterator = ((List)entry.getValue()).iterator();
                }
                return true;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Resource resource = this.next;
                    return resource;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Resource> globResources(String glob) throws ModuleLoadException {
        String safeGlob = PathUtils.canonicalize(PathUtils.relativize(glob));
        int i = safeGlob.lastIndexOf(47);
        if (i == -1) {
            return PathFilters.filtered(PathFilters.match(glob), this.iterateResources(PathFilters.acceptAll()));
        }
        return PathFilters.filtered(PathFilters.match(glob.substring(i + 1)), this.iterateResources(PathFilters.match(glob.substring(0, i))));
    }

    public Set<String> getImportedPaths() throws ModuleLoadException {
        return Collections.unmodifiableSet(this.getPaths().keySet());
    }

    static String pathOfClass(String className) {
        String resourceName = className.replace('.', '/');
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String pathOf(String resourceName) {
        if (resourceName.indexOf(47) == 0) {
            return Module.pathOf(resourceName.substring(1));
        }
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String fileNameOfClass(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getProperty(String name, String defaultVal) {
        return this.properties.getOrDefault(name, defaultVal);
    }

    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Module \"");
        b.append(this.getName());
        b.append("\"");
        if (this.version != null) {
            b.append(" version ").append(this.version);
        }
        b.append(" from ").append(this.moduleLoader);
        return b.toString();
    }

    public static ModuleLogger getModuleLogger() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        return log;
    }

    public static void setModuleLogger(ModuleLogger logger) {
        String logVersion;
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
            logVersion = AccessController.doPrivileged(new PropertyReadAction("jboss.log-version", "false"));
        } else {
            logVersion = System.getProperty("jboss.log-version", "false");
        }
        if (Boolean.parseBoolean(logVersion)) {
            logger.greeting();
        }
        log = logger;
    }

    public static long getStartTime() {
        return StartTimeHolder.START_TIME;
    }

    public static void registerContentHandlerFactoryModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONTENT_HANDLER_FACTORY);
        }
        ModularContentHandlerFactory.addHandlerModule(module);
    }

    public static void registerURLStreamHandlerFactoryModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_URL_STREAM_HANDLER_FACTORY);
        }
        ModularURLStreamHandlerProvider.addHandlerModule(module);
    }

    public static String getPlatformIdentifier() {
        return NativeLibraryResourceLoader.getArchName();
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map, FastCopyHashSet<PathFilter> filterStack, FastCopyHashSet<ClassFilter> classFilterStack, FastCopyHashSet<PathFilter> resourceFilterStack, Set<Visited> visited) throws ModuleLoadException {
        long subtract = 0L;
        this.moduleLoader.incScanCount();
        for (Dependency dependency : dependencies) {
            List<LocalLoader> list;
            Set<String> paths;
            PathFilter resourceFilter;
            LocalLoader localLoader;
            if (dependency instanceof ModuleDependency) {
                Object nestedResourceFilters;
                Object nestedClassFilters;
                Object nestedFilters;
                Module module;
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                String string = moduleDependency.getName();
                try {
                    long pauseStart = Metrics.getCurrentCPUTime();
                    try {
                        module = moduleLoader.preloadModule(string);
                    }
                    finally {
                        subtract += Metrics.getCurrentCPUTime() - pauseStart;
                    }
                }
                catch (ModuleLoadException ex) {
                    if (moduleDependency.isOptional()) continue;
                    log.trace("Module %s, dependency %s preload failed: %s", (Object)this.getName(), (Object)moduleDependency.getName(), (Object)ex);
                    throw ex;
                }
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new ModuleNotFoundException(string);
                }
                PathFilter importFilter = dependency.getImportFilter();
                if (filterStack.contains(importFilter)) {
                    nestedFilters = filterStack;
                } else {
                    nestedFilters = filterStack.clone();
                    ((FastCopyHashSet)nestedFilters).add(importFilter);
                }
                ClassFilter classImportFilter = dependency.getClassImportFilter();
                if (classImportFilter == ClassFilters.acceptAll() || classFilterStack.contains(classImportFilter)) {
                    nestedClassFilters = classFilterStack;
                } else {
                    nestedClassFilters = classFilterStack.clone();
                    if (classImportFilter != ClassFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedClassFilters).add(classImportFilter);
                    }
                }
                PathFilter resourceImportFilter = dependency.getResourceImportFilter();
                if (resourceImportFilter == PathFilters.acceptAll() || resourceFilterStack.contains(resourceImportFilter)) {
                    nestedResourceFilters = resourceFilterStack;
                } else {
                    nestedResourceFilters = resourceFilterStack.clone();
                    if (resourceImportFilter != PathFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedResourceFilters).add(resourceImportFilter);
                    }
                }
                subtract += module.addExportedPaths(module.getDependenciesInternal(), map, (FastCopyHashSet<PathFilter>)nestedFilters, (FastCopyHashSet<ClassFilter>)nestedClassFilters, (FastCopyHashSet<PathFilter>)nestedResourceFilters, visited);
                continue;
            }
            if (dependency instanceof ModuleClassLoaderDependency) {
                ModuleClassLoaderDependency classLoaderDependency = (ModuleClassLoaderDependency)dependency;
                localLoader = classLoaderDependency.getLocalLoader();
                for (Object filter : classFilterStack.getRawArray()) {
                    if (filter == null || filter == ClassFilters.acceptAll()) continue;
                    localLoader = this.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
                }
                for (Object filter : resourceFilterStack.getRawArray()) {
                    if (filter == null || filter == PathFilters.acceptAll()) continue;
                    localLoader = this.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
                }
                ClassFilter classFilter = classLoaderDependency.getClassImportFilter();
                if (classFilter != ClassFilters.acceptAll()) {
                    localLoader = this.createClassFilteredLocalLoader(classFilter, localLoader);
                }
                if ((resourceFilter = classLoaderDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                    localLoader = this.createPathFilteredLocalLoader(resourceFilter, localLoader);
                }
                PathFilter importFilter = classLoaderDependency.getImportFilter();
                paths = classLoaderDependency.getPaths();
                for (String path : paths) {
                    if (!importFilter.accept(path)) continue;
                    list = map.get(path);
                    if (list == null) {
                        list = new ArrayList<LocalLoader>();
                        map.put(path, list);
                        list.add(localLoader);
                        continue;
                    }
                    if (list.contains(localLoader)) continue;
                    list.add(localLoader);
                }
                continue;
            }
            if (!(dependency instanceof LocalDependency)) continue;
            LocalDependency localDependency = (LocalDependency)dependency;
            localLoader = localDependency.getLocalLoader();
            for (Object filter : classFilterStack.getRawArray()) {
                if (filter == null || filter == ClassFilters.acceptAll()) continue;
                localLoader = this.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
            }
            for (Object filter : resourceFilterStack.getRawArray()) {
                if (filter == null || filter == PathFilters.acceptAll()) continue;
                localLoader = this.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
            }
            ClassFilter classFilter = localDependency.getClassImportFilter();
            if (classFilter != ClassFilters.acceptAll()) {
                localLoader = this.createClassFilteredLocalLoader(classFilter, localLoader);
            }
            if ((resourceFilter = localDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                localLoader = this.createPathFilteredLocalLoader(resourceFilter, localLoader);
            }
            PathFilter importFilter = localDependency.getImportFilter();
            paths = localDependency.getPaths();
            for (String path : paths) {
                if (!importFilter.accept(path)) continue;
                list = map.get(path);
                if (list == null) {
                    list = new ArrayList<LocalLoader>();
                    map.put(path, list);
                    list.add(localLoader);
                    continue;
                }
                if (list.contains(localLoader)) continue;
                list.add(localLoader);
            }
        }
        return subtract;
    }

    private LocalLoader createPathFilteredLocalLoader(PathFilter filter, LocalLoader localLoader) {
        if (localLoader instanceof IterableLocalLoader) {
            return LocalLoaders.createIterablePathFilteredLocalLoader(filter, (IterableLocalLoader)localLoader);
        }
        return LocalLoaders.createPathFilteredLocalLoader(filter, localLoader);
    }

    private LocalLoader createClassFilteredLocalLoader(ClassFilter filter, LocalLoader localLoader) {
        if (localLoader instanceof IterableLocalLoader) {
            return LocalLoaders.createIterableClassFilteredLocalLoader(filter, (IterableLocalLoader)localLoader);
        }
        return LocalLoaders.createClassFilteredLocalLoader(filter, localLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addExportedPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map, FastCopyHashSet<PathFilter> filterStack, FastCopyHashSet<ClassFilter> classFilterStack, FastCopyHashSet<PathFilter> resourceFilterStack, Set<Visited> visited) throws ModuleLoadException {
        if (!visited.add(new Visited(this, filterStack, classFilterStack, resourceFilterStack))) {
            return 0L;
        }
        long subtract = 0L;
        this.moduleLoader.incScanCount();
        for (Dependency dependency : dependencies) {
            PathFilter resourceFilter;
            ClassFilter classFilter;
            LocalLoader localLoader;
            PathFilter exportFilter = dependency.getExportFilter();
            if (exportFilter == PathFilters.rejectAll()) continue;
            if (dependency instanceof ModuleDependency) {
                Object nestedResourceFilters;
                Object nestedClassFilters;
                FastCopyHashSet<PathFilter> nestedFilters;
                Module module;
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                String string = moduleDependency.getName();
                try {
                    long pauseStart = Metrics.getCurrentCPUTime();
                    try {
                        module = moduleLoader.preloadModule(string);
                    }
                    finally {
                        subtract += Metrics.getCurrentCPUTime() - pauseStart;
                    }
                }
                catch (ModuleLoadException ex) {
                    if (moduleDependency.isOptional()) continue;
                    log.trace("Module %s, dependency %s preload failed: %s", (Object)this.getName(), (Object)moduleDependency.getName(), (Object)ex);
                    throw ex;
                }
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new ModuleNotFoundException(string);
                }
                PathFilter importFilter = dependency.getImportFilter();
                if (filterStack.contains(importFilter) && filterStack.contains(exportFilter)) {
                    nestedFilters = filterStack;
                } else {
                    nestedFilters = filterStack.clone();
                    nestedFilters.add(importFilter);
                    nestedFilters.add(exportFilter);
                }
                Object[] classImportFilter = dependency.getClassImportFilter();
                ClassFilter classExportFilter = dependency.getClassExportFilter();
                if ((classImportFilter == ClassFilters.acceptAll() || classFilterStack.contains(classImportFilter)) && (classExportFilter == ClassFilters.acceptAll() || classFilterStack.contains(classExportFilter))) {
                    nestedClassFilters = classFilterStack;
                } else {
                    nestedClassFilters = classFilterStack.clone();
                    if (classImportFilter != ClassFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedClassFilters).add(classImportFilter);
                    }
                    if (classExportFilter != ClassFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedClassFilters).add(classExportFilter);
                    }
                }
                PathFilter resourceImportFilter = dependency.getResourceImportFilter();
                Object[] resourceExportFilter = dependency.getResourceExportFilter();
                if ((resourceImportFilter == PathFilters.acceptAll() || resourceFilterStack.contains(resourceImportFilter)) && (resourceExportFilter == PathFilters.acceptAll() || resourceFilterStack.contains(resourceExportFilter))) {
                    nestedResourceFilters = resourceFilterStack;
                } else {
                    nestedResourceFilters = resourceFilterStack.clone();
                    if (resourceImportFilter != PathFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedResourceFilters).add(resourceImportFilter);
                    }
                    if (resourceExportFilter != PathFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedResourceFilters).add(resourceExportFilter);
                    }
                }
                subtract += module.addExportedPaths(module.getDependenciesInternal(), map, nestedFilters, (FastCopyHashSet<ClassFilter>)nestedClassFilters, (FastCopyHashSet<PathFilter>)nestedResourceFilters, visited);
                continue;
            }
            if (dependency instanceof ModuleClassLoaderDependency) {
                PathFilter resourceExportFilter;
                PathFilter resourceImportFilter;
                ClassFilter classExportFilter;
                ModuleClassLoaderDependency classLoaderDependency = (ModuleClassLoaderDependency)dependency;
                localLoader = classLoaderDependency.getLocalLoader();
                for (Object filter : classFilterStack.getRawArray()) {
                    if (filter == null || filter == ClassFilters.acceptAll()) continue;
                    localLoader = this.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
                }
                for (Object filter : resourceFilterStack.getRawArray()) {
                    if (filter == null || filter == PathFilters.acceptAll()) continue;
                    localLoader = this.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
                }
                ClassFilter classFilter2 = classLoaderDependency.getClassImportFilter();
                if (classFilter2 != ClassFilters.acceptAll()) {
                    localLoader = this.createClassFilteredLocalLoader(classFilter2, localLoader);
                }
                if ((classExportFilter = classLoaderDependency.getClassExportFilter()) != ClassFilters.acceptAll()) {
                    localLoader = this.createClassFilteredLocalLoader(classExportFilter, localLoader);
                }
                if ((resourceImportFilter = classLoaderDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                    localLoader = this.createPathFilteredLocalLoader(resourceImportFilter, localLoader);
                }
                if ((resourceExportFilter = classLoaderDependency.getResourceExportFilter()) != PathFilters.acceptAll()) {
                    localLoader = this.createPathFilteredLocalLoader(resourceExportFilter, localLoader);
                }
                PathFilter importFilter = classLoaderDependency.getImportFilter();
                Set<String> paths = classLoaderDependency.getPaths();
                for (String path : paths) {
                    boolean accept;
                    boolean bl = accept = !"_private".equals(path);
                    if (accept) {
                        for (Object filter : filterStack.getRawArray()) {
                            if (filter == null || ((PathFilter)filter).accept(path)) continue;
                            accept = false;
                            break;
                        }
                    }
                    if (!accept || !importFilter.accept(path) || !exportFilter.accept(path)) continue;
                    List<LocalLoader> list = map.get(path);
                    if (list == null) {
                        list = new ArrayList<LocalLoader>(1);
                        map.put(path, list);
                        list.add(localLoader);
                        continue;
                    }
                    if (list.contains(localLoader)) continue;
                    list.add(localLoader);
                }
                continue;
            }
            if (!(dependency instanceof LocalDependency)) continue;
            LocalDependency localDependency = (LocalDependency)dependency;
            localLoader = localDependency.getLocalLoader();
            for (Object filter : classFilterStack.getRawArray()) {
                if (filter == null || filter == ClassFilters.acceptAll()) continue;
                localLoader = this.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
            }
            for (Object filter : resourceFilterStack.getRawArray()) {
                if (filter == null || filter == PathFilters.acceptAll()) continue;
                localLoader = this.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
            }
            ClassFilter classFilter3 = localDependency.getClassExportFilter();
            if (classFilter3 != ClassFilters.acceptAll()) {
                localLoader = this.createClassFilteredLocalLoader(classFilter3, localLoader);
            }
            if ((classFilter = localDependency.getClassImportFilter()) != ClassFilters.acceptAll()) {
                localLoader = this.createClassFilteredLocalLoader(classFilter, localLoader);
            }
            if ((resourceFilter = localDependency.getResourceExportFilter()) != PathFilters.acceptAll()) {
                localLoader = this.createPathFilteredLocalLoader(resourceFilter, localLoader);
            }
            if ((resourceFilter = localDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                localLoader = this.createPathFilteredLocalLoader(resourceFilter, localLoader);
            }
            Set<String> paths = localDependency.getPaths();
            for (String path : paths) {
                boolean accept = true;
                for (Object filter : filterStack.getRawArray()) {
                    if (filter == null || ((PathFilter)filter).accept(path)) continue;
                    accept = false;
                    break;
                }
                if (!accept || !localDependency.getImportFilter().accept(path) || !localDependency.getExportFilter().accept(path)) continue;
                List<LocalLoader> list = map.get(path);
                if (list == null) {
                    list = new ArrayList<LocalLoader>(1);
                    map.put(path, list);
                    list.add(localLoader);
                    continue;
                }
                if (list.contains(localLoader)) continue;
                list.add(localLoader);
            }
        }
        return subtract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Map<String, List<LocalLoader>> getPaths() throws ModuleLoadException {
        oldLinkage = this.linkage;
        state = oldLinkage.getState();
        if (state == Linkage.State.LINKED) {
            return oldLinkage.getPaths();
        }
        intr = false;
        while (true) lbl-1000:
        // 3 sources

        {
            var5_6 = this;
            synchronized (var5_6) {
                block24: {
                    oldLinkage = this.linkage;
                    state = oldLinkage.getState();
                    while (state == Linkage.State.LINKING || state == Linkage.State.NEW) {
                        try {
                            this.wait();
                            oldLinkage = this.linkage;
                            state = oldLinkage.getState();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                    if (state != Linkage.State.LINKED) break block24;
                    var6_7 = oldLinkage.getPaths();
                    return var6_7;
                }
                this.linkage = linkage = new Linkage(oldLinkage.getDependencySpecs(), oldLinkage.getDependencies(), Linkage.State.LINKING);
            }
            ok = false;
            try {
                this.link(linkage);
                ok = true;
            }
            finally {
                if (ok) continue;
                var6_7 = this;
                synchronized (var6_7) {
                    if (this.linkage == linkage) {
                        this.linkage = oldLinkage;
                        this.notifyAll();
                    }
                }
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    Map<String, List<LocalLoader>> getPathsUnchecked() {
        try {
            return this.getPaths();
        }
        catch (ModuleLoadException e) {
            throw e.toError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void link(Linkage linkage) throws ModuleLoadException {
        HashMap<String, List<LocalLoader>> importsMap = new HashMap<String, List<LocalLoader>>();
        Dependency[] dependencies = linkage.getDependencies();
        long start = Metrics.getCurrentCPUTime();
        long subtractTime = 0L;
        try {
            FastCopyHashSet<Visited> visited = new FastCopyHashSet<Visited>(16);
            FastCopyHashSet<PathFilter> filterStack = new FastCopyHashSet<PathFilter>(8);
            FastCopyHashSet<ClassFilter> classFilterStack = EMPTY_CLASS_FILTERS;
            FastCopyHashSet<PathFilter> resourceFilterStack = EMPTY_PATH_FILTERS;
            subtractTime += this.addPaths(dependencies, importsMap, filterStack, classFilterStack, resourceFilterStack, visited);
            Module module = this;
            synchronized (module) {
                if (this.linkage == linkage) {
                    this.linkage = new Linkage(linkage.getDependencySpecs(), linkage.getDependencies(), Linkage.State.LINKED, importsMap);
                    this.notifyAll();
                }
            }
        }
        finally {
            this.moduleLoader.addLinkTime(Metrics.getCurrentCPUTime() - start - subtractTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void relinkIfNecessary() throws ModuleLoadException {
        Linkage linkage;
        Linkage oldLinkage = this.linkage;
        if (oldLinkage.getState() != Linkage.State.UNLINKED) {
            return;
        }
        Module module = this;
        synchronized (module) {
            oldLinkage = this.linkage;
            if (oldLinkage.getState() != Linkage.State.UNLINKED) {
                return;
            }
            this.linkage = linkage = new Linkage(oldLinkage.getDependencySpecs(), oldLinkage.getDependencies(), Linkage.State.LINKING);
        }
        boolean ok = false;
        try {
            this.link(linkage);
            ok = true;
        }
        finally {
            if (!ok) {
                Module module2 = this;
                synchronized (module2) {
                    if (this.linkage == linkage) {
                        this.linkage = oldLinkage;
                        this.notifyAll();
                    }
                }
            }
        }
    }

    void relink() throws ModuleLoadException {
        this.link(this.linkage);
    }

    void setDependencies(List<DependencySpec> dependencySpecs) {
        DependencySpec[] specs;
        if (dependencySpecs == null) {
            throw new IllegalArgumentException("dependencySpecs is null");
        }
        for (DependencySpec spec : specs = (DependencySpec[])dependencySpecs.toArray(DependencySpec[]::new)) {
            if (spec != null) continue;
            throw new IllegalArgumentException("dependencySpecs contains a null dependency specification");
        }
        this.setDependencies(specs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDependencies(DependencySpec[] dependencySpecs) {
        Module module = this;
        synchronized (module) {
            this.linkage = new Linkage(dependencySpecs, this.calculateDependencies(dependencySpecs), Linkage.State.UNLINKED, null);
            this.notifyAll();
        }
    }

    private Dependency[] calculateDependencies(DependencySpec[] dependencySpecs) {
        Dependency[] dependencies = new Dependency[dependencySpecs.length];
        int i = 0;
        for (DependencySpec spec : dependencySpecs) {
            Dependency dependency = spec.getDependency(this);
            dependencies[i++] = dependency;
        }
        return dependencies;
    }

    String getMainClass() {
        return this.mainClassName;
    }

    Package getPackage(String name) {
        List<LocalLoader> loaders = this.getPathsUnchecked().get(name.replace('.', '/'));
        if (loaders != null) {
            for (LocalLoader localLoader : loaders) {
                Package pkg = localLoader.loadPackageLocal(name);
                if (pkg == null) continue;
                return pkg;
            }
        }
        return null;
    }

    Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        Map<String, List<LocalLoader>> allPaths = this.getPathsUnchecked();
        for (String path : allPaths.keySet()) {
            LocalLoader loader;
            Package pkg;
            String packageName = path.replace('/', '.');
            Iterator<LocalLoader> iterator = allPaths.get(path).iterator();
            if (!iterator.hasNext() || (pkg = (loader = iterator.next()).loadPackageLocal(packageName)) == null) continue;
            packages.add(pkg);
        }
        return (Package[])packages.toArray(Package[]::new);
    }

    static {
        MAIN_METHOD_TYPE = MethodType.methodType(Void.TYPE, String[].class);
        log = NoopModuleLogger.getInstance();
        BOOT_MODULE_LOADER = new AtomicReference();
        EMPTY_CLASS_FILTERS = new FastCopyHashSet(0);
        EMPTY_PATH_FILTERS = new FastCopyHashSet(0);
        GET_DEPENDENCIES = new RuntimePermission("getDependencies");
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
        GET_BOOT_MODULE_LOADER = new RuntimePermission("getBootModuleLoader");
        ACCESS_MODULE_LOGGER = new RuntimePermission("accessModuleLogger");
        ADD_CONTENT_HANDLER_FACTORY = new RuntimePermission("addContentHandlerFactory");
        ADD_URL_STREAM_HANDLER_FACTORY = new RuntimePermission("addURLStreamHandlerFactory");
        String pkgsString = AccessController.doPrivileged(new PropertyReadAction("jboss.modules.system.pkgs"));
        ArrayList<String> list = new ArrayList<String>();
        if (pkgsString != null) {
            int nc = -1;
            do {
                int i2;
                String part;
                if ((part = (nc = pkgsString.indexOf(44, i2 = nc + 1)) == -1 ? pkgsString.substring(i2).trim() : pkgsString.substring(i2, nc).trim()).isEmpty()) continue;
                list.add((part + ".").intern());
            } while (nc != -1);
        }
        systemPackages = (String[])list.toArray(String[]::new);
        systemPaths = (String[])list.stream().map(i -> i.replace('.', '/')).toArray(String[]::new);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(ModularURLStreamHandlerProvider.INSTANCE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    URLConnection.setContentHandlerFactory(ModularContentHandlerFactory.INSTANCE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        PRIVATE_ACCESS = new ModulesPrivateAccess(){

            @Override
            public ModuleClassLoader getClassLoaderOf(Module module) {
                return module.getClassLoaderPrivate();
            }
        };
        NO_PERMISSIONS = Module.noPermissions();
        STACK_WALKER = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
    }

    static final class Visited {
        private final Module module;
        private final FastCopyHashSet<PathFilter> filters;
        private final FastCopyHashSet<ClassFilter> classFilters;
        private final FastCopyHashSet<PathFilter> resourceFilters;
        private final int hashCode;

        Visited(Module module, FastCopyHashSet<PathFilter> filters, FastCopyHashSet<ClassFilter> classFilters, FastCopyHashSet<PathFilter> resourceFilters) {
            this.module = module;
            this.filters = filters;
            this.classFilters = classFilters;
            this.resourceFilters = resourceFilters;
            this.hashCode = ((resourceFilters.hashCode() * 13 + classFilters.hashCode()) * 13 + filters.hashCode()) * 13 + module.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return other instanceof Visited && this.equals((Visited)other);
        }

        public boolean equals(Visited other) {
            return this == other || other != null && this.module == other.module && this.filters.equals(other.filters) && this.classFilters.equals(other.classFilters) && this.resourceFilters.equals(other.resourceFilters);
        }
    }
}

