/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.spi.URLStreamHandlerProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.modules.DataURLStreamHandler;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.PropertyReadAction;

final class ModularURLStreamHandlerProvider
extends URLStreamHandlerProvider {
    private static final PrivilegedAction<String> URL_MODULES_LIST_ACTION = new PropertyReadAction("jboss.protocol.handler.modules");
    private static final List<Module> modules;
    private static final ThreadLocal<Set<String>> reentered;
    static final ModularURLStreamHandlerProvider INSTANCE;

    static void addHandlerModule(Module module) {
        modules.add(module);
    }

    private ModularURLStreamHandlerProvider() {
    }

    private URLStreamHandler locateHandler(String protocol) {
        for (Module module : modules) {
            URLStreamHandler handler = ModularURLStreamHandlerProvider.loadService(protocol, module, URLStreamHandlerProvider.class);
            if (handler != null) {
                return handler;
            }
            handler = ModularURLStreamHandlerProvider.loadService(protocol, module, URLStreamHandlerFactory.class);
            if (handler == null) continue;
            return handler;
        }
        return "data".equals(protocol) ? DataURLStreamHandler.getInstance() : null;
    }

    private static <T extends URLStreamHandlerFactory> URLStreamHandler loadService(String protocol, Module module, Class<T> providerType) {
        ServiceLoader<T> loader = module.loadService(providerType);
        for (URLStreamHandlerFactory factory : loader) {
            try {
                URLStreamHandler handler = factory.createURLStreamHandler(protocol);
                if (handler == null) continue;
                return handler;
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(final String protocol) {
        Set<String> set = reentered.get();
        if (set.add(protocol)) {
            try {
                if (System.getSecurityManager() == null) {
                    URLStreamHandler uRLStreamHandler = this.locateHandler(protocol);
                    return uRLStreamHandler;
                }
                URLStreamHandler uRLStreamHandler = AccessController.doPrivileged(new PrivilegedAction<URLStreamHandler>(){
                    final /* synthetic */ ModularURLStreamHandlerProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public URLStreamHandler run() {
                        return this.this$0.locateHandler(protocol);
                    }
                });
                return uRLStreamHandler;
            }
            finally {
                set.remove(protocol);
                if (set.isEmpty()) {
                    reentered.remove();
                }
            }
        }
        return null;
    }

    static {
        reentered = ThreadLocal.withInitial(FastCopyHashSet::new);
        CopyOnWriteArrayList<Module> list = new CopyOnWriteArrayList<Module>();
        SecurityManager sm = System.getSecurityManager();
        String urlModulesList = sm != null ? AccessController.doPrivileged(URL_MODULES_LIST_ACTION) : URL_MODULES_LIST_ACTION.run();
        if (urlModulesList != null) {
            int i;
            ArrayList<Module> moduleList = new ArrayList<Module>();
            int f = 0;
            do {
                String moduleId;
                if (!(moduleId = ((i = urlModulesList.indexOf(124, f)) == -1 ? urlModulesList.substring(f) : urlModulesList.substring(f, i)).trim()).isEmpty()) {
                    try {
                        Module module = Module.getBootModuleLoader().loadModule(moduleId);
                        moduleList.add(module);
                    }
                    catch (RuntimeException | ModuleLoadException exception) {
                        // empty catch block
                    }
                }
                f = i + 1;
            } while (i != -1);
            list.addAll(moduleList);
        }
        modules = list;
        INSTANCE = new ModularURLStreamHandlerProvider();
    }
}

