/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassLoaderLocalLoader;
import org.jboss.modules.DelegatingModuleLoader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.LocalDependencySpecBuilder;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathResourceLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderModuleFinder;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.SimpleSupplier;
import org.jboss.modules.Utils;
import org.jboss.modules.Version;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.xml.PermissionsXmlParser;
import org.jboss.modules.xml.XmlPullParserException;

public class FileSystemClassPathModuleFinder
implements ModuleFinder {
    static final ModuleLoader EMPTY_MODULE_LOADER = new ModuleLoader();
    static final SimpleSupplier<ModuleLoader> EMPTY_MODULE_LOADER_SUPPLIER = new SimpleSupplier<ModuleLoader>(EMPTY_MODULE_LOADER);
    private final AccessControlContext context;
    private final Supplier<ModuleLoader> baseModuleLoaderSupplier;
    private final Supplier<ModuleLoader> extensionModuleLoaderSupplier;
    private static final PathFilter NO_MODULES_DIR;

    public FileSystemClassPathModuleFinder(ModuleLoader baseModuleLoader) {
        this(baseModuleLoader, EMPTY_MODULE_LOADER_SUPPLIER);
    }

    public FileSystemClassPathModuleFinder(ModuleLoader baseModuleLoader, Supplier<ModuleLoader> extensionModuleLoaderSupplier) {
        this(new SimpleSupplier<ModuleLoader>(baseModuleLoader), extensionModuleLoaderSupplier);
        if (baseModuleLoader == null) {
            throw new IllegalArgumentException("baseModuleLoader is null");
        }
    }

    public FileSystemClassPathModuleFinder(Supplier<ModuleLoader> baseModuleLoaderSupplier, Supplier<ModuleLoader> extensionModuleLoaderSupplier) {
        if (baseModuleLoaderSupplier == null) {
            throw new IllegalArgumentException("baseModuleLoaderSupplier is null");
        }
        this.baseModuleLoaderSupplier = baseModuleLoaderSupplier;
        if (extensionModuleLoaderSupplier == null) {
            throw new IllegalArgumentException("extensionModuleLoaderSupplier is null");
        }
        this.extensionModuleLoaderSupplier = extensionModuleLoaderSupplier;
        this.context = AccessController.getContext();
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        Path path = Paths.get(name, new String[0]);
        if (!path.isAbsolute()) {
            return null;
        }
        Path normalizedPath = path.normalize();
        if (!path.equals(normalizedPath)) {
            return null;
        }
        try {
            DelegatingModuleLoader fatModuleLoader;
            AbstractResourceLoader resourceLoader;
            Manifest manifest;
            String fileName = path.toString();
            ModuleSpec.Builder builder = ModuleSpec.build(fileName);
            ModuleLoader baseModuleLoader = this.baseModuleLoaderSupplier.get();
            if (Files.isDirectory(path, new LinkOption[0])) {
                manifest = new Manifest();
                Path manifestPath = path.resolve("META-INF/MANIFEST.MF");
                if (Files.exists(manifestPath, new LinkOption[0])) {
                    try (InputStream stream2 = Files.newInputStream(manifestPath, StandardOpenOption.READ);){
                        manifest.read(stream2);
                    }
                    catch (FileNotFoundException | NoSuchFileException stream2) {
                    }
                    catch (IOException e) {
                        throw new ModuleLoadException("Failed to load MANIFEST from " + String.valueOf(path), e);
                    }
                }
                resourceLoader = new PathResourceLoader(fileName, path, this.context);
                fatModuleLoader = new DelegatingModuleLoader(baseModuleLoader, new LocalModuleFinder(new File[]{path.resolve("modules").toFile()}));
            } else {
                JarFile jarFile = new JarFile(path.toFile(), true, 1, JarFile.runtimeVersion());
                try {
                    try {
                        manifest = jarFile.getManifest();
                    }
                    catch (IOException e) {
                        throw new ModuleLoadException("Failed to load MANIFEST from " + String.valueOf(path), e);
                    }
                    resourceLoader = new JarFileResourceLoader(fileName, jarFile);
                }
                catch (Throwable t) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable e2) {
                        e2.addSuppressed(t);
                        throw e2;
                    }
                    throw t;
                }
                fatModuleLoader = new DelegatingModuleLoader(baseModuleLoader, new ResourceLoaderModuleFinder(resourceLoader));
            }
            try {
                this.addSelfContent(builder, resourceLoader);
                this.addSelfDependency(builder);
                Attributes mainAttributes = manifest.getMainAttributes();
                this.setMainClass(builder, mainAttributes);
                this.addClassPathDependencies(builder, delegateLoader, path, mainAttributes);
                ModuleLoader extensionModuleLoader = this.extensionModuleLoaderSupplier.get();
                this.addExtensionDependencies(builder, mainAttributes, extensionModuleLoader);
                this.addModuleDependencies(builder, fatModuleLoader, mainAttributes);
                this.setModuleVersion(builder, mainAttributes);
                this.addSystemDependencies(builder);
                this.addPermissions(builder, resourceLoader, delegateLoader);
            }
            catch (Throwable t) {
                resourceLoader.close();
                throw t;
            }
            return builder.create();
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
    }

    void addPermissions(ModuleSpec.Builder builder, ResourceLoader resourceLoader, ModuleLoader moduleLoader) {
        Resource resource = resourceLoader.getResource("META-INF/permissions.xml");
        if (resource != null) {
            try (InputStream stream = resource.openStream();){
                builder.setPermissionCollection(PermissionsXmlParser.parsePermissionsXml(stream, moduleLoader, builder.getName()));
            }
            catch (IOException | XmlPullParserException exception) {
                // empty catch block
            }
        }
    }

    void addSystemDependencies(ModuleSpec.Builder builder) {
        builder.addDependency(new LocalDependencySpecBuilder().setLocalLoader(ClassLoaderLocalLoader.SYSTEM).setLoaderPaths(JDKPaths.JDK).build());
    }

    void addModuleDependencies(ModuleSpec.Builder builder, ModuleLoader fatModuleLoader, Attributes mainAttributes) {
        String[] dependencyEntries;
        String dependencies = mainAttributes.getValue("Dependencies");
        for (String dependencyEntry : dependencyEntries = dependencies == null ? Utils.NO_STRINGS : dependencies.split("\\s*,\\s*")) {
            String[] fields;
            boolean optional = false;
            boolean export = false;
            boolean services = false;
            if ((dependencyEntry = dependencyEntry.trim()).isEmpty() || (fields = dependencyEntry.split("\\s+")).length < 1) continue;
            String moduleName = fields[0];
            for (int i = 1; i < fields.length; ++i) {
                String field = fields[i];
                if (field.equals("optional")) {
                    optional = true;
                    continue;
                }
                if (field.equals("export")) {
                    export = true;
                    continue;
                }
                if (!field.equals("services")) continue;
                services = true;
            }
            builder.addDependency(new ModuleDependencySpecBuilder().setImportServices(services).setExport(export).setModuleLoader(fatModuleLoader).setName(moduleName).setOptional(optional).build());
        }
    }

    void setModuleVersion(ModuleSpec.Builder builder, Attributes mainAttributes) {
        String versionString = mainAttributes.getValue("Module-Version");
        if (versionString != null) {
            builder.setVersion(Version.parse(versionString));
        }
    }

    void addExtensionDependencies(ModuleSpec.Builder builder, Attributes mainAttributes, ModuleLoader extensionModuleLoader) {
        String[] extensionListEntries;
        String extensionList = mainAttributes.getValue(Attributes.Name.EXTENSION_LIST);
        for (String entry : extensionListEntries = extensionList == null ? Utils.NO_STRINGS : extensionList.split("\\s+")) {
            if (entry.isEmpty()) continue;
            builder.addDependency(new ModuleDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setModuleLoader(extensionModuleLoader).setName(entry).setOptional(true).build());
        }
    }

    void addClassPathDependencies(ModuleSpec.Builder builder, ModuleLoader moduleLoader, Path path, Attributes mainAttributes) {
        String[] classPathEntries;
        String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        for (String entry : classPathEntries = classPath == null ? Utils.NO_STRINGS : classPath.split("\\s+")) {
            URI uri;
            if (entry.isEmpty()) continue;
            try {
                uri = new URI(entry);
            }
            catch (URISyntaxException e) {
                continue;
            }
            Path depPath = path.resolveSibling(Paths.get(uri)).normalize();
            builder.addDependency(new ModuleDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setModuleLoader(moduleLoader).setName(depPath.toString()).setOptional(true).build());
        }
    }

    void setMainClass(ModuleSpec.Builder builder, Attributes mainAttributes) {
        String mainClass = mainAttributes.getValue(Attributes.Name.MAIN_CLASS);
        if (mainClass != null) {
            builder.setMainClass(mainClass);
        }
    }

    void addSelfDependency(ModuleSpec.Builder builder) {
        builder.addDependency(DependencySpec.OWN_DEPENDENCY);
    }

    void addSelfContent(ModuleSpec.Builder builder, ResourceLoader resourceLoader) {
        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(resourceLoader, NO_MODULES_DIR));
    }

    static {
        MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder(true);
        builder.addFilter(PathFilters.is("modules"), false);
        builder.addFilter(PathFilters.isChildOf("modules"), false);
        NO_MODULES_DIR = builder.create();
    }
}

