/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.ProtectionDomain;
import org.jboss.modules.Module;

public final class ClassDefiner {
    private static final ClassDefiner instance = new ClassDefiner();
    private static final RuntimePermission createClassLoaderPermission = new RuntimePermission("createClassLoader");

    private ClassDefiner() {
    }

    public Class<?> defineClass(Class<?> originalClass, String className, ByteBuffer classBytes) {
        return this.defineClass(originalClass, className, this.getProtectionDomain(originalClass), classBytes);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) {
        return this.defineClass(originalClass, className, this.getProtectionDomain(originalClass), classBytes, off, len);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes) {
        return this.defineClass(originalClass, className, this.getProtectionDomain(originalClass), classBytes, 0, classBytes.length);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, ProtectionDomain protectionDomain, ByteBuffer classBytes) {
        Module module = Module.forClass(originalClass);
        if (module == null) {
            throw new IllegalArgumentException("Original " + String.valueOf(originalClass) + " does not have a module");
        }
        return module.getClassLoaderPrivate().defineClassInternal(className, classBytes, protectionDomain);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, ProtectionDomain protectionDomain, byte[] classBytes, int off, int len) {
        Module module = Module.forClass(originalClass);
        if (module == null) {
            throw new IllegalArgumentException("Original " + String.valueOf(originalClass) + " does not have a module");
        }
        return module.getClassLoaderPrivate().defineClassInternal(className, classBytes, off, len, protectionDomain);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, ProtectionDomain protectionDomain, byte[] classBytes) {
        return this.defineClass(originalClass, className, protectionDomain, classBytes, 0, classBytes.length);
    }

    public Class<?> defineClass(Module module, String className, ProtectionDomain protectionDomain, ByteBuffer classBytes) {
        return module.getClassLoaderPrivate().defineClassInternal(className, classBytes, protectionDomain);
    }

    public Class<?> defineClass(Module module, String className, ProtectionDomain protectionDomain, byte[] classBytes, int off, int len) {
        return module.getClassLoaderPrivate().defineClassInternal(className, classBytes, off, len, protectionDomain);
    }

    public Class<?> defineClass(Module module, String className, ProtectionDomain protectionDomain, byte[] classBytes) {
        return this.defineClass(module, className, protectionDomain, classBytes, 0, classBytes.length);
    }

    public static ClassDefiner getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(createClassLoaderPermission);
        }
        return instance;
    }

    private ProtectionDomain getProtectionDomain(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(clazz::getProtectionDomain);
        }
        return clazz.getProtectionDomain();
    }
}

