/*
 * Decompiled with CFR 0.152.
 */
package __redirected;

import __redirected.ConstructorSupplier;
import __redirected.__DatatypeFactory;
import __redirected.__DocumentBuilderFactory;
import __redirected.__RedirectedUtils;
import __redirected.__SAXParserFactory;
import __redirected.__SchemaFactory;
import __redirected.__TransformerFactory;
import __redirected.__XMLEventFactory;
import __redirected.__XMLInputFactory;
import __redirected.__XMLOutputFactory;
import __redirected.__XMLReaderFactory;
import __redirected.__XPathFactory;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    static final ClassLoader SAFE_CL;

    JDKSpecific() {
    }

    static Supplier<DatatypeFactory> getPlatformDatatypeFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(DatatypeFactory.class, __DatatypeFactory.class);
            Supplier<DatatypeFactory> supplier = JDKSpecific.getConstructorSupplier(DatatypeFactory.newInstance());
            System.setProperty(DatatypeFactory.class.getName(), __DatatypeFactory.class.getName());
            Supplier<DatatypeFactory> supplier2 = supplier;
            return supplier2;
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException("Problem configuring DatatypeFactory", e);
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<DocumentBuilderFactory> getPlatformDocumentBuilderFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(DocumentBuilderFactory.class, __DocumentBuilderFactory.class);
            Supplier<DocumentBuilderFactory> supplier = JDKSpecific.getConstructorSupplier(DocumentBuilderFactory.newInstance());
            System.setProperty(DocumentBuilderFactory.class.getName(), __DocumentBuilderFactory.class.getName());
            Supplier<DocumentBuilderFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<SAXParserFactory> getPlatformSaxParserFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(SAXParserFactory.class, __SAXParserFactory.class);
            Supplier<SAXParserFactory> supplier = JDKSpecific.getConstructorSupplier(SAXParserFactory.newInstance());
            System.setProperty(SAXParserFactory.class.getName(), __SAXParserFactory.class.getName());
            Supplier<SAXParserFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<SchemaFactory> getPlatformSchemaFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(SchemaFactory.class, __SchemaFactory.class);
            Supplier<SchemaFactory> supplier = JDKSpecific.getConstructorSupplier(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema"));
            System.setProperty(SchemaFactory.class.getName() + ":" + "http://www.w3.org/2001/XMLSchema", __SchemaFactory.class.getName());
            Supplier<SchemaFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<TransformerFactory> getPlatformSaxTransformerFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(TransformerFactory.class, __TransformerFactory.class);
            Supplier<TransformerFactory> supplier = JDKSpecific.getConstructorSupplier(TransformerFactory.newInstance());
            System.setProperty(TransformerFactory.class.getName(), __TransformerFactory.class.getName());
            Supplier<TransformerFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<XMLEventFactory> getPlatformXmlEventFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(XMLEventFactory.class, __XMLEventFactory.class);
            Supplier<XMLEventFactory> supplier = JDKSpecific.getConstructorSupplier(XMLEventFactory.newInstance());
            System.setProperty(XMLEventFactory.class.getName(), __XMLEventFactory.class.getName());
            Supplier<XMLEventFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<XMLInputFactory> getPlatformXmlInputFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(XMLInputFactory.class, __XMLInputFactory.class);
            Supplier<XMLInputFactory> supplier = JDKSpecific.getConstructorSupplier(XMLInputFactory.newInstance());
            System.setProperty(XMLInputFactory.class.getName(), __XMLInputFactory.class.getName());
            Supplier<XMLInputFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<XMLOutputFactory> getPlatformXmlOutputFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(XMLOutputFactory.class, __XMLOutputFactory.class);
            Supplier<XMLOutputFactory> supplier = JDKSpecific.getConstructorSupplier(XMLOutputFactory.newInstance());
            System.setProperty(XMLOutputFactory.class.getName(), __XMLOutputFactory.class.getName());
            Supplier<XMLOutputFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    static Supplier<XMLReader> getPlatformXmlReaderSupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        JDKSpecific.resetScanTracking();
        try {
            JDKSpecific.clearProperty("org.xml.sax.driver", __XMLReaderFactory.class);
            Supplier<XMLReader> supplier = JDKSpecific.getConstructorSupplier(XMLReaderFactory.createXMLReader());
            System.setProperty("org.xml.sax.driver", __XMLReaderFactory.class.getName());
            Supplier<XMLReader> supplier2 = supplier;
            return supplier2;
        }
        catch (SAXException e) {
            throw __RedirectedUtils.wrapped(new RuntimeException(e.getMessage()), e);
        }
        finally {
            JDKSpecific.resetScanTracking();
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Supplier<XPathFactory> getPlatformXPathFactorySupplier() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(SAFE_CL);
        try {
            JDKSpecific.clearProperty(XPathFactory.class, __XPathFactory.class);
            Supplier<XPathFactory> supplier = JDKSpecific.getConstructorSupplier(XPathFactory.newInstance());
            System.setProperty(XPathFactory.class.getName() + ":" + "http://java.sun.com/jaxp/xpath/dom", __XPathFactory.class.getName());
            Supplier<XPathFactory> supplier2 = supplier;
            return supplier2;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    private static void resetScanTracking() {
        try {
            Field clsFromJar = XMLReaderFactory.class.getDeclaredField("_clsFromJar");
            clsFromJar.setAccessible(true);
            clsFromJar.set(XMLReaderFactory.class, null);
            Field jarread = XMLReaderFactory.class.getDeclaredField("_jarread");
            jarread.setAccessible(true);
            jarread.setBoolean(XMLReaderFactory.class, false);
        }
        catch (NoSuchFieldException clsFromJar) {
        }
        catch (IllegalAccessException e) {
            throw __RedirectedUtils.wrapped(new RuntimeException(e.getMessage()), e);
        }
    }

    private static <T> Supplier<T> getConstructorSupplier(T factory) {
        try {
            return new ConstructorSupplier(factory.getClass().getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw __RedirectedUtils.wrapped(new NoSuchMethodError(e.getMessage()), e);
        }
    }

    private static void clearProperty(Class<?> propertyClass, Class<?> expectClass) {
        JDKSpecific.clearProperty(propertyClass.getName(), expectClass);
    }

    private static void clearProperty(String propertyName, Class<?> expectClass) {
        if (System.getProperty(propertyName, "").equals(expectClass.getName())) {
            System.clearProperty(propertyName);
        }
    }

    static {
        ClassLoader safeClassLoader = JDKSpecific.class.getClassLoader();
        if (safeClassLoader == null) {
            safeClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (safeClassLoader == null) {
            safeClassLoader = new ClassLoader(){};
        }
        SAFE_CL = safeClassLoader;
    }
}

