/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FileSystemClassPathModuleFinder;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.SimpleSupplier;
import org.jboss.modules.Utils;
import org.jboss.modules.filter.PathFilters;

final class ClassPathModuleFinder
extends FileSystemClassPathModuleFinder {
    private final String[] classPath;
    private final String[] dependencies;
    private final String mainClass;

    ClassPathModuleFinder(Supplier<ModuleLoader> baseModuleLoaderSupplier, String[] classPath, String[] dependencies, String mainClass) {
        super(baseModuleLoaderSupplier, (Supplier<ModuleLoader>)EMPTY_MODULE_LOADER_SUPPLIER);
        this.classPath = classPath;
        this.dependencies = dependencies;
        this.mainClass = mainClass;
    }

    ClassPathModuleFinder(ModuleLoader baseModuleLoader, String[] classpath, String dependencies, String mainClass) {
        this(new SimpleSupplier<ModuleLoader>(baseModuleLoader), classpath, dependencies == null ? Utils.NO_STRINGS : dependencies.split(","), mainClass);
    }

    @Override
    void addExtensionDependencies(ModuleSpec.Builder builder, Attributes mainAttributes, ModuleLoader extensionModuleLoader) {
    }

    @Override
    void addModuleDependencies(ModuleSpec.Builder builder, ModuleLoader fatModuleLoader, Attributes mainAttributes) {
        for (String dependency : this.dependencies) {
            builder.addDependency(new ModuleDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setModuleLoader(fatModuleLoader).setName(dependency).build());
        }
        super.addModuleDependencies(builder, fatModuleLoader, mainAttributes);
    }

    @Override
    void addClassPathDependencies(ModuleSpec.Builder builder, ModuleLoader moduleLoader, Path path, Attributes mainAttributes) {
        for (String item : this.classPath) {
            if (item.equals(builder.getName())) {
                builder.addDependency(DependencySpec.OWN_DEPENDENCY);
                continue;
            }
            builder.addDependency(new ModuleDependencySpecBuilder().setName(item).setOptional(true).build());
        }
    }

    @Override
    void addSelfDependency(ModuleSpec.Builder builder) {
    }

    @Override
    void setMainClass(ModuleSpec.Builder builder, Attributes mainAttributes) {
        if (this.mainClass != null) {
            builder.setMainClass(this.mainClass);
        }
    }
}

