/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class MavenSettings {
    private Path localRepository;
    private final List<String> remoteRepositories = new LinkedList<String>();
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final List<String> activeProfileNames = new LinkedList<String>();

    MavenSettings() {
        this.configureDefaults();
    }

    void configureDefaults() {
        String remoteRepository;
        String localRepositoryPath = System.getProperty("local.maven.repo.path");
        if (localRepositoryPath != null) {
            System.out.println("Please use 'maven.repo.local' instead of 'local.maven.repo.path'");
            this.localRepository = Paths.get(localRepositoryPath.split(File.pathSeparator)[0], new String[0]);
        }
        if ((localRepositoryPath = System.getProperty("maven.repo.local")) != null) {
            this.localRepository = Paths.get(localRepositoryPath, new String[0]);
        }
        if ((remoteRepository = System.getProperty("remote.maven.repo")) != null) {
            if (!remoteRepository.endsWith("/")) {
                remoteRepository = remoteRepository + "/";
            }
            this.remoteRepositories.add(remoteRepository);
        }
    }

    public void setLocalRepository(Path localRepository) {
        this.localRepository = localRepository;
    }

    public Path getLocalRepository() {
        return this.localRepository;
    }

    public List<String> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void addProfile(Profile profile) {
        this.profiles.put(profile.getId(), profile);
    }

    public void addActiveProfile(String profileName) {
        this.activeProfileNames.add(profileName);
    }

    void resolveActiveSettings() {
        for (String name : this.activeProfileNames) {
            Profile p = this.profiles.get(name);
            if (p == null) continue;
            this.remoteRepositories.addAll(p.getRepositories());
        }
    }

    static final class Profile {
        private String id;
        final List<String> repositories = new LinkedList<String>();

        Profile() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void addRepository(String url) {
            this.repositories.add(url);
        }

        public List<String> getRepositories() {
            return this.repositories;
        }
    }
}

