/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import __redirected.__JAXPRedirected;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import org.jboss.modules.ClassPathModuleLoader;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.JarModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.PropertyWriteAction;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.log.JDKModuleLogger;

public final class Main {
    private static final String[] NO_STRINGS;
    private static final String JAR_NAME;
    private static final String VERSION_STRING;

    private Main() {
    }

    private static void usage() {
        System.out.println("Usage: java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] <module-spec> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -jar <jar-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -cp <class-path> <class-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -class <class-name> [args...]");
        System.out.println("where <module-spec> is a valid module specification string");
        System.out.println("and options include:");
        System.out.println("    -help         Display this message");
        System.out.println("    -modulepath <search path of directories>");
        System.out.println("    -mp <search path of directories>");
        System.out.println("                  A list of directories, separated by '" + File.pathSeparator + "', where modules may be located");
        System.out.println("                  If not specified, the value of the \"module.path\" system property is used");
        System.out.println("    -class        Specify that the final argument is a");
        System.out.println("                  class to load from the class path; not compatible with -jar");
        System.out.println("    -cp,-classpath <search path of archives or directories>");
        System.out.println("                  A search path for class files; implies -class");
        System.out.println("    -dep,-dependencies <module-spec>[,<module-spec>,...]");
        System.out.println("                  A list of module dependencies to add to the class path;");
        System.out.println("                  requires -class or -cp");
        System.out.println("    -jar          Specify that the final argument is the name of a");
        System.out.println("                  JAR file to run as a module; not compatible with -class");
        System.out.println("    -config <config-location>");
        System.out.println("                  The location of the module configuration.  Either -mp or -config");
        System.out.println("                  may be specified, but not both");
        System.out.println("    -jaxpmodule <module-name>");
        System.out.println("                  The default JAXP implementation to use of the JDK");
        System.out.println("    -version      Print version and exit\n");
    }

    public static void main(String[] args) throws Throwable {
        String mbeanServerBuilderName;
        Module module;
        ModuleIdentifier moduleIdentifier;
        ModuleLoader loader;
        int argsLen = args.length;
        String deps = null;
        String[] moduleArgs = NO_STRINGS;
        String modulePath = null;
        String configPath = null;
        String classpath = null;
        boolean jar = false;
        boolean classpathDefined = false;
        boolean classDefined = false;
        String moduleIdentifierOrExeName = null;
        ModuleIdentifier jaxpModuleIdentifier = null;
        int argsLength = argsLen;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (arg.charAt(0) == '-') {
                    if ("-version".equals(arg)) {
                        System.out.println("JBoss Modules version " + Main.getVersionString());
                        return;
                    }
                    if ("-help".equals(arg)) {
                        Main.usage();
                        return;
                    }
                    if ("-modulepath".equals(arg) || "-mp".equals(arg)) {
                        if (modulePath != null) {
                            System.err.println("Module path may only be specified once");
                            System.exit(1);
                        }
                        if (configPath != null) {
                            System.err.println("Module path may not be specified with config path");
                            System.exit(1);
                        }
                        modulePath = args[++i];
                        System.setProperty("module.path", modulePath);
                        continue;
                    }
                    if ("-config".equals(arg)) {
                        if (configPath != null) {
                            System.err.println("Config file path may only be specified once");
                            System.exit(1);
                        }
                        if (modulePath != null) {
                            System.err.println("Module path may not be specified with config path");
                            System.exit(1);
                        }
                        configPath = args[++i];
                        continue;
                    }
                    if ("-jaxpmodule".equals(arg)) {
                        jaxpModuleIdentifier = ModuleIdentifier.fromString(args[++i]);
                        continue;
                    }
                    if ("-jar".equals(arg)) {
                        if (jar) {
                            System.err.println("-jar flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        jar = true;
                        continue;
                    }
                    if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                        if (classpathDefined) {
                            System.err.println("-cp or -classpath may only be specified once.");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        classpathDefined = true;
                        classpath = args[++i];
                        AccessController.doPrivileged(new PropertyWriteAction("java.class.path", classpath));
                        continue;
                    }
                    if ("-dep".equals(arg) || "-dependencies".equals(arg)) {
                        if (deps != null) {
                            System.err.println("-dep or -dependencies may only be specified once.");
                            System.exit(1);
                        }
                        deps = args[++i];
                        continue;
                    }
                    if ("-class".equals(arg)) {
                        if (classDefined) {
                            System.err.println("-class flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        classDefined = true;
                        continue;
                    }
                    System.err.printf("Invalid option '%s'\n", arg);
                    Main.usage();
                    System.exit(1);
                    continue;
                }
                moduleIdentifierOrExeName = arg;
                int cnt = argsLen - i - 1;
                moduleArgs = new String[cnt];
                System.arraycopy(args, i + 1, moduleArgs, 0, cnt);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                System.exit(1);
            }
        }
        if (deps != null && !classDefined && !classpathDefined) {
            System.err.println("-deps may only be specified when -cp/-classpath or -class is in use");
            System.exit(1);
        }
        if (moduleIdentifierOrExeName == null) {
            if (classDefined || classpathDefined) {
                System.err.println("No class name specified");
            } else if (jar) {
                System.err.println("No JAR specified");
            } else {
                System.err.println("No module specified");
            }
            Main.usage();
            System.exit(1);
        }
        ModuleLoader environmentLoader = configPath != null ? ModuleXmlParser.parseModuleConfigXml(new File(configPath)) : DefaultBootModuleLoaderHolder.INSTANCE;
        if (jar) {
            loader = new JarModuleLoader(environmentLoader, new JarFile(moduleIdentifierOrExeName));
            moduleIdentifier = ((JarModuleLoader)loader).getMyIdentifier();
        } else if (classpathDefined || classDefined) {
            loader = new ClassPathModuleLoader(environmentLoader, moduleIdentifierOrExeName, classpath, deps);
            moduleIdentifier = ModuleIdentifier.CLASSPATH;
        } else {
            loader = environmentLoader;
            moduleIdentifier = ModuleIdentifier.fromString(moduleIdentifierOrExeName);
        }
        Module.initBootModuleLoader(loader);
        if (jaxpModuleIdentifier != null) {
            __JAXPRedirected.changeAll(jaxpModuleIdentifier, Module.getBootModuleLoader());
        }
        try {
            module = loader.loadModule(moduleIdentifier);
        }
        catch (ModuleNotFoundException e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        ModuleClassLoader bootClassLoader = module.getClassLoaderPrivate();
        Main.setContextClassLoader(bootClassLoader);
        String logManagerName = Main.getServiceName(bootClassLoader, "java.util.logging.LogManager");
        if (logManagerName != null) {
            System.setProperty("java.util.logging.manager", logManagerName);
            if (LogManager.getLogManager().getClass() == LogManager.class) {
                System.err.println("WARNING: Failed to load the specified log manager class " + logManagerName);
            } else {
                Module.setModuleLogger(new JDKModuleLogger());
            }
        }
        if ((mbeanServerBuilderName = Main.getServiceName(bootClassLoader, "javax.management.MBeanServerBuilder")) != null) {
            System.setProperty("javax.management.builder.initial", mbeanServerBuilderName);
            ManagementFactory.getPlatformMBeanServer();
        }
        try {
            ModuleLoader.installMBeanServer();
            module.run(moduleArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServiceName(ClassLoader classLoader, String className) throws IOException {
        InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);
        if (stream != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((line = reader.readLine()) != null) {
                    int i = line.indexOf(35);
                    if (i != -1) {
                        line = line.substring(0, i);
                    }
                    if ((line = line.trim()).length() == 0) continue;
                    String string = line;
                    return string;
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    private static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Main.doSetContextClassLoader(classLoader);
                }
            });
        }
        return Main.doSetContextClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader doSetContextClassLoader(ClassLoader classLoader) {
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            return classLoader2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static String getJarName() {
        return JAR_NAME;
    }

    public static String getVersionString() {
        return VERSION_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long start = StartTimeHolder.START_TIME;
        NO_STRINGS = new String[0];
        String jarName = "(unknown)";
        String versionString = "(unknown)";
        try {
            Enumeration<URL> resources = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                if (stream == null) continue;
                try {
                    Manifest manifest = new Manifest(stream);
                    Attributes mainAttributes = manifest.getMainAttributes();
                    if (mainAttributes == null || !"JBoss Modules".equals(mainAttributes.getValue("Specification-Title"))) continue;
                    jarName = mainAttributes.getValue("Jar-Name");
                    versionString = mainAttributes.getValue("Jar-Version");
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JAR_NAME = jarName;
        VERSION_STRING = versionString;
    }
}

