/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.JarEntryResource;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoaders;

final class JarFileResourceLoader
extends AbstractResourceLoader {
    private final JarFile jarFile;
    private final String rootName;
    private final URL rootUrl;
    private final String relativePath;
    private final File fileOfJar;

    JarFileResourceLoader(String rootName, JarFile jarFile) {
        this(rootName, jarFile, null);
    }

    JarFileResourceLoader(String rootName, JarFile jarFile, String relativePath) {
        String realPath;
        if (jarFile == null) {
            throw new IllegalArgumentException("jarFile is null");
        }
        if (rootName == null) {
            throw new IllegalArgumentException("rootName is null");
        }
        this.fileOfJar = new File(jarFile.getName());
        this.jarFile = jarFile;
        this.rootName = rootName;
        this.relativePath = realPath = relativePath == null ? null : PathUtils.canonicalize(relativePath);
        try {
            this.rootUrl = JarFileResourceLoader.getJarURI(this.fileOfJar.toURI(), realPath).toURL();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid root file specified", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid root file specified", e);
        }
    }

    private static URI getJarURI(URI original, String nestedPath) throws URISyntaxException {
        StringBuilder b = new StringBuilder();
        b.append("file:");
        assert (original.getScheme().equals("file"));
        String path = original.getPath();
        assert (path != null);
        String host = original.getHost();
        if (host != null) {
            String userInfo = original.getRawUserInfo();
            b.append("//");
            if (userInfo != null) {
                b.append(userInfo).append('@');
            }
            b.append(host);
        }
        b.append(path).append("!/");
        if (nestedPath != null) {
            b.append(nestedPath);
        }
        return new URI("jar", b.toString(), null);
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public synchronized ClassSpec getClassSpec(String fileName) throws IOException {
        ClassSpec spec = new ClassSpec();
        JarEntry entry = this.getJarEntry(fileName);
        if (entry == null) {
            return null;
        }
        long size = entry.getSize();
        InputStream is = this.jarFile.getInputStream(entry);
        try {
            if (size == -1L) {
                int res;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[16384];
                while ((res = is.read(buf)) > 0) {
                    baos.write(buf, 0, res);
                }
                baos.close();
                is.close();
                spec.setBytes(baos.toByteArray());
                spec.setCodeSource(new CodeSource(this.rootUrl, entry.getCodeSigners()));
                ClassSpec classSpec = spec;
                return classSpec;
            }
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = is.read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                while (is.read() != -1) {
                }
                is.close();
                spec.setBytes(bytes);
                spec.setCodeSource(new CodeSource(this.rootUrl, entry.getCodeSigners()));
                ClassSpec classSpec = spec;
                return classSpec;
            }
            throw new IOException("Resource is too large to be a valid class file");
        }
        finally {
            JarFileResourceLoader.safeClose(is);
        }
    }

    private JarEntry getJarEntry(String fileName) {
        return this.relativePath == null ? this.jarFile.getJarEntry(fileName) : this.jarFile.getJarEntry(this.relativePath + "/" + fileName);
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        Manifest manifest;
        if (this.relativePath == null) {
            manifest = this.jarFile.getManifest();
        } else {
            JarEntry jarEntry = this.getJarEntry("META-INF/MANIFEST.MF");
            if (jarEntry == null) {
                manifest = null;
            } else {
                InputStream inputStream = this.jarFile.getInputStream(jarEntry);
                try {
                    manifest = new Manifest(inputStream);
                }
                finally {
                    JarFileResourceLoader.safeClose(inputStream);
                }
            }
        }
        return JarFileResourceLoader.getPackageSpec(name, manifest, this.rootUrl);
    }

    @Override
    public String getLibrary(String name) {
        return null;
    }

    @Override
    public Resource getResource(String name) {
        try {
            JarEntry entry;
            JarFile jarFile = this.jarFile;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((entry = this.getJarEntry(name)) == null) {
                return null;
            }
            String jarFilePath = new File(jarFile.getName()).toURI().toString();
            return new JarEntryResource(jarFile, entry, new URI("jar", jarFilePath + "!/" + entry.getName(), null).toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPaths() {
        long entryTime;
        JarEntry listEntry;
        long indexModified;
        HashSet<String> index = new HashSet<String>();
        index.add("");
        String relativePath = this.relativePath;
        JarFile jarFile = this.jarFile;
        String jarFileName = jarFile.getName();
        long jarModified = this.fileOfJar.lastModified();
        File indexFile = new File(jarFileName + ".index");
        if (indexFile.exists() && (indexModified = indexFile.lastModified()) != 0L && jarModified != 0L && indexModified >= jarModified) {
            try {
                return JarFileResourceLoader.readIndex(new FileInputStream(indexFile), index, relativePath);
            }
            catch (IOException e) {
                index.clear();
            }
        }
        if ((listEntry = jarFile.getJarEntry("META-INF/PATHS.LIST")) != null && jarModified != 0L && ((entryTime = listEntry.getTime()) == -1L || entryTime >= jarModified)) {
            try {
                return JarFileResourceLoader.readIndex(jarFile.getInputStream(listEntry), index, relativePath);
            }
            catch (IOException e) {
                index.clear();
            }
        }
        index.add("");
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String path;
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            int idx = name.lastIndexOf(47);
            if (idx == -1 || (path = name.substring(0, idx)).length() == 0 || path.endsWith("/")) continue;
            if (relativePath == null) {
                index.add(path);
                continue;
            }
            if (!path.startsWith(relativePath + "/")) continue;
            index.add(path.substring(relativePath.length() + 1));
        }
        if (ResourceLoaders.WRITE_INDEXES && relativePath == null) {
            boolean ok = false;
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(indexFile)));
                try {
                    for (String name : index) {
                        writer.write(name);
                        writer.write(10);
                    }
                    writer.close();
                    ok = true;
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (IOException e) {
            }
            finally {
                if (!ok) {
                    indexFile.delete();
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> readIndex(InputStream stream, Collection<String> index, String relativePath) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        try {
            String s;
            while ((s = r.readLine()) != null) {
                String name = s.trim();
                if (relativePath == null) {
                    index.add(name);
                    continue;
                }
                if (!name.startsWith(relativePath + "/")) continue;
                index.add(name.substring(relativePath.length() + 1));
            }
            Collection<String> collection = index;
            return collection;
        }
        finally {
            r.close();
        }
    }
}

