/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.modules.CallerContext;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.Linkage;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Metrics;
import org.jboss.modules.ModularContentHandlerFactory;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderDependency;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.Resource;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.NoopModuleLogger;

public final class Module {
    private static final AtomicReference<ModuleLoader> BOOT_MODULE_LOADER = new AtomicReference();
    static final String[] systemPackages;
    static final String[] systemPaths;
    static volatile ModuleLogger log;
    private final ModuleIdentifier identifier;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final Object myKey;
    private final LocalLoader fallbackLoader;
    private volatile Linkage linkage = Linkage.NONE;
    private static final RuntimePermission GET_CLASS_LOADER;
    private static final RuntimePermission GET_BOOT_MODULE_LOADER;
    private static final RuntimePermission ACCESS_MODULE_LOGGER;
    private static final RuntimePermission ADD_CONTENT_HANDLER_FACTORY;
    private static final RuntimePermission ADD_URL_STREAM_HANDLER_FACTORY;

    Module(ConcreteModuleSpec spec, ModuleLoader moduleLoader, Object myKey) {
        this.moduleLoader = moduleLoader;
        this.myKey = myKey;
        this.identifier = spec.getModuleIdentifier();
        this.mainClassName = spec.getMainClass();
        this.fallbackLoader = spec.getFallbackLoader();
        ModuleClassLoader.Configuration configuration = new ModuleClassLoader.Configuration(this, spec.getAssertionSetting(), spec.getResourceLoaders(), spec.getClassFileTransformer());
        ModuleClassLoaderFactory factory = spec.getModuleClassLoaderFactory();
        ModuleClassLoader moduleClassLoader = null;
        if (factory != null) {
            moduleClassLoader = factory.create(configuration);
        }
        if (moduleClassLoader == null) {
            moduleClassLoader = new ModuleClassLoader(configuration);
        }
        this.moduleClassLoader = moduleClassLoader;
    }

    LocalLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    Dependency[] getDependencies() {
        return this.linkage.getSourceList();
    }

    ModuleClassLoader getClassLoaderPrivate() {
        return this.moduleClassLoader;
    }

    public Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        try {
            if (this.mainClassName == null) {
                throw new NoSuchMethodException("No main class defined for " + this);
            }
            Class<?> mainClass = this.moduleClassLoader.loadClass(this.mainClassName);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new NoSuchMethodException("Main method is not static for " + this);
            }
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
                mainMethod.invoke(null, new Object[]{args});
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public static <S> ServiceLoader<S> loadServiceFromCallerModuleLoader(ModuleIdentifier identifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier).loadService(serviceType);
    }

    public ModuleClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASS_LOADER);
        }
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.getPathsUnchecked(true).keySet());
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return Module.forClassLoader(cl, false);
    }

    public static Module forClassLoader(ClassLoader cl, boolean search) {
        if (cl instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)cl).getModule();
        }
        if (search) {
            return Module.forClassLoader(cl.getParent(), true);
        }
        return null;
    }

    public static ModuleLoader getBootModuleLoader() {
        ModuleLoader loader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_BOOT_MODULE_LOADER);
        }
        while ((loader = BOOT_MODULE_LOADER.get()) == null && !BOOT_MODULE_LOADER.compareAndSet(null, loader = DefaultBootModuleLoaderHolder.INSTANCE)) {
        }
        return loader;
    }

    static void initBootModuleLoader(ModuleLoader loader) {
        BOOT_MODULE_LOADER.set(loader);
    }

    public static ModuleLoader getCallerModuleLoader() {
        Module callerModule = Module.getCallerModule();
        return callerModule == null ? null : callerModule.getModuleLoader();
    }

    public static ModuleLoader getContextModuleLoader() {
        return Module.forClassLoader(Thread.currentThread().getContextClassLoader(), true).getModuleLoader();
    }

    public static Module getModuleFromCallerModuleLoader(ModuleIdentifier identifier) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier);
    }

    public static Module getCallerModule() {
        return Module.forClass(CallerContext.getCallingClass());
    }

    public Module getModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return this.moduleLoader.loadModule(identifier);
    }

    public static Class<?> loadClassFromBootModuleLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getBootModuleLoader().loadModule(moduleIdentifier).getClassLoader());
    }

    public static Class<?> loadClassFromCallerModuleLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getModuleFromCallerModuleLoader(moduleIdentifier).getClassLoader());
    }

    Class<?> loadModuleClass(String className, boolean exportsOnly, boolean resolve) {
        LocalLoader fallbackLoader;
        for (String s : systemPackages) {
            if (!className.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.loadClass(className, resolve);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        String path = Module.pathOfClass(className);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                Class<?> clazz = loader.loadClassLocal(className, resolve);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            return fallbackLoader.loadClassLocal(className, resolve);
        }
        return null;
    }

    URL getResource(String name, boolean exportsOnly) {
        List<Resource> resourceList;
        Iterator<Resource> i$;
        LocalLoader fallbackLoader;
        for (String s : systemPaths) {
            if (!name.startsWith(s)) continue;
            return this.moduleClassLoader.getResource(name);
        }
        log.trace("Attempting to find resource %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList2 = loader.loadResourceLocal(name);
                Iterator<Resource> i$2 = resourceList2.iterator();
                if (!i$2.hasNext()) continue;
                Resource resource = i$2.next();
                return resource.getURL();
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null && (i$ = (resourceList = fallbackLoader.loadResourceLocal(name)).iterator()).hasNext()) {
            Resource resource = i$.next();
            return resource.getURL();
        }
        return null;
    }

    Enumeration<URL> getResources(String name, boolean exportsOnly) {
        LocalLoader fallbackLoader;
        for (String s : systemPaths) {
            if (!name.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.getResources(name);
            }
            catch (IOException e) {
                return ConcurrentClassLoader.EMPTY_ENUMERATION;
            }
        }
        log.trace("Attempting to find all resources %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        ArrayList<URL> list = new ArrayList<URL>();
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList = loader.loadResourceLocal(name);
                for (Resource resource : resourceList) {
                    list.add(resource.getURL());
                }
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            List<Resource> resourceList = fallbackLoader.loadResourceLocal(name);
            for (Resource resource : resourceList) {
                list.add(resource.getURL());
            }
        }
        return list.size() == 0 ? ConcurrentClassLoader.EMPTY_ENUMERATION : Collections.enumeration(list);
    }

    public URL getExportedResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration<URL> getExportedResources(String name) {
        return this.getResources(name, true);
    }

    static String pathOfClass(String className) {
        String resourceName = className.replace('.', '/');
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String pathOf(String resourceName) {
        if (resourceName.indexOf(47) == 0) {
            return Module.pathOf(resourceName.substring(1));
        }
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String fileNameOfClass(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String toString() {
        return "Module \"" + this.identifier + "\"" + " from " + this.moduleLoader.toString();
    }

    public static ModuleLogger getModuleLogger() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        return log;
    }

    public static void setModuleLogger(ModuleLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        logger.greeting();
        log = logger;
    }

    public static long getStartTime() {
        return StartTimeHolder.START_TIME;
    }

    public static void registerContentHandlerFactoryModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONTENT_HANDLER_FACTORY);
        }
        ModularContentHandlerFactory.addHandlerModule(module);
    }

    public static void registerURLStreamHandlerFactoryModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_URL_STREAM_HANDLER_FACTORY);
        }
        ModularURLStreamHandlerFactory.addHandlerModule(module);
    }

    void addPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map) throws ModuleLoadException {
        FastCopyHashSet<Visited> visited = new FastCopyHashSet<Visited>(16);
        this.moduleLoader.incScanCount();
        for (Dependency dependency : dependencies) {
            List<LocalLoader> list;
            Set<String> paths;
            PathFilter importFilter;
            LocalLoader localLoader;
            if (dependency instanceof ModuleDependency) {
                Module module;
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                ModuleIdentifier id = moduleDependency.getIdentifier();
                try {
                    module = moduleLoader.preloadModule(id);
                }
                catch (ModuleLoadException ex) {
                    if (moduleDependency.isOptional()) continue;
                    throw ex;
                }
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new ModuleNotFoundException(id.toString());
                }
                PathFilter importFilter2 = dependency.getImportFilter();
                FastCopyHashSet<PathFilter> filterStack = new FastCopyHashSet<PathFilter>(8);
                filterStack.add(importFilter2);
                module.addExportedPaths(module.getDependencies(), map, filterStack, visited);
                continue;
            }
            if (dependency instanceof ModuleClassLoaderDependency) {
                ModuleClassLoaderDependency classLoaderDependency = (ModuleClassLoaderDependency)dependency;
                localLoader = classLoaderDependency.getLocalLoader();
                importFilter = classLoaderDependency.getImportFilter();
                paths = classLoaderDependency.getPaths();
                for (String path : paths) {
                    if (!importFilter.accept(path)) continue;
                    list = map.get(path);
                    if (list == null) {
                        list = new ArrayList<LocalLoader>();
                        map.put(path, list);
                        list.add(localLoader);
                        continue;
                    }
                    if (list.contains(localLoader)) continue;
                    list.add(localLoader);
                }
                continue;
            }
            if (!(dependency instanceof LocalDependency)) continue;
            LocalDependency localDependency = (LocalDependency)dependency;
            localLoader = localDependency.getLocalLoader();
            importFilter = localDependency.getImportFilter();
            paths = localDependency.getPaths();
            for (String path : paths) {
                if (!importFilter.accept(path)) continue;
                list = map.get(path);
                if (list == null) {
                    list = new ArrayList<LocalLoader>();
                    map.put(path, list);
                    list.add(localLoader);
                    continue;
                }
                if (list.contains(localLoader)) continue;
                list.add(localLoader);
            }
        }
    }

    void addExportedPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map) throws ModuleLoadException {
        this.addExportedPaths(dependencies, map, new FastCopyHashSet<PathFilter>(), new FastCopyHashSet<Visited>());
    }

    void addExportedPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map, FastCopyHashSet<PathFilter> filterStack, Set<Visited> visited) throws ModuleLoadException {
        if (!visited.add(new Visited(this, filterStack))) {
            return;
        }
        this.moduleLoader.incScanCount();
        for (Dependency dependency : dependencies) {
            List<LocalLoader> list;
            Set<String> paths;
            LocalLoader localLoader;
            if (dependency instanceof ModuleDependency) {
                Module module;
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                ModuleIdentifier id = moduleDependency.getIdentifier();
                try {
                    module = moduleLoader.preloadModule(id);
                }
                catch (ModuleLoadException ex) {
                    if (moduleDependency.isOptional()) continue;
                    throw ex;
                }
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new ModuleNotFoundException(id.toString());
                }
                PathFilter exportFilter = dependency.getExportFilter();
                if (exportFilter == PathFilters.rejectAll()) continue;
                PathFilter importFilter = dependency.getImportFilter();
                if (filterStack.contains(importFilter) && filterStack.contains(exportFilter)) {
                    module.addExportedPaths(module.getDependencies(), map, filterStack, visited);
                    continue;
                }
                Object clone = filterStack.clone();
                ((FastCopyHashSet)clone).add(importFilter);
                ((FastCopyHashSet)clone).add(exportFilter);
                module.addExportedPaths(module.getDependencies(), map, (FastCopyHashSet<PathFilter>)clone, visited);
                continue;
            }
            if (dependency instanceof ModuleClassLoaderDependency) {
                ModuleClassLoaderDependency classLoaderDependency = (ModuleClassLoaderDependency)dependency;
                localLoader = classLoaderDependency.getLocalLoader();
                paths = classLoaderDependency.getPaths();
                for (String path : paths) {
                    boolean accept = true;
                    for (Object filter : filterStack.getRawArray()) {
                        if (filter == null || ((PathFilter)filter).accept(path)) continue;
                        accept = false;
                        break;
                    }
                    if (!accept || !classLoaderDependency.getImportFilter().accept(path) || !classLoaderDependency.getExportFilter().accept(path)) continue;
                    list = map.get(path);
                    if (list == null) {
                        list = new ArrayList<LocalLoader>(1);
                        map.put(path, list);
                        list.add(localLoader);
                        continue;
                    }
                    if (list.contains(localLoader)) continue;
                    list.add(localLoader);
                }
                continue;
            }
            if (!(dependency instanceof LocalDependency)) continue;
            LocalDependency localDependency = (LocalDependency)dependency;
            localLoader = localDependency.getLocalLoader();
            paths = localDependency.getPaths();
            for (String path : paths) {
                boolean accept = true;
                for (Object filter : filterStack.getRawArray()) {
                    if (filter == null || ((PathFilter)filter).accept(path)) continue;
                    accept = false;
                    break;
                }
                if (!accept || !localDependency.getImportFilter().accept(path) || !localDependency.getExportFilter().accept(path)) continue;
                list = map.get(path);
                if (list == null) {
                    list = new ArrayList<LocalLoader>(1);
                    map.put(path, list);
                    list.add(localLoader);
                    continue;
                }
                if (list.contains(localLoader)) continue;
                list.add(localLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<LocalLoader>> getPaths(boolean exports) throws ModuleLoadException {
        Linkage linkage = this.linkage;
        Linkage.State state = linkage.getState();
        if (state == Linkage.State.LINKED) {
            return linkage.getPaths(exports);
        }
        boolean intr = false;
        try {
            while (true) {
                Module module = this;
                synchronized (module) {
                    block14: {
                        linkage = this.linkage;
                        state = linkage.getState();
                        while (state == Linkage.State.LINKING || state == Linkage.State.NEW) {
                            try {
                                this.wait();
                                linkage = this.linkage;
                                state = linkage.getState();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                        if (state != Linkage.State.LINKED) break block14;
                        Map<String, List<LocalLoader>> map = linkage.getPaths(exports);
                        return map;
                    }
                    this.linkage = linkage = new Linkage(linkage.getSourceList(), Linkage.State.LINKING);
                }
                this.link(linkage);
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    Map<String, List<LocalLoader>> getPathsUnchecked(boolean export) {
        try {
            return this.getPaths(export);
        }
        catch (ModuleLoadException e) {
            throw e.toError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void link(Linkage linkage) throws ModuleLoadException {
        HashMap<String, List<LocalLoader>> importsMap = new HashMap<String, List<LocalLoader>>();
        HashMap<String, List<LocalLoader>> exportsMap = new HashMap<String, List<LocalLoader>>();
        Dependency[] dependencies = linkage.getSourceList();
        long start = Metrics.getCurrentCPUTime();
        try {
            this.addPaths(dependencies, importsMap);
            this.addExportedPaths(dependencies, exportsMap);
            Module module = this;
            synchronized (module) {
                if (this.linkage == linkage) {
                    this.linkage = new Linkage(linkage.getSourceList(), Linkage.State.LINKED, importsMap, exportsMap);
                    this.notifyAll();
                }
            }
        }
        finally {
            this.moduleLoader.addLinkTime(Metrics.getCurrentCPUTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void relinkIfNecessary() throws ModuleLoadException {
        Linkage linkage = this.linkage;
        if (linkage.getState() != Linkage.State.UNLINKED) {
            return;
        }
        Module module = this;
        synchronized (module) {
            linkage = this.linkage;
            if (linkage.getState() != Linkage.State.UNLINKED) {
                return;
            }
            this.linkage = linkage = new Linkage(linkage.getSourceList(), Linkage.State.LINKING);
        }
        this.link(linkage);
    }

    void relink() throws ModuleLoadException {
        this.link(this.linkage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDependencies(List<DependencySpec> dependencySpecs) throws ModuleLoadException {
        Module module = this;
        synchronized (module) {
            this.linkage = new Linkage(this.calculateDependencies(dependencySpecs), Linkage.State.UNLINKED, null, null);
            this.notifyAll();
        }
    }

    private Dependency[] calculateDependencies(List<DependencySpec> dependencySpecs) {
        Dependency[] dependencies = new Dependency[dependencySpecs.size()];
        int i = 0;
        for (DependencySpec spec : dependencySpecs) {
            Dependency dependency = spec.getDependency(this);
            dependencies[i++] = dependency;
        }
        return dependencies;
    }

    String getMainClass() {
        return this.mainClassName;
    }

    Package getPackage(String name) {
        List<LocalLoader> loaders = this.getPathsUnchecked(false).get(name.replace('.', '/'));
        if (loaders != null) {
            for (LocalLoader localLoader : loaders) {
                Package pkg = localLoader.loadPackageLocal(name);
                if (pkg == null) continue;
                return pkg;
            }
        }
        return null;
    }

    Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        Map<String, List<LocalLoader>> allPaths = this.getPathsUnchecked(false);
        for (String path : allPaths.keySet()) {
            LocalLoader loader;
            Package pkg;
            String packageName = path.replace('/', '.');
            Iterator<LocalLoader> i$ = allPaths.get(path).iterator();
            if (!i$.hasNext() || (pkg = (loader = i$.next()).loadPackageLocal(packageName)) == null) continue;
            packages.add(pkg);
        }
        return packages.toArray(new Package[packages.size()]);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(new ModularURLStreamHandlerFactory());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    URLConnection.setContentHandlerFactory(new ModularContentHandlerFactory());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        String pkgsString = AccessController.doPrivileged(new PropertyReadAction("jboss.modules.system.pkgs"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("java.");
        list.add("sun.reflect.");
        if (pkgsString != null) {
            int nc = -1;
            do {
                int i;
                String part;
                if ((part = (nc = pkgsString.indexOf(44, i = nc + 1)) == -1 ? pkgsString.substring(i).trim() : pkgsString.substring(i, nc).trim()).length() <= 0) continue;
                list.add((part + ".").intern());
            } while (nc != -1);
        }
        systemPackages = list.toArray(list.toArray(new String[list.size()]));
        ListIterator<String> iterator = list.listIterator();
        while (iterator.hasNext()) {
            iterator.set(((String)iterator.next()).replace('.', '/'));
        }
        systemPaths = list.toArray(list.toArray(new String[list.size()]));
        log = NoopModuleLogger.getInstance();
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
        GET_BOOT_MODULE_LOADER = new RuntimePermission("getBootModuleLoader");
        ACCESS_MODULE_LOGGER = new RuntimePermission("accessModuleLogger");
        ADD_CONTENT_HANDLER_FACTORY = new RuntimePermission("addContentHandlerFactory");
        ADD_URL_STREAM_HANDLER_FACTORY = new RuntimePermission("addURLStreamHandlerFactory");
    }

    static final class Visited {
        private final Module module;
        private final FastCopyHashSet<PathFilter> filters;
        private final int hashCode;

        Visited(Module module, FastCopyHashSet<PathFilter> filters) {
            this.module = module;
            this.filters = filters;
            this.hashCode = filters.hashCode() * 13 + module.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return other instanceof Visited && this.equals((Visited)other);
        }

        public boolean equals(Visited other) {
            return this == other || other != null && this.module == other.module && this.filters.equals(other.filters);
        }
    }
}

