/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarFile;
import java.util.logging.LogManager;
import org.jboss.modules.ClassPathModuleLoader;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.JarModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.PropertyWriteAction;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.log.JDKModuleLogger;

public final class Main {
    private static final String[] NO_STRINGS;

    private Main() {
    }

    private static void usage() {
        System.out.println("Usage: java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] <module-spec> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -jar <jar-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -cp <class-path> <class-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -class <class-name> [args...]");
        System.out.println("where <module-spec> is a valid module specification string");
        System.out.println("and options include:");
        System.out.println("    -help         Display this message");
        System.out.println("    -modulepath <search path of directories>");
        System.out.println("    -mp <search path of directories>");
        System.out.println("                  A list of directories, separated by '" + File.pathSeparator + "', where modules may be located");
        System.out.println("                  If not specified, the value of the \"module.path\" system property is used");
        System.out.println("    -class        Specify that the final argument is a");
        System.out.println("                  class to load from the class path; not compatible with -jar");
        System.out.println("    -cp,-classpath <search path of archives or directories>");
        System.out.println("                  A search path for class files; implies -class");
        System.out.println("    -dep,-dependencies <module-spec>[,<module-spec>,...]");
        System.out.println("                  A list of module dependencies to add to the class path;");
        System.out.println("                  requires -class or -cp");
        System.out.println("    -jar          Specify that the final argument is the name of a");
        System.out.println("                  JAR file to run as a module; not compatible with -class");
        System.out.println("    -config <config-location>");
        System.out.println("                  The location of the module configuration.  Either -mp or -config");
        System.out.println("                  may be specified, but not both");
        System.out.println("    -logmodule <module-name>");
        System.out.println("                  The module to use to load the system logmanager");
        System.out.println("    -version      Print version and exit\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Throwable {
        Module module;
        ModuleIdentifier moduleIdentifier;
        ModuleLoader loader;
        int argsLen = args.length;
        String deps = null;
        String[] moduleArgs = NO_STRINGS;
        String modulePath = null;
        String configPath = null;
        String classpath = null;
        boolean jar = false;
        boolean classpathDefined = false;
        boolean classDefined = false;
        String moduleIdentifierOrExeName = null;
        ModuleIdentifier logManagerModuleIdentifier = null;
        int argsLength = argsLen;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (arg.charAt(0) == '-') {
                    if ("-version".equals(arg)) {
                        System.out.println("Module loader " + Main.getVersionString());
                        return;
                    }
                    if ("-help".equals(arg)) {
                        Main.usage();
                        return;
                    }
                    if ("-modulepath".equals(arg) || "-mp".equals(arg)) {
                        if (modulePath != null) {
                            System.err.println("Module path may only be specified once");
                            System.exit(1);
                        }
                        if (configPath != null) {
                            System.err.println("Module path may not be specified with config path");
                            System.exit(1);
                        }
                        modulePath = args[++i];
                        System.setProperty("module.path", modulePath);
                        continue;
                    }
                    if ("-config".equals(arg)) {
                        if (configPath != null) {
                            System.err.println("Config file path may only be specified once");
                            System.exit(1);
                        }
                        if (modulePath != null) {
                            System.err.println("Module path may not be specified with config path");
                            System.exit(1);
                        }
                        configPath = args[++i];
                        continue;
                    }
                    if ("-logmodule".equals(arg)) {
                        logManagerModuleIdentifier = ModuleIdentifier.fromString(args[++i]);
                        continue;
                    }
                    if ("-jar".equals(arg)) {
                        if (jar) {
                            System.err.println("-jar flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        jar = true;
                        continue;
                    }
                    if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                        if (classpathDefined) {
                            System.err.println("-cp or -classpath may only be specified once.");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        classpathDefined = true;
                        classpath = args[++i];
                        AccessController.doPrivileged(new PropertyWriteAction("java.class.path", classpath));
                        continue;
                    }
                    if ("-dep".equals(arg) || "-dependencies".equals(arg)) {
                        if (deps != null) {
                            System.err.println("-dep or -dependencies may only be specified once.");
                            System.exit(1);
                        }
                        deps = args[++i];
                        continue;
                    }
                    if ("-class".equals(arg)) {
                        if (classDefined) {
                            System.err.println("-class flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        classDefined = true;
                        continue;
                    }
                    System.err.printf("Invalid option '%s'\n", arg);
                    Main.usage();
                    System.exit(1);
                    continue;
                }
                moduleIdentifierOrExeName = arg;
                int e = argsLen - i - 1;
                moduleArgs = new String[e];
                System.arraycopy(args, i + 1, moduleArgs, 0, e);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                System.exit(1);
            }
        }
        if (deps != null && !classDefined && !classpathDefined) {
            System.err.println("-deps may only be specified when -cp/-classpath or -class is in use");
            System.exit(1);
        }
        if (moduleIdentifierOrExeName == null) {
            if (classDefined || classpathDefined) {
                System.err.println("No class name specified");
            } else if (jar) {
                System.err.println("No JAR specified");
            } else {
                System.err.println("No module specified");
            }
            Main.usage();
            System.exit(1);
        }
        ModuleLoader environmentLoader = configPath != null ? ModuleXmlParser.parseModuleConfigXml(new File(configPath)) : DefaultBootModuleLoaderHolder.INSTANCE;
        if (jar) {
            loader = new JarModuleLoader(environmentLoader, new JarFile(moduleIdentifierOrExeName));
            moduleIdentifier = ((JarModuleLoader)loader).getMyIdentifier();
        } else if (classpathDefined || classDefined) {
            loader = new ClassPathModuleLoader(environmentLoader, moduleIdentifierOrExeName, classpath, deps);
            moduleIdentifier = ModuleIdentifier.CLASSPATH;
        } else {
            loader = environmentLoader;
            moduleIdentifier = ModuleIdentifier.fromString(moduleIdentifierOrExeName);
        }
        Module.initBootModuleLoader(loader);
        if (logManagerModuleIdentifier != null) {
            ModuleClassLoader classLoader = loader.loadModule(logManagerModuleIdentifier).getClassLoaderPrivate();
            InputStream stream = classLoader.getResourceAsStream("META-INF/services/java.util.logging.LogManager");
            if (stream != null) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    String name = null;
                    while ((line = reader.readLine()) != null) {
                        int i = line.indexOf(35);
                        if (i != -1) {
                            line = line.substring(0, i);
                        }
                        if ((line = line.trim()).length() == 0) continue;
                        name = line;
                        break;
                    }
                    if (name != null) {
                        System.setProperty("java.util.logging.manager", name);
                        ClassLoader old = Main.setContextClassLoader(classLoader);
                        try {
                            if (LogManager.getLogManager().getClass() == LogManager.class) {
                                System.err.println("WARNING: Failed to load the specified logmodule " + logManagerModuleIdentifier);
                            }
                            Module.setModuleLogger(new JDKModuleLogger());
                        }
                        finally {
                            void var20_29;
                            Main.setContextClassLoader((ClassLoader)var20_29);
                        }
                    }
                    System.err.println("WARNING: No log manager services defined in specified logmodule " + logManagerModuleIdentifier);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                System.err.println("WARNING: No log manager service descriptor found in specified logmodule " + logManagerModuleIdentifier);
            }
        }
        try {
            module = loader.loadModule(moduleIdentifier);
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            moduleNotFoundException.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            void var3_3;
            ModuleLoader.installMBeanServer();
            module.run((String[])var3_3);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Main.doSetContextClassLoader(classLoader);
                }
            });
        }
        return Main.doSetContextClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader doSetContextClassLoader(ClassLoader classLoader) {
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            return classLoader2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static String getJarName() {
        return "jboss-modules";
    }

    public static String getVersionString() {
        return "1.1.0.Beta2";
    }

    static {
        long l = StartTimeHolder.START_TIME;
        NO_STRINGS = new String[0];
    }
}

