/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.modules.ConcurrentReferenceHashMap;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleAlreadyExistsException;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;

public abstract class ModuleLoader {
    private static final RuntimePermission ML_PERM = new RuntimePermission("canCreateModuleLoader");
    private static final RuntimePermission MODULE_REDEFINE_PERM = new RuntimePermission("canRedefineModule");
    private final ConcurrentMap<ModuleIdentifier, FutureModule> moduleMap = new ConcurrentReferenceHashMap<ModuleIdentifier, FutureModule>(256, 0.5f, 32, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, EnumSet.noneOf(ConcurrentReferenceHashMap.Option.class));
    private final boolean canRedefine;

    ModuleLoader(int dummy) {
        this.canRedefine = true;
    }

    protected ModuleLoader() {
        boolean canRedefine;
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            this.canRedefine = true;
            return;
        }
        manager.checkPermission(ML_PERM);
        try {
            manager.checkPermission(MODULE_REDEFINE_PERM);
            canRedefine = true;
        }
        catch (SecurityException e) {
            canRedefine = false;
        }
        this.canRedefine = canRedefine;
    }

    public abstract String toString();

    public final Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return this.loadModule(identifier, new HashSet<Module>());
    }

    final Module loadModule(ModuleIdentifier identifier, Set<Module> visited) throws ModuleLoadException {
        Module module = this.preloadModule(identifier);
        module.linkExportsIfNeeded(visited);
        return module;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = this.loadModuleLocal(identifier);
        if (module == null) {
            throw new ModuleNotFoundException(identifier.toString());
        }
        return module;
    }

    protected static Module preloadModule(ModuleIdentifier identifier, ModuleLoader moduleLoader) throws ModuleLoadException {
        return moduleLoader.preloadModule(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Module loadModuleLocal(ModuleIdentifier identifier) throws ModuleLoadException {
        FutureModule futureModule = (FutureModule)this.moduleMap.get(identifier);
        if (futureModule != null) {
            return futureModule.getModule();
        }
        FutureModule newFuture = new FutureModule(identifier);
        futureModule = this.moduleMap.putIfAbsent(identifier, newFuture);
        if (futureModule != null) {
            return futureModule.getModule();
        }
        boolean ok = false;
        try {
            ModuleLogger log = Module.log;
            log.trace("Locally loading module %s from %s", (Object)identifier, (Object)this);
            ModuleSpec moduleSpec = this.findModule(identifier);
            if (moduleSpec == null) {
                log.trace("Module %s not found from %s", (Object)identifier, (Object)this);
                Module module = null;
                return module;
            }
            if (!moduleSpec.getModuleIdentifier().equals(identifier)) {
                throw new ModuleLoadException("Module loader found a module with the wrong name");
            }
            Module module = this.defineModule(moduleSpec);
            log.trace("Loaded module %s from %s", (Object)identifier, (Object)this);
            ok = true;
            Module module2 = module;
            return module2;
        }
        finally {
            if (!ok) {
                newFuture.setModule(null);
                this.moduleMap.remove(identifier, newFuture);
            }
        }
    }

    protected final void unloadModuleLocal(Module module) throws SecurityException {
        ModuleLoader moduleLoader = module.getModuleLoader();
        if (moduleLoader != this) {
            throw new SecurityException("Attempted to unload " + module + " from a different module loader");
        }
        ModuleIdentifier id = module.getIdentifier();
        FutureModule futureModule = (FutureModule)this.moduleMap.get(id);
        if (futureModule.module == module) {
            this.moduleMap.remove(id, futureModule);
        }
    }

    protected abstract ModuleSpec findModule(ModuleIdentifier var1) throws ModuleLoadException;

    private Module defineModule(ModuleSpec moduleSpec) throws ModuleLoadException {
        ModuleLogger log = Module.log;
        ModuleIdentifier moduleIdentifier = moduleSpec.getModuleIdentifier();
        FutureModule futureModule = (FutureModule)this.moduleMap.get(moduleIdentifier);
        if (futureModule == null) {
            throw new IllegalStateException("Attempted to define a module from outside loadModuleLocal");
        }
        Module module = new Module(moduleSpec, this, futureModule);
        module.getClassLoaderPrivate().recalculate();
        module.initializeDependencies(Arrays.asList(moduleSpec.getDependencies()));
        try {
            futureModule.setModule(module);
            return module;
        }
        catch (ModuleLoadException e) {
            log.trace((Throwable)e, "Failed to load module %s", (Object)moduleIdentifier);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Throwable)e, "Failed to load module %s", (Object)moduleIdentifier);
            throw e;
        }
        catch (Error e) {
            log.trace((Throwable)e, "Failed to load module %s", (Object)moduleIdentifier);
            throw e;
        }
    }

    protected void refreshResourceLoaders(Module module) {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        module.getClassLoaderPrivate().recalculate();
    }

    protected void setAndRefreshResourceLoaders(Module module, Collection<ResourceLoader> loaders) {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        module.getClassLoaderPrivate().setResourceLoaders(loaders.toArray(new ResourceLoader[loaders.size()]));
    }

    protected void relink(Module module) throws ModuleLoadException {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        module.relink();
    }

    protected void setAndRelinkDependencies(Module module, List<DependencySpec> dependencies) throws ModuleLoadException {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        module.setDependencies(dependencies);
    }

    private static final class FutureModule {
        private static final Object NOT_FOUND = new Object();
        private final ModuleIdentifier identifier;
        private volatile Object module;

        FutureModule(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Module getModule() throws ModuleNotFoundException {
            boolean intr = false;
            try {
                Object object;
                Object module = this.module;
                if (module == null) {
                    object = this;
                    synchronized (object) {
                        while ((module = this.module) == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                    }
                }
                if (module == NOT_FOUND) {
                    throw new ModuleNotFoundException(this.identifier.toString());
                }
                object = (Module)module;
                return object;
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setModule(Module m) throws ModuleAlreadyExistsException {
            FutureModule futureModule = this;
            synchronized (futureModule) {
                this.module = m == null ? NOT_FOUND : m;
                this.notifyAll();
            }
        }
    }
}

