/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import org.jboss.modules.Dependency;
import org.jboss.modules.DependencyVisitor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.PathFilter;

final class ModuleDependency
extends Dependency {
    private final ModuleIdentifier identifier;
    private final boolean optional;
    private volatile Module cachedModule;

    ModuleDependency(PathFilter exportFilter, PathFilter importFilter, ModuleIdentifier identifier, boolean optional) {
        super(exportFilter, importFilter);
        this.identifier = identifier;
        this.optional = optional;
    }

    ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    boolean isOptional() {
        return this.optional;
    }

    @Override
    <T> void accept(DependencyVisitor<T> visitor, T param) throws ModuleLoadException {
        visitor.visit(this, param);
    }

    Module getModule() {
        Module cachedModule = this.cachedModule;
        if (cachedModule == null) {
            try {
                this.cachedModule = Module.getCurrentLoaderPrivate().preloadModule(this.identifier);
                return this.cachedModule;
            }
            catch (ModuleLoadException e) {
                return null;
            }
        }
        return cachedModule;
    }

    Module getModuleRequired() throws ModuleNotFoundException {
        Module module = this.getModule();
        if (module == null && !this.isOptional()) {
            throw new ModuleNotFoundException("Module " + this.identifier + " not found");
        }
        return module;
    }
}

