/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.LogManager;
import org.jboss.modules.InitialModuleLoader;
import org.jboss.modules.JDKModuleLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;

public final class Main {
    private Main() {
    }

    public static String getJarName() {
        return "jboss-modules";
    }

    public static String getVersionString() {
        return "1.0.0.Beta6";
    }

    private static void usage() {
        System.out.println("Usage: java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] <module-spec> [args...]\n");
        System.out.println("where options include:");
        System.out.println("    -help         Display this message");
        System.out.println("    -modulepath <search path of directories>");
        System.out.println("    -mp <search path of directories>");
        System.out.println("                  A list of directories, separated by '" + File.pathSeparator + "', where modules may be located");
        System.out.println("                  If not specified, the value of the \"module.path\" system property is used");
        System.out.println("    -logmodule <module-name>");
        System.out.println("                  The module to use to load the system logmanager");
        System.out.println("    -version      Print version and exit\n");
        System.out.println("and module-spec is a valid module specification string");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Throwable {
        Module module;
        int argsLen = args.length;
        String[] moduleArgs = null;
        String modulePath = null;
        ModuleIdentifier moduleIdentifier = null;
        ModuleIdentifier logManagerModuleIdentifier = null;
        int argsLength = argsLen;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (arg.charAt(0) == '-') {
                    if ("-version".equals(arg)) {
                        System.out.println("Module loader " + Main.getVersionString());
                        return;
                    }
                    if ("-help".equals(arg)) {
                        Main.usage();
                        return;
                    }
                    if ("-modulepath".equals(arg) || "-mp".equals(arg)) {
                        if (modulePath != null) {
                            System.err.println("Module path may only be specified once");
                            System.exit(1);
                        }
                        modulePath = args[++i];
                        System.setProperty("module.path", modulePath);
                        continue;
                    }
                    if ("-logmodule".equals(arg)) {
                        logManagerModuleIdentifier = ModuleIdentifier.fromString(args[++i]);
                        continue;
                    }
                    System.err.printf("Invalid option '%s'\n", arg);
                    Main.usage();
                    System.exit(1);
                    continue;
                }
                moduleIdentifier = ModuleIdentifier.fromString(arg);
                int cnt = argsLen - i - 1;
                moduleArgs = new String[cnt];
                System.arraycopy(args, i + 1, moduleArgs, 0, cnt);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                System.exit(1);
            }
        }
        if (moduleIdentifier == null) {
            System.err.println("No module specified");
            Main.usage();
            System.exit(1);
        }
        ModuleLoader loader = InitialModuleLoader.INSTANCE;
        if (logManagerModuleIdentifier != null) {
            ModuleClassLoader classLoader = ModuleClassLoader.forModule(logManagerModuleIdentifier);
            InputStream stream = classLoader.getResourceAsStream("META-INF/services/java.util.logging.LogManager");
            if (stream != null) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    String name = null;
                    while ((line = reader.readLine()) != null) {
                        int i = line.indexOf(35);
                        if (i != -1) {
                            line = line.substring(0, i);
                        }
                        if ((line = line.trim()).length() == 0) continue;
                        name = line;
                        break;
                    }
                    if (name != null) {
                        System.setProperty("java.util.logging.manager", name);
                        ClassLoader old = Main.setContextClassLoader(classLoader);
                        try {
                            if (LogManager.getLogManager().getClass() == LogManager.class) {
                                System.err.println("WARNING: Failed to load the specified logmodule " + logManagerModuleIdentifier);
                            }
                            Module.setModuleLogger(new JDKModuleLogger());
                        }
                        finally {
                            Main.setContextClassLoader(old);
                        }
                    }
                    System.err.println("WARNING: No log manager services defined in specified logmodule " + logManagerModuleIdentifier);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                System.err.println("WARNING: No log manager service descriptor found in specified logmodule " + logManagerModuleIdentifier);
            }
        }
        try {
            module = loader.loadModule(moduleIdentifier);
        }
        catch (ModuleNotFoundException e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            module.run(moduleArgs);
        }
        catch (InvocationTargetException e) {
            void var8_13;
            throw var8_13.getCause();
        }
    }

    private static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Main.doSetContextClassLoader(classLoader);
                }
            });
        }
        return Main.doSetContextClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader doSetContextClassLoader(ClassLoader classLoader) {
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            return classLoader2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

