/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;

public final class ModuleIdentifier
implements Serializable {
    private static final long serialVersionUID = 118533026624827995L;
    private static Pattern MODULE_NAME_PATTERN = Pattern.compile("[a-zA-Z_][-a-zA-Z0-9_]*(?:\\.[a-zA-Z0-9_][-a-zA-Z0-9_]*)*");
    private static Pattern SLOT_PATTERN = Pattern.compile("[-a-zA-Z0-9_+*.]+");
    private static String DEFAULT_SLOT = "main";
    private final String name;
    private final String slot;
    private int hash = 0;
    public static final ModuleIdentifier SYSTEM = new ModuleIdentifier("system", DEFAULT_SLOT);

    private ModuleIdentifier(String name, String slot) {
        this.name = name;
        this.slot = slot;
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public boolean equals(Object o) {
        return o instanceof ModuleIdentifier && this.equals((ModuleIdentifier)o);
    }

    public boolean equals(ModuleIdentifier o) {
        return this == o || o != null && this.name.equals(o.name) && this.slot.equals(o.slot);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h = 17;
            h = 37 * h + this.name.hashCode();
            this.hash = h = 37 * h + this.slot.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "module:" + this.toSpecString();
    }

    public static ModuleIdentifier fromURL(URL url) throws MalformedURLException {
        if (url.getAuthority() != null) {
            throw new MalformedURLException("Modules cannot have an authority part");
        }
        String moduleRootSpec = url.getFile();
        int si = moduleRootSpec.indexOf(47);
        String moduleName = si == -1 ? moduleRootSpec : moduleRootSpec.substring(0, si);
        if (moduleName.length() == 0) {
            throw new MalformedURLException("Empty module URL");
        }
        return ModuleIdentifier.fromString(moduleName);
    }

    public static ModuleIdentifier fromURI(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals("module")) {
            throw new URISyntaxException(uri.toString(), "Module URIs must start with \"module:\"");
        }
        if (uri.getAuthority() != null) {
            throw new URISyntaxException(uri.toString(), "Modules cannot have an authority part");
        }
        String moduleFullSpec = uri.getSchemeSpecificPart();
        int sli = moduleFullSpec.indexOf(47);
        int qi = moduleFullSpec.indexOf(63);
        int si = qi == -1 ? (sli == -1 ? -1 : sli) : (sli == -1 ? qi : Math.min(sli, qi));
        String moduleName = si == -1 ? moduleFullSpec : moduleFullSpec.substring(0, si);
        if (moduleName.length() == 0) {
            throw new URISyntaxException(uri.toString(), "Empty module URI");
        }
        return ModuleIdentifier.fromString(moduleName);
    }

    public static ModuleIdentifier fromString(String moduleSpec) throws IllegalArgumentException {
        String slot;
        String name;
        if (moduleSpec == null) {
            throw new IllegalArgumentException("Module specification is null");
        }
        if (moduleSpec.length() == 0) {
            throw new IllegalArgumentException("Empty module specificiation");
        }
        int c1 = moduleSpec.lastIndexOf(58);
        if (c1 != -1) {
            name = moduleSpec.substring(0, c1);
            slot = moduleSpec.substring(c1 + 1);
            if (!SLOT_PATTERN.matcher(slot).matches()) {
                throw new IllegalArgumentException("Slot has invalid characters or is empty");
            }
        } else {
            name = moduleSpec;
            slot = DEFAULT_SLOT;
        }
        if (!MODULE_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Module name contains invalid characters, or empty segments");
        }
        return new ModuleIdentifier(name, slot);
    }

    private String toSpecString() {
        return this.name + ":" + this.slot;
    }

    public static ModuleIdentifier create(String name, String slot) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        if (slot == null) {
            slot = DEFAULT_SLOT;
        }
        return new ModuleIdentifier(name, slot);
    }

    public static ModuleIdentifier create(String name) {
        return ModuleIdentifier.create(name, null);
    }

    public URL toURL() throws MalformedURLException {
        return new URL("module", null, -1, this.toSpecString());
    }

    public URL toURL(String resourceRoot) throws MalformedURLException {
        if (resourceRoot == null) {
            return this.toURL();
        }
        return new URL("module", null, -1, this.toSpecString() + "/" + resourceRoot);
    }

    public URL toURL(String resourceRoot, String resourceName) throws MalformedURLException {
        if (resourceName == null) {
            return this.toURL(resourceRoot);
        }
        if (resourceRoot == null) {
            return new URL("module", null, -1, this.toSpecString() + "?/" + resourceName);
        }
        return new URL("module", null, -1, this.toSpecString() + "/" + resourceRoot + "?/" + resourceName);
    }
}

