/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class ModuleIdentifier
implements Serializable {
    private static final long serialVersionUID = 118533026624827995L;
    private final String group;
    private final String artifact;
    private final String version;
    public static final ModuleIdentifier SYSTEM = new ModuleIdentifier("system", "system", null);

    public ModuleIdentifier(String group, String artifact, String version) {
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("artifact is null");
        }
        this.group = group;
        this.artifact = artifact;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        return o instanceof ModuleIdentifier && this.equals((ModuleIdentifier)o);
    }

    public boolean equals(ModuleIdentifier o) {
        return this == o || o != null && this.group.equals(o.group) && this.artifact.equals(o.artifact) && (this.version == null ? o.version == null : this.version.equals(o.version));
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.artifact.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.version == null) {
            return String.format("module:%s:%s", this.group, this.artifact);
        }
        return String.format("module:%s:%s:%s", this.group, this.artifact, this.version);
    }

    public static ModuleIdentifier fromURL(URL url) throws MalformedURLException {
        if (url.getAuthority() != null) {
            throw new MalformedURLException("Modules cannot have an authority part");
        }
        String moduleRootSpec = url.getFile();
        int si = moduleRootSpec.indexOf(47);
        String moduleSpec = si == -1 ? moduleRootSpec : moduleRootSpec.substring(0, si);
        if (moduleSpec.length() == 0) {
            throw new MalformedURLException("Empty module URL");
        }
        int c1 = moduleSpec.indexOf(58);
        if (c1 == -1) {
            throw new MalformedURLException("Module URL requires a group ID");
        }
        int c2 = moduleSpec.indexOf(58, c1 + 1);
        if (c2 == -1) {
            return new ModuleIdentifier(moduleSpec.substring(0, c1), moduleSpec.substring(c1 + 1), null);
        }
        int c3 = moduleSpec.indexOf(58, c2 + 1);
        return new ModuleIdentifier(moduleSpec.substring(0, c1), moduleSpec.substring(c1 + 1, c2), c3 == -1 ? moduleSpec.substring(c2 + 1) : moduleSpec.substring(c2 + 1, c3));
    }

    public static ModuleIdentifier fromURI(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals("module")) {
            throw new URISyntaxException(uri.toString(), "Module URIs must start with \"module:\"");
        }
        if (uri.getAuthority() != null) {
            throw new URISyntaxException(uri.toString(), "Modules cannot have an authority part");
        }
        String moduleFullSpec = uri.getSchemeSpecificPart();
        int sli = moduleFullSpec.indexOf(47);
        int qi = moduleFullSpec.indexOf(63);
        int si = qi == -1 ? (sli == -1 ? -1 : sli) : (sli == -1 ? qi : Math.min(sli, qi));
        String moduleSpec = si == -1 ? moduleFullSpec : moduleFullSpec.substring(0, si);
        if (moduleSpec.length() == 0) {
            throw new URISyntaxException(uri.toString(), "Empty module URI");
        }
        int c1 = moduleSpec.indexOf(58);
        if (c1 == -1) {
            throw new URISyntaxException(uri.toString(), "Module URI requires a group ID");
        }
        int c2 = moduleSpec.indexOf(58, c1 + 1);
        if (c2 == -1) {
            return new ModuleIdentifier(moduleSpec.substring(0, c1), moduleSpec.substring(c1 + 1), null);
        }
        int c3 = moduleSpec.indexOf(58, c2 + 1);
        return new ModuleIdentifier(moduleSpec.substring(0, c1), moduleSpec.substring(c1 + 1, c2), c3 == -1 ? moduleSpec.substring(c2 + 1) : moduleSpec.substring(c2 + 1, c3));
    }

    public static ModuleIdentifier fromString(String moduleSpec) throws IllegalArgumentException {
        if (moduleSpec.length() == 0) {
            throw new IllegalArgumentException("Empty module specification");
        }
        int c1 = moduleSpec.indexOf(58);
        if (c1 == -1) {
            throw new IllegalArgumentException("Module specification requires a group ID");
        }
        int c2 = moduleSpec.indexOf(58, c1 + 1);
        if (c2 == -1) {
            return new ModuleIdentifier(moduleSpec.substring(0, c1), moduleSpec.substring(c1 + 1), null);
        }
        int c3 = moduleSpec.indexOf(58, c2 + 1);
        return new ModuleIdentifier(moduleSpec.substring(0, c1), moduleSpec.substring(c1 + 1, c2), c3 == -1 ? moduleSpec.substring(c2 + 1) : moduleSpec.substring(c2 + 1, c3));
    }

    private String toSpecString() {
        if (this.version == null) {
            return this.group + ":" + this.artifact;
        }
        return this.group + ":" + this.artifact + ":" + this.version;
    }

    public URL toURL() throws MalformedURLException {
        return new URL("module", null, -1, this.toSpecString());
    }

    public URL toURL(String resourceRoot) throws MalformedURLException {
        if (resourceRoot == null) {
            return this.toURL();
        }
        return new URL("module", null, -1, this.toSpecString() + "/" + resourceRoot);
    }

    public URL toURL(String resourceRoot, String resourceName) throws MalformedURLException {
        if (resourceName == null) {
            return this.toURL(resourceRoot);
        }
        if (resourceRoot == null) {
            return new URL("module", null, -1, this.toSpecString() + "?/" + resourceName);
        }
        return new URL("module", null, -1, this.toSpecString() + "/" + resourceRoot + "?/" + resourceName);
    }
}

