/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencyVisitor;
import org.jboss.modules.InitialModuleLoader;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleLoaderSelector;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.NoopModuleLogger;
import org.jboss.modules.PathFilter;
import org.jboss.modules.PathFilters;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.SystemLocalLoader;

public final class Module {
    static volatile ModuleLogger log;
    private static volatile ModuleLoaderSelector moduleLoaderSelector;
    private final ModuleIdentifier identifier;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final Dependency[] dependencies;
    private final Object myKey;
    private volatile Paths paths = Paths.NONE;
    private volatile LoadState loadState = LoadState.LOADED;
    private static final AtomicReferenceFieldUpdater<Module, LoadState> loadStateUpdater;
    private static final RuntimePermission GET_CLASS_LOADER;

    Module(ModuleIdentifier identifier, String mainClassName, ModuleLoader moduleLoader, AssertionSetting assertionSetting, Collection<ResourceLoader> resourceLoaders, Dependency[] dependencies, Object myKey) {
        this.moduleLoader = moduleLoader;
        this.identifier = identifier;
        this.mainClassName = mainClassName;
        this.myKey = myKey;
        this.moduleClassLoader = new ModuleClassLoader(this, assertionSetting, resourceLoaders);
        this.dependencies = dependencies;
    }

    Module(ModuleSpec spec, ModuleLoader moduleLoader, Object myKey) {
        this.moduleLoader = moduleLoader;
        this.myKey = myKey;
        this.identifier = spec.getModuleIdentifier();
        this.mainClassName = spec.getMainClass();
        this.moduleClassLoader = new ModuleClassLoader(this, spec.getAssertionSetting(), Arrays.asList(spec.getResourceLoaders()));
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (ModuleSpec.SpecifiedDependency specifiedDependency : spec.getDependencies()) {
            dependencies.add(specifiedDependency.getDependency(this));
        }
        this.dependencies = dependencies.toArray(new Dependency[dependencies.size()]);
    }

    Dependency[] getDependencies() {
        return this.dependencies;
    }

    void resolveInitial(Set<Module> visited) throws ModuleLoadException {
        if (this.loadState.compareTo(LoadState.RESOLVED) >= 0) {
            return;
        }
        this.resolve(visited);
    }

    void resolve(final Set<Module> visited) throws ModuleLoadException {
        if (!visited.add(this)) {
            return;
        }
        final ArrayDeque filterSeries = new ArrayDeque();
        final HashMap allPaths = new HashMap();
        final HashMap exportedPaths = new HashMap();
        final DependencyVisitor<PathFilter> distantVisitor = new DependencyVisitor<PathFilter>(){

            @Override
            public void visit(LocalDependency item, PathFilter firstExportFilter) throws ModuleLoadException {
                Set<String> paths = item.getPaths();
                PathFilter importFilter = item.getImportFilter();
                PathFilter exportFilter = item.getExportFilter();
                LocalLoader loader = item.getLocalLoader();
                block0: for (String path : paths) {
                    if (!importFilter.accept(path) || !exportFilter.accept(path)) continue;
                    for (PathFilter filter : filterSeries) {
                        if (filter.accept(path)) continue;
                        continue block0;
                    }
                    Module.addToMapList(allPaths, path, loader);
                    if (!firstExportFilter.accept(path)) continue;
                    Module.addToMapList(exportedPaths, path, loader);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(ModuleDependency item, PathFilter firstExportFilter) throws ModuleLoadException {
                Module module = item.getModuleRequired();
                if (module == null) {
                    return;
                }
                if (!visited.add(module)) {
                    return;
                }
                PathFilter exportFilter = item.getExportFilter();
                if (exportFilter == PathFilters.rejectAll()) {
                    return;
                }
                filterSeries.addLast(item.getImportFilter());
                filterSeries.addLast(exportFilter);
                try {
                    for (Dependency dep : module.dependencies) {
                        dep.accept(this, firstExportFilter);
                    }
                }
                finally {
                    filterSeries.removeLast();
                    filterSeries.removeLast();
                }
            }
        };
        DependencyVisitor<Void> nearVisitor = new DependencyVisitor<Void>(){

            @Override
            public void visit(LocalDependency item, Void param) throws ModuleLoadException {
                Set<String> paths = item.getPaths();
                PathFilter importFilter = item.getImportFilter();
                PathFilter exportFilter = item.getExportFilter();
                LocalLoader loader = item.getLocalLoader();
                for (String path : paths) {
                    if (!importFilter.accept(path)) continue;
                    Module.addToMapList(allPaths, path, loader);
                    if (!exportFilter.accept(path)) continue;
                    Module.addToMapList(exportedPaths, path, loader);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(ModuleDependency item, Void param) throws ModuleLoadException {
                Module module = item.getModuleRequired();
                if (module == null) {
                    return;
                }
                filterSeries.addLast(item.getImportFilter());
                PathFilter exportFilter = item.getExportFilter();
                try {
                    for (Dependency dep : module.dependencies) {
                        dep.accept(distantVisitor, exportFilter);
                    }
                }
                finally {
                    filterSeries.removeLast();
                }
            }
        };
        for (Dependency dependency : this.dependencies) {
            dependency.accept(nearVisitor, null);
        }
        this.paths = new Paths(allPaths, exportedPaths);
        loadStateUpdater.compareAndSet(this, LoadState.LOADED, LoadState.RESOLVED);
    }

    void linkInitial(HashSet<Module> visited) throws ModuleLoadException {
        if (this.loadState.compareTo(LoadState.LINKED) >= 0) {
            return;
        }
        this.link(visited);
    }

    void link(final Set<Module> visited) throws ModuleLoadException {
        this.resolveInitial(new HashSet<Module>());
        Dependency[] dependencies = (Dependency[])this.dependencies.clone();
        Collections.shuffle(Arrays.asList(dependencies));
        if (!visited.add(this)) {
            return;
        }
        for (Dependency dependency : dependencies) {
            dependency.accept(new DependencyVisitor<Void>(){

                @Override
                public void visit(LocalDependency item, Void param) throws ModuleLoadException {
                }

                @Override
                public void visit(ModuleDependency item, Void param) throws ModuleLoadException {
                    Module module = item.getModuleRequired();
                    if (module != null) {
                        module.link(visited);
                    }
                }
            }, null);
        }
        for (Module module : visited) {
            module.loadState = LoadState.LINKED;
        }
    }

    ModuleClassLoader getClassLoaderPrivate() {
        return this.moduleClassLoader;
    }

    private static <K, V> void addToMapList(Map<K, List<V>> map, K key, V item) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(item);
    }

    public static Module getSystemModule() {
        return SystemModuleHolder.SYSTEM;
    }

    public final Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath, true);
    }

    final Resource getResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath, false);
    }

    public final void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        try {
            if (this.mainClassName == null) {
                throw new NoSuchMethodException("No main class defined for " + this);
            }
            Class<?> mainClass = this.moduleClassLoader.loadClass(this.mainClassName);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new NoSuchMethodException("Main method is not static for " + this);
            }
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public static <S> ServiceLoader<S> loadService(ModuleIdentifier moduleIdentifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getModule(moduleIdentifier).loadService(serviceType);
    }

    public static <S> ServiceLoader<S> loadService(String moduleIdentifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.loadService(ModuleIdentifier.fromString(moduleIdentifier), serviceType);
    }

    public ModuleClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASS_LOADER);
        }
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.paths.exportedPaths.keySet());
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return cl instanceof ModuleClassLoader ? ((ModuleClassLoader)cl).getModule() : (cl == null || cl == ClassLoader.getSystemClassLoader() ? Module.getSystemModule() : null);
    }

    public static Class<?> loadClass(ModuleIdentifier moduleIdentifier, String className, boolean initialize) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, initialize, ModuleClassLoader.forModule(moduleIdentifier));
    }

    public static Class<?> loadClass(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, ModuleClassLoader.forModule(moduleIdentifier));
    }

    public static Class<?> loadClass(String moduleIdentifierString, String className, boolean initialize) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, initialize, ModuleClassLoader.forModule(ModuleIdentifier.fromString(moduleIdentifierString)));
    }

    public static Class<?> loadClass(String moduleIdentifierString, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, ModuleClassLoader.forModule(ModuleIdentifier.fromString(moduleIdentifierString)));
    }

    public static Module getModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return moduleLoaderSelector.getCurrentLoader().loadModule(identifier);
    }

    public static ModuleLoader getCurrentLoader() {
        return Module.getCurrentLoaderPrivate();
    }

    static ModuleLoader getCurrentLoaderPrivate() {
        return moduleLoaderSelector.getCurrentLoader();
    }

    Class<?> loadModuleClass(String className, boolean exportsOnly, boolean resolve) {
        String path;
        if (className.startsWith("java.")) {
            try {
                return this.moduleClassLoader.loadClass(className, resolve);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        Map paths = exportsOnly ? this.paths.exportedPaths : this.paths.allPaths;
        List loaders = (List)paths.get(path = Module.pathOfClass(className));
        if (loaders == null) {
            return null;
        }
        Class<?> clazz = null;
        for (LocalLoader loader : loaders) {
            clazz = loader.loadClassLocal(className, resolve);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    URL getResource(String name, boolean exportsOnly) {
        if (name.startsWith("java/")) {
            return this.moduleClassLoader.getResource(name);
        }
        log.trace("Attempting to find resource %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map paths = exportsOnly ? this.paths.exportedPaths : this.paths.allPaths;
        List loaders = (List)paths.get(path);
        if (loaders == null) {
            return null;
        }
        for (LocalLoader loader : loaders) {
            List<Resource> resourceList = loader.loadResourceLocal(name);
            Iterator<Resource> i$ = resourceList.iterator();
            if (!i$.hasNext()) continue;
            Resource resource = i$.next();
            return resource.getURL();
        }
        return null;
    }

    Enumeration<URL> getResources(String name, boolean exportsOnly) {
        if (name.startsWith("java/")) {
            try {
                return this.moduleClassLoader.getResources(name);
            }
            catch (IOException e) {
                return ConcurrentClassLoader.EMPTY_ENUMERATION;
            }
        }
        log.trace("Attempting to find all resources %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map paths = exportsOnly ? this.paths.exportedPaths : this.paths.allPaths;
        List loaders = (List)paths.get(path);
        if (loaders == null) {
            return ConcurrentClassLoader.EMPTY_ENUMERATION;
        }
        ArrayList<URL> list = new ArrayList<URL>();
        for (LocalLoader loader : loaders) {
            List<Resource> resourceList = loader.loadResourceLocal(name);
            for (Resource resource : resourceList) {
                list.add(resource.getURL());
            }
        }
        return Collections.enumeration(list);
    }

    public final URL getExportedResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration<URL> getExportedResources(String name) {
        return this.getResources(name, true);
    }

    static String pathOfClass(String className) {
        String resourceName = className.replace('.', '/');
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String pathOf(String resourceName) {
        if (resourceName.indexOf(47) == 0) {
            return Module.pathOf(resourceName.substring(1));
        }
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String fileNameOfClass(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String toString() {
        return "Module \"" + this.identifier + "\"";
    }

    public static void setModuleLoaderSelector(ModuleLoaderSelector moduleLoaderSelector) {
        if (moduleLoaderSelector == null) {
            throw new IllegalArgumentException("moduleLoaderSelector is null");
        }
        Module.moduleLoaderSelector = moduleLoaderSelector;
    }

    public static void setModuleLogger(ModuleLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        log = logger;
        logger.greeting();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(new ModularURLStreamHandlerFactory());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        log = NoopModuleLogger.getInstance();
        moduleLoaderSelector = ModuleLoaderSelector.DEFAULT;
        loadStateUpdater = AtomicReferenceFieldUpdater.newUpdater(Module.class, LoadState.class, "loadState");
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
    }

    private static final class Paths {
        private final Map<String, List<LocalLoader>> allPaths;
        private final Map<String, List<LocalLoader>> exportedPaths;
        static final Paths NONE = new Paths(Collections.<String, List<LocalLoader>>emptyMap(), Collections.<String, List<LocalLoader>>emptyMap());

        private Paths(Map<String, List<LocalLoader>> allPaths, Map<String, List<LocalLoader>> exportedPaths) {
            this.allPaths = allPaths;
            this.exportedPaths = exportedPaths;
        }

        Map<String, List<LocalLoader>> getAllPaths() {
            return this.allPaths;
        }

        Map<String, List<LocalLoader>> getExportedPaths() {
            return this.exportedPaths;
        }
    }

    private static final class SystemModuleHolder {
        private static final Module SYSTEM;

        private SystemModuleHolder() {
        }

        static {
            SystemLocalLoader systemLocalLoader = SystemLocalLoader.getInstance();
            LocalDependency localDependency = new LocalDependency(PathFilters.acceptAll(), PathFilters.acceptAll(), systemLocalLoader, systemLocalLoader.getPathSet());
            SYSTEM = new Module(ModuleIdentifier.SYSTEM, null, InitialModuleLoader.INSTANCE, AssertionSetting.INHERIT, Collections.<ResourceLoader>emptySet(), new Dependency[]{localDependency}, null);
        }
    }

    static final class DependencyImport {
        private final Module module;
        private final boolean export;

        DependencyImport(Module module, boolean export) {
            this.module = module;
            this.export = export;
        }

        Module getModule() {
            return this.module;
        }

        ModuleClassLoader getClassLoader() {
            return this.module.getClassLoader();
        }

        boolean isExport() {
            return this.export;
        }
    }

    static enum LoadState {
        LOADED,
        RESOLVED,
        LINKED;

    }
}

