/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Collection;
import java.util.Set;
import org.jboss.modules.AggregatePathFilter;
import org.jboss.modules.BooleanPathFilter;
import org.jboss.modules.ChildPathFilter;
import org.jboss.modules.EqualsPathFilter;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.GlobPathFilter;
import org.jboss.modules.InvertingPathFilter;
import org.jboss.modules.MultiplePathFilterBuilder;
import org.jboss.modules.PathFilter;
import org.jboss.modules.SetPathFilter;

public final class PathFilters {
    private static final PathFilter defaultImportFilter;
    private static final PathFilter defaultImportFilterWithServices;
    private static final PathFilter metaInfFilter;
    private static final PathFilter metaInfSubdirectoriesFilter;
    private static final PathFilter metaInfServicesFilter;

    private PathFilters() {
    }

    public static PathFilter all(PathFilter ... filters) {
        return new AggregatePathFilter(false, filters);
    }

    public static PathFilter all(Collection<PathFilter> filters) {
        return PathFilters.all(filters.toArray(new PathFilter[filters.size()]));
    }

    public static PathFilter any(PathFilter ... filters) {
        return new AggregatePathFilter(true, filters);
    }

    public static PathFilter any(Collection<PathFilter> filters) {
        return PathFilters.any(filters.toArray(new PathFilter[filters.size()]));
    }

    public static PathFilter not(PathFilter filter) {
        return new InvertingPathFilter(filter);
    }

    public static PathFilter match(String glob) {
        return new GlobPathFilter(glob);
    }

    public static PathFilter is(String path) {
        return new EqualsPathFilter(path);
    }

    public static PathFilter isChildOf(String path) {
        return new ChildPathFilter(path);
    }

    public static MultiplePathFilterBuilder multiplePathFilterBuilder(boolean defaultValue) {
        return new MultiplePathFilterBuilder(defaultValue);
    }

    public static PathFilter acceptAll() {
        return BooleanPathFilter.TRUE;
    }

    public static PathFilter rejectAll() {
        return BooleanPathFilter.FALSE;
    }

    public static PathFilter in(Set<String> paths) {
        return new SetPathFilter(new FastCopyHashSet<String>(paths));
    }

    public static PathFilter getDefaultImportFilter() {
        return defaultImportFilter;
    }

    public static PathFilter getDefaultImportFilterWithServices() {
        return defaultImportFilterWithServices;
    }

    public static PathFilter getMetaInfFilter() {
        return metaInfFilter;
    }

    public static PathFilter getMetaInfSubdirectoriesFilter() {
        return metaInfSubdirectoriesFilter;
    }

    public static PathFilter getMetaInfServicesFilter() {
        return metaInfServicesFilter;
    }

    static {
        PathFilter metaInfChildren = PathFilters.isChildOf("META-INF");
        PathFilter metaInf = PathFilters.is("META-INF");
        PathFilter metaInfServices = PathFilters.is("META-INF/services");
        metaInfFilter = metaInf;
        metaInfSubdirectoriesFilter = metaInfChildren;
        metaInfServicesFilter = metaInfServices;
        MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder(true);
        builder.addFilter(metaInfChildren, false);
        builder.addFilter(metaInf, false);
        defaultImportFilter = builder.create();
        MultiplePathFilterBuilder builder2 = PathFilters.multiplePathFilterBuilder(true);
        builder2.addFilter(metaInfServices, true);
        builder2.addFilter(metaInfChildren, false);
        builder2.addFilter(metaInf, false);
        defaultImportFilterWithServices = builder2.create();
    }
}

