/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.URLResource;

final class SystemModuleClassLoader
extends ModuleClassLoader {
    SystemModuleClassLoader(Module module, Set<Module.Flag> flags, AssertionSetting setting) {
        super(module, flags, setting, null);
    }

    Set<String> getExportedPaths() {
        HashSet<String> packageSet = new HashSet<String>(128);
        HashSet<String> jarSet = new HashSet<String>(128);
        this.processClassPathItem(System.getProperty("sun.boot.class.path"), jarSet, packageSet);
        this.processClassPathItem(System.getProperty("java.class.path"), jarSet, packageSet);
        return packageSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassPathItem(String classPath, Set<String> jarSet, Set<String> packageSet) {
        int e;
        if (classPath == null) {
            return;
        }
        int s = 0;
        do {
            String item;
            String string = item = (e = classPath.indexOf(File.pathSeparatorChar, s)) == -1 ? classPath.substring(s) : classPath.substring(s, e);
            if (!jarSet.contains(item)) {
                File file = new File(item);
                if (file.isDirectory()) {
                    SystemModuleClassLoader.processDirectory0(packageSet, file);
                } else {
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        try {
                            Enumeration<? extends ZipEntry> entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                String dirName;
                                ZipEntry entry = entries.nextElement();
                                String name = entry.getName();
                                int lastSlash = name.lastIndexOf(47);
                                if (lastSlash == -1 || (dirName = name.substring(0, lastSlash)).equals("META-INF")) continue;
                                packageSet.add(dirName);
                            }
                        }
                        finally {
                            zipFile.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            s = e + 1;
        } while (e != -1);
    }

    private static void processDirectory0(Set<String> packageSet, File file) {
        for (File entry : file.listFiles()) {
            if (entry.getName().equals("META-INF")) continue;
            if (entry.isDirectory()) {
                SystemModuleClassLoader.processDirectory1(packageSet, entry, file.getPath());
                continue;
            }
            String parent = entry.getParent();
            if (parent == null) continue;
            packageSet.add(parent);
        }
    }

    private static void processDirectory1(Set<String> packageSet, File file, String pathBase) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                SystemModuleClassLoader.processDirectory1(packageSet, entry, pathBase);
                continue;
            }
            String packagePath = entry.getParent();
            if (packagePath == null) continue;
            if ((packagePath = packagePath.substring(pathBase.length()).replace('\\', '/')).startsWith("/")) {
                packagePath = packagePath.substring(1);
            }
            packageSet.add(packagePath);
        }
    }

    @Override
    protected Class<?> findClass(String className, boolean exportsOnly) throws ClassNotFoundException {
        return this.findSystemClass(className);
    }

    @Override
    protected String findLibrary(String libname) {
        return null;
    }

    @Override
    public URL findResource(String name, boolean exportsOnly) {
        return SystemModuleClassLoader.getSystemResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return SystemModuleClassLoader.getSystemResources(name);
    }

    @Override
    public InputStream findResourceAsStream(String name, boolean exportsOnly) {
        return SystemModuleClassLoader.getSystemResourceAsStream(name);
    }

    @Override
    Resource getRawResource(String root, String name) {
        if ("".equals(root)) {
            return new URLResource(this.getResource(name));
        }
        return null;
    }
}

