/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ExportFilterable;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;

final class ModuleXmlParser {
    private static final String NAMESPACE = "urn:jboss:module:1.0";

    private ModuleXmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleSpec parse(ModuleIdentifier moduleIdentifier, File root, File moduleInfoFile) throws ModuleLoadException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(moduleInfoFile);
        }
        catch (FileNotFoundException e) {
            throw new ModuleLoadException("No module.xml file found at " + moduleInfoFile);
        }
        try {
            ModuleSpec moduleSpec = ModuleXmlParser.parse(root, fis, moduleInfoFile, moduleIdentifier);
            return moduleSpec;
        }
        finally {
            ModuleXmlParser.safeClose(fis);
        }
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleSpec parse(File root, InputStream source, File moduleInfoFile, ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            moduleSpec = ModuleXmlParser.parseDocument(root, streamReader, ModuleSpec.build(moduleIdentifier));
        }
        catch (Throwable throwable) {
            try {
                ModuleXmlParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new ModuleLoadException("Error loading module from " + moduleInfoFile.getPath(), e);
            }
        }
        ModuleXmlParser.safeClose(streamReader);
        return moduleSpec;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity decl";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation decl";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException unknownFlag(String flag, Location location) {
        return new XMLStreamException("Invalid flag \"" + flag + "\" specified", location);
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    private static XMLStreamException invalidModuleName(Location location, ModuleIdentifier expected) {
        return new XMLStreamException("Invalid/mismatched module name (expected " + expected + ")", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static ModuleSpec parseDocument(File root, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 7: {
                    ModuleXmlParser.parseRootElement(root, reader, specBuilder);
                    return specBuilder.create();
                }
                case 1: {
                    if (Element.of(reader.getName()) != Element.MODULE) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    ModuleXmlParser.parseModuleContents(root, reader, specBuilder);
                    ModuleXmlParser.parseEndDocument(reader);
                    return specBuilder.create();
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseRootElement(File root, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (Element.of(reader.getName()) != Element.MODULE) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    ModuleXmlParser.parseModuleContents(root, reader, specBuilder);
                    ModuleXmlParser.parseEndDocument(reader);
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleContents(File root, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String flags = null;
        String name = null;
        String group = null;
        String version = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.GROUP);
        block17: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case FLAGS: {
                    flags = reader.getAttributeValue(i);
                    continue block17;
                }
                case GROUP: {
                    group = reader.getAttributeValue(i);
                    continue block17;
                }
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block17;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block17;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (!specBuilder.getIdentifier().equals(new ModuleIdentifier(group, name, version))) {
            throw ModuleXmlParser.invalidModuleName(reader.getLocation(), specBuilder.getIdentifier());
        }
        if (flags != null) {
            for (String flag : flags.split("\\s+")) {
                try {
                    Module.Flag flagVal = Module.Flag.valueOf(flag.toUpperCase().replace('-', '_'));
                    specBuilder.addModuleFlag(flagVal);
                }
                catch (IllegalArgumentException e) {
                    throw ModuleXmlParser.unknownFlag(flag, reader.getLocation());
                }
            }
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block19: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case DEPENDENCIES: {
                            ModuleXmlParser.parseDependencies(reader, specBuilder);
                            continue block19;
                        }
                        case MAIN_CLASS: {
                            ModuleXmlParser.parseMainClass(reader, specBuilder);
                            continue block19;
                        }
                        case RESOURCES: {
                            ModuleXmlParser.parseResources(root, reader, specBuilder);
                            continue block19;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            ModuleXmlParser.parseModuleDependency(reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleDependency(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String group = null;
        String name = null;
        String version = null;
        boolean export = false;
        boolean optional = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.GROUP);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP: {
                    group = reader.getAttributeValue(i);
                    continue block7;
                }
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block7;
                }
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        DependencySpec.Builder dependencySpecBuilder = specBuilder.addDependency(new ModuleIdentifier(group, name, version)).setExport(export).setOptional(optional);
        ModuleXmlParser.parseForExports(reader, dependencySpecBuilder);
    }

    private static void parseMainClass(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.setMainClass(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseResources(File root, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            ModuleXmlParser.parseResourceRoot(root, reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(File root, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        AbstractResourceLoader resourceLoader;
        File file;
        ModuleIdentifier identifier = specBuilder.getIdentifier();
        String name = null;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (name == null) {
            name = path;
        }
        if ((file = new File(root, path)).isDirectory()) {
            resourceLoader = new FileResourceLoader(identifier, file, name);
        } else {
            try {
                resourceLoader = new JarFileResourceLoader(identifier, new JarFile(file), name);
            }
            catch (IOException e) {
                throw new XMLStreamException("Invalid JAR file specified", reader.getLocation(), e);
            }
        }
        specBuilder.addRoot(name, resourceLoader);
        ModuleXmlParser.parseForExports(reader, resourceLoader);
    }

    private static void parseForExports(XMLStreamReader reader, ExportFilterable filterable) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case EXPORTS: {
                            ModuleXmlParser.parseExports(reader, filterable);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseExports(XMLStreamReader reader, ExportFilterable filterable) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            ModuleXmlParser.parseInclude(reader, filterable);
                            continue block8;
                        }
                        case EXCLUDE: {
                            ModuleXmlParser.parseExclude(reader, filterable);
                            continue block8;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseInclude(XMLStreamReader reader, ExportFilterable filterable) throws XMLStreamException {
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        filterable.addExportInclude(path);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseExclude(XMLStreamReader reader, ExportFilterable filterable) throws XMLStreamException {
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        filterable.addExportExclude(path);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    static enum Attribute {
        GROUP,
        NAME,
        VERSION,
        EXPORT,
        PATH,
        FLAGS,
        OPTIONAL,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("group"), GROUP);
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("version"), VERSION);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("flags"), FLAGS);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributes = attributesMap;
        }
    }

    static enum Element {
        MODULE,
        DEPENDENCIES,
        EXPORTS,
        INCLUDE,
        EXCLUDE,
        RESOURCES,
        MAIN_CLASS,
        RESOURCE_ROOT,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            Element element = elements.get(qName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "module"), MODULE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "dependencies"), DEPENDENCIES);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "resources"), RESOURCES);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "main-class"), MAIN_CLASS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "resource-root"), RESOURCE_ROOT);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exports"), EXPORTS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "include"), INCLUDE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exclude"), EXCLUDE);
            elements = elementsMap;
        }
    }
}

