/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.Dependency;
import org.jboss.modules.InitialModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleContentLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;

public class ModuleClassLoader
extends ConcurrentClassLoader {
    private static final boolean debugDefines;
    private final Module module;
    private final Set<Module.Flag> flags;
    private final ModuleContentLoader contentLoader;

    ModuleClassLoader(Module module, Set<Module.Flag> flags, AssertionSetting setting, ModuleContentLoader contentLoader) {
        this.module = module;
        this.flags = flags;
        this.contentLoader = contentLoader;
        if (setting != AssertionSetting.INHERIT) {
            this.setDefaultAssertionStatus(setting == AssertionSetting.ENABLED);
        }
    }

    @Override
    protected Class<?> findClass(String className, boolean exportsOnly) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        Set<Module.Flag> flags = this.flags;
        if (flags.contains((Object)Module.Flag.CHILD_FIRST)) {
            loadedClass = this.loadClassLocal(className, exportsOnly);
            if (loadedClass == null) {
                loadedClass = this.getImportedClass(className, exportsOnly);
            }
        } else {
            loadedClass = this.getImportedClass(className, exportsOnly);
            if (loadedClass == null) {
                loadedClass = this.loadClassLocal(className, exportsOnly);
            }
        }
        if (loadedClass == null) {
            throw new ClassNotFoundException(className + " from [" + this.module + "]");
        }
        return loadedClass;
    }

    Class<?> getImportedClass(String className, boolean exportsOnly) {
        String path;
        Map<String, List<Module.DependencyImport>> pathsToImports = this.module.getPathsToImports();
        List<Module.DependencyImport> dependenciesForPath = pathsToImports.get(path = this.getPathFromClassName(className));
        if (dependenciesForPath == null) {
            return null;
        }
        for (Module.DependencyImport dependencyImport : dependenciesForPath) {
            Dependency dependency = dependencyImport.getDependency();
            if (exportsOnly && (!dependency.isExport() || !dependencyImport.isExport())) continue;
            Module module = dependency.getModule();
            try {
                Class<?> importedClass = module.getClassLoader().loadExportedClass(className);
                if (importedClass == null) continue;
                return importedClass;
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        return null;
    }

    private Class<?> loadClassLocal(String className, boolean exportOnly) throws ClassNotFoundException {
        if (exportOnly) {
            String path = this.getPathFromClassName(className);
            Set<String> exportedPaths = this.module.getExportedPaths();
            if (!exportedPaths.contains(path)) {
                return null;
            }
        }
        ClassSpec classSpec = null;
        try {
            classSpec = this.contentLoader.getClassSpec(className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className, e);
        }
        catch (RuntimeException e) {
            System.err.print("Unexpected runtime exception in module loader: ");
            e.printStackTrace(System.err);
            throw new ClassNotFoundException(className, e);
        }
        catch (Error e) {
            System.err.print("Unexpected error in module loader: ");
            e.printStackTrace(System.err);
            throw new ClassNotFoundException(className, e);
        }
        if (classSpec == null) {
            return null;
        }
        return this.defineClass(className, classSpec);
    }

    private Class<?> defineClass(String name, ClassSpec classSpec) {
        Class<?> newClass;
        int lastIdx = name.lastIndexOf(46);
        if (lastIdx != -1) {
            String packageName = name.substring(0, lastIdx);
            Package pkg = this.getPackage(packageName);
            if (pkg != null) {
                if (pkg.isSealed() && !pkg.isSealed(classSpec.getCodeSource().getLocation())) {
                    throw new SecurityException("sealing violation: package " + packageName + " is sealed");
                }
            } else {
                try {
                    PackageSpec spec = this.contentLoader.getPackageSpec(name);
                    this.definePackage(packageName, spec);
                }
                catch (IOException e) {
                    this.definePackage(packageName, null);
                }
            }
        }
        try {
            byte[] bytes = classSpec.getBytes();
            newClass = this.defineClass(name, bytes, 0, bytes.length, classSpec.getCodeSource());
        }
        catch (Error e) {
            if (debugDefines) {
                System.err.println("Failed to define class '" + name + "': " + e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (debugDefines) {
                System.err.println("Failed to define class '" + name + "': " + e);
            }
            throw e;
        }
        AssertionSetting setting = classSpec.getAssertionSetting();
        if (setting != AssertionSetting.INHERIT) {
            this.setClassAssertionStatus(name, setting == AssertionSetting.ENABLED);
        }
        return newClass;
    }

    private Package definePackage(String name, PackageSpec spec) {
        if (spec == null) {
            return this.definePackage(name, null, null, null, null, null, null, null);
        }
        Package pkg = this.definePackage(name, spec.getSpecTitle(), spec.getSpecVersion(), spec.getSpecVendor(), spec.getImplTitle(), spec.getImplVersion(), spec.getImplVendor(), spec.getSealBase());
        AssertionSetting setting = spec.getAssertionSetting();
        if (setting != AssertionSetting.INHERIT) {
            this.setPackageAssertionStatus(name, setting == AssertionSetting.ENABLED);
        }
        return pkg;
    }

    private String getPathFromClassName(String className) {
        int idx = className.lastIndexOf(46);
        return idx > -1 ? className.substring(0, idx).replace('.', '/') : "";
    }

    @Override
    protected String findLibrary(String libname) {
        return this.contentLoader.getLibrary(libname);
    }

    Resource getRawResource(String root, String name) {
        return this.contentLoader.getResource(root, name);
    }

    @Override
    public URL findResource(String name, boolean exportsOnly) {
        URL resource = null;
        Set<Module.Flag> flags = this.flags;
        if (flags.contains((Object)Module.Flag.CHILD_FIRST)) {
            resource = this.getLocalResource(name, exportsOnly);
            if (resource == null) {
                resource = this.getImportedResource(name, exportsOnly);
            }
        } else {
            resource = this.getImportedResource(name, exportsOnly);
            if (resource == null) {
                resource = this.getLocalResource(name, exportsOnly);
            }
        }
        return resource;
    }

    final URL getImportedResource(String resourcePath, boolean exportsOnly) {
        String path;
        Map<String, List<Module.DependencyImport>> pathsToImports = this.module.getPathsToImports();
        List<Module.DependencyImport> dependenciesForPath = pathsToImports.get(path = this.getPathFromResourceName(resourcePath));
        if (dependenciesForPath == null) {
            return null;
        }
        for (Module.DependencyImport dependencyImport : dependenciesForPath) {
            Module module;
            URL importedResource;
            Dependency dependency = dependencyImport.getDependency();
            if (exportsOnly && (!dependency.isExport() || !dependencyImport.isExport()) || (importedResource = (module = dependency.getModule()).getClassLoader().findResource(resourcePath, true)) == null) continue;
            return importedResource;
        }
        return null;
    }

    final URL getLocalResource(String resourcePath, boolean exportOnly) {
        Resource localResource;
        if (exportOnly) {
            String path = this.getPathFromResourceName(resourcePath);
            Set<String> exportedPaths = this.module.getExportedPaths();
            if (!exportedPaths.contains(path)) {
                return null;
            }
        }
        return (localResource = this.contentLoader.getResource(resourcePath)) != null ? localResource.getURL() : null;
    }

    @Override
    public Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        HashSet<URL> resources = new HashSet<URL>();
        resources.addAll(this.getLocalResources(name, exportsOnly));
        resources.addAll(this.getImportedResources(name, exportsOnly));
        final Iterator iterator = resources.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)iterator.next();
            }
        };
    }

    final Collection<URL> getLocalResources(String resourcePath, boolean exportOnly) {
        Iterable<Resource> resources;
        if (exportOnly) {
            String path = this.getPathFromResourceName(resourcePath);
            Set<String> exportedPaths = this.module.getExportedPaths();
            if (!exportedPaths.contains(path)) {
                return Collections.emptyList();
            }
        }
        if ((resources = this.contentLoader.getResources(resourcePath)) != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Resource resource : resources) {
                urls.add(resource.getURL());
            }
            return urls;
        }
        return Collections.emptyList();
    }

    final Collection<URL> getImportedResources(String resourcePath, boolean exportsOnly) throws IOException {
        String path;
        Map<String, List<Module.DependencyImport>> pathsToImports = this.module.getPathsToImports();
        List<Module.DependencyImport> dependenciesForPath = pathsToImports.get(path = this.getPathFromResourceName(resourcePath));
        if (dependenciesForPath == null) {
            return Collections.emptySet();
        }
        HashSet<URL> importedUrls = new HashSet<URL>();
        for (Module.DependencyImport dependencyImport : dependenciesForPath) {
            Module module;
            Enumeration<URL> importedResources;
            Dependency dependency = dependencyImport.getDependency();
            if (exportsOnly && (!dependency.isExport() || !dependencyImport.isExport()) || (importedResources = (module = dependency.getModule()).getClassLoader().findResources(resourcePath, true)) == null) continue;
            while (importedResources.hasMoreElements()) {
                URL importedResource = importedResources.nextElement();
                importedUrls.add(importedResource);
            }
        }
        return importedUrls;
    }

    @Override
    public InputStream findResourceAsStream(String name, boolean exportsOnly) {
        try {
            URL resource = this.findResource(name, exportsOnly);
            return resource == null ? null : resource.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getPathFromResourceName(String resourcePath) {
        int idx = resourcePath.lastIndexOf(47);
        String path = idx > -1 ? resourcePath.substring(0, idx) : resourcePath;
        return path;
    }

    public Module getModule() {
        return this.module;
    }

    public String toString() {
        return "ClassLoader for " + this.module;
    }

    public static ModuleClassLoader forModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return Module.getModule(identifier).getClassLoader();
    }

    public static ModuleClassLoader forModuleName(String identifier) throws ModuleLoadException {
        return ModuleClassLoader.forModule(ModuleIdentifier.fromString(identifier));
    }

    public static ModuleClassLoader createAggregate(String identifier, List<String> dependencies) throws ModuleLoadException {
        ArrayList<ModuleIdentifier> depModuleIdentifiers = new ArrayList<ModuleIdentifier>(dependencies.size());
        for (String dependencySpec : dependencies) {
            depModuleIdentifiers.add(ModuleIdentifier.fromString(dependencySpec));
        }
        return InitialModuleLoader.INSTANCE.createAggregate(ModuleIdentifier.fromString(identifier), depModuleIdentifiers).getClassLoader();
    }

    static {
        try {
            Method method = ClassLoader.class.getMethod("registerAsParallelCapable", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        debugDefines = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty("jboss.modules.debug.defineClass", "false"));
            }
        });
    }
}

