/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly13.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.wfly13.task.subsystem.elytron.PermissionSet;

public class PermissionSetMapping {
    private List<String> principals = new ArrayList<String>();
    private List<PermissionSet> permissionSets = new ArrayList<PermissionSet>();
    private Boolean matchAll;

    public PermissionSetMapping matchAll(boolean matchAll) {
        this.matchAll = matchAll;
        return this;
    }

    public PermissionSetMapping addPrincipal(String principal) {
        this.principals.add(principal);
        return this;
    }

    public PermissionSetMapping addPermissionSet(PermissionSet permissionSet) {
        this.permissionSets.add(permissionSet);
        return this;
    }

    public ModelNode toModelNode() {
        ModelNode modelNode = new ModelNode();
        if (this.matchAll != null) {
            modelNode.get("match-all").set(this.matchAll.booleanValue());
        }
        if (this.principals != null && !this.principals.isEmpty()) {
            ModelNode principalsNode = modelNode.get("principals").setEmptyList();
            for (String principal : this.principals) {
                principalsNode.add(principal);
            }
        }
        if (this.permissionSets != null && !this.permissionSets.isEmpty()) {
            ModelNode permissionSetsNode = modelNode.get("permission-sets").setEmptyList();
            for (PermissionSet permissionSet : this.permissionSets) {
                permissionSetsNode.add(permissionSet.toModelNode());
            }
        }
        return modelNode;
    }
}

