/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jbossweb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Attribute;
import org.jboss.metadata.parser.jbossweb.ContainerListenerMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Element;
import org.jboss.metadata.parser.jbossweb.JBossAnnotationMetaDataParser;
import org.jboss.metadata.parser.jbossweb.JBossServletMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Location;
import org.jboss.metadata.parser.jbossweb.PassivationConfigParser;
import org.jboss.metadata.parser.jbossweb.ReplicationConfigParser;
import org.jboss.metadata.parser.jbossweb.ValveMetaDataParser;
import org.jboss.metadata.parser.jbossweb.Version;
import org.jboss.metadata.parser.servlet.SessionConfigMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.jboss.ContainerListenerMetaData;
import org.jboss.metadata.web.jboss.JBoss4xDTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50DTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50WebMetaData;
import org.jboss.metadata.web.jboss.JBoss60WebMetaData;
import org.jboss.metadata.web.jboss.JBoss70WebMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationsMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ValveMetaData;

public class JBossWebMetaDataParser
extends MetaDataElementParser {
    public static JBossWebMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            String dtdLocation = JBossWebMetaDataParser.readDTDLocation((XMLStreamReader)reader);
            if (dtdLocation != null) {
                version = Location.getVersion(dtdLocation);
            }
            if (version != null) continue;
            version = Version.JBOSS_WEB_5_0;
        }
        String schemaLocation = JBossWebMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Location.getVersion(schemaLocation);
        }
        if (version == null) {
            version = Version.JBOSS_WEB_6_0;
        }
        JBossWebMetaData wmd = null;
        switch (version) {
            case JBOSS_WEB_3_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_3_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_0: {
                wmd = new JBoss50DTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_1: {
                wmd = new JBoss50WebMetaData();
                break;
            }
            case JBOSS_WEB_6_0: {
                wmd = new JBoss60WebMetaData();
                break;
            }
            case JBOSS_WEB_7_0: {
                wmd = new JBoss70WebMetaData();
            }
        }
        int count = reader.getAttributeCount();
        block34: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossWebMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    wmd.setVersion(value);
                    continue block34;
                }
                default: {
                    throw JBossWebMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
        block35: while (reader.hasNext() && reader.nextTag() != 2) {
            if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)env)) {
                if (wmd.getJndiEnvironmentRefsGroup() != null) continue;
                wmd.setJndiEnvironmentRefsGroup((Environment)env);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONTEXT_ROOT: {
                    wmd.setContextRoot(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block35;
                }
                case VIRTUAL_HOST: {
                    List<String> virtualHosts = wmd.getVirtualHosts();
                    if (virtualHosts == null) {
                        virtualHosts = new ArrayList<String>();
                        wmd.setVirtualHosts(virtualHosts);
                        virtualHosts.add(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                        continue block35;
                    }
                    throw JBossWebMetaDataParser.duplicateNamedElement((XMLStreamReader)reader, (String)Element.VIRTUAL_HOST.toString());
                }
                case ANNOTATION: {
                    JBossAnnotationsMetaData annotations = wmd.getAnnotations();
                    if (annotations == null) {
                        annotations = new JBossAnnotationsMetaData();
                        wmd.setAnnotations(annotations);
                    }
                    annotations.add((MappableMetaData)JBossAnnotationMetaDataParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case LISTENER: {
                    List<ContainerListenerMetaData> listeners = wmd.getContainerListeners();
                    if (listeners == null) {
                        listeners = new ArrayList<ContainerListenerMetaData>();
                        wmd.setContainerListeners(listeners);
                    }
                    listeners.add(ContainerListenerMetaDataParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case SESSION_CONFIG: {
                    wmd.setSessionConfig(SessionConfigMetaDataParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case VALVE: {
                    List<ValveMetaData> valves = wmd.getValves();
                    if (valves == null) {
                        valves = new ArrayList<ValveMetaData>();
                        wmd.setValves(valves);
                    }
                    valves.add(ValveMetaDataParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case OVERLAY: {
                    List<String> overlays = wmd.getOverlays();
                    if (overlays == null) {
                        overlays = new ArrayList<String>();
                        wmd.setOverlays(overlays);
                    }
                    overlays.add(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block35;
                }
                case SECURITY_DOMAIN: {
                    wmd.setSecurityDomain(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block35;
                }
                case SECURITY_ROLE: {
                    SecurityRolesMetaData securityRoles = wmd.getSecurityRoles();
                    if (securityRoles == null) {
                        securityRoles = new SecurityRolesMetaData();
                        wmd.setSecurityRoles(securityRoles);
                    }
                    securityRoles.add((MappableMetaData)SecurityRoleMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block35;
                }
                case JACC_STAR_ROLE_ALLOW: {
                    wmd.setJaccAllStoreRole(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block35;
                }
                case DISABLE_CROSS_CONTEXT: {
                    wmd.setDisableCrossContext(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block35;
                }
                case USE_JBOSS_AUTHORIZATION: {
                    wmd.setUseJBossAuthorization(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block35;
                }
                case DISABLE_AUDIT: {
                    wmd.setDisableAudit(Boolean.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block35;
                }
                case SERVLET: {
                    JBossServletsMetaData servlets = wmd.getServlets();
                    if (servlets == null) {
                        servlets = new JBossServletsMetaData();
                        wmd.setServlets(servlets);
                    }
                    servlets.add((MappableMetaData)JBossServletMetaDataParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case MAX_ACTIVE_SESSIONS: {
                    wmd.setMaxActiveSessions(Integer.valueOf(JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block35;
                }
                case REPLICATION_CONFIG: {
                    wmd.setReplicationConfig(ReplicationConfigParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case PASSIVATION_CONFIG: {
                    wmd.setPassivationConfig(PassivationConfigParser.parse(reader, propertyReplacer));
                    continue block35;
                }
                case DISTINCT_NAME: {
                    String val = JBossWebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                    wmd.setDistinctName(val);
                    continue block35;
                }
            }
            throw JBossWebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return wmd;
    }
}

