/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.ParamValueMetaDataParser;
import org.jboss.metadata.parser.ee.RunAsMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleRefMetaDataParser;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.servlet.MultipartConfigMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.ServletMetaData;

public class ServletMetaDataParser
extends MetaDataElementParser {
    public static ServletMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ServletMetaData servlet = new ServletMetaData();
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (ServletMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    servlet.setId(value);
                    continue block15;
                }
                default: {
                    throw ServletMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (servlet.getDescriptionGroup() != null) continue;
                servlet.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVLET_NAME: {
                    servlet.setServletName(ServletMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block16;
                }
                case SERVLET_CLASS: {
                    servlet.setServletClass(ServletMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block16;
                }
                case JSP_FILE: {
                    servlet.setJspFile(ServletMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block16;
                }
                case INIT_PARAM: {
                    List<ParamValueMetaData> initParams = servlet.getInitParam();
                    if (initParams == null) {
                        initParams = new ArrayList<ParamValueMetaData>();
                        servlet.setInitParam(initParams);
                    }
                    initParams.add(ParamValueMetaDataParser.parse((XMLStreamReader)reader));
                    continue block16;
                }
                case LOAD_ON_STARTUP: {
                    servlet.setLoadOnStartup(ServletMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block16;
                }
                case ENABLED: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(ServletMetaDataParser.getElementText((XMLStreamReader)reader)))) {
                        servlet.setEnabled(true);
                        continue block16;
                    }
                    servlet.setEnabled(false);
                    continue block16;
                }
                case ASYNC_SUPPORTED: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(ServletMetaDataParser.getElementText((XMLStreamReader)reader)))) {
                        servlet.setAsyncSupported(true);
                        continue block16;
                    }
                    servlet.setAsyncSupported(false);
                    continue block16;
                }
                case RUN_AS: {
                    servlet.setRunAs(RunAsMetaDataParser.parse((XMLStreamReader)reader));
                    continue block16;
                }
                case SECURITY_ROLE_REF: {
                    SecurityRoleRefsMetaData securityRoleRefs = servlet.getSecurityRoleRefs();
                    if (securityRoleRefs == null) {
                        securityRoleRefs = new SecurityRoleRefsMetaData();
                        servlet.setSecurityRoleRefs(securityRoleRefs);
                    }
                    securityRoleRefs.add((MappableMetaData)SecurityRoleRefMetaDataParser.parse((XMLStreamReader)reader));
                    continue block16;
                }
                case MULTIPART_CONFIG: {
                    servlet.setMultipartConfig(MultipartConfigMetaDataParser.parse(reader));
                    continue block16;
                }
            }
            throw ServletMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return servlet;
    }
}

