/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebFilterProcessor
extends AbstractFinderUser
implements Creator<Class<?>, WebMetaData>,
Processor<WebMetaData, Class<?>> {
    public WebFilterProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public WebMetaData create(Class<?> element) {
        DescriptionGroupMetaData descriptionGroup;
        WebFilter webFilter = (WebFilter)this.finder.getAnnotation(element, WebFilter.class);
        if (webFilter == null) {
            return null;
        }
        WebMetaData metaData = new WebMetaData();
        FiltersMetaData filters = new FiltersMetaData();
        FilterMetaData filter = new FilterMetaData();
        filter.setFilterClass(element.getName());
        String filterName = null;
        filterName = webFilter.filterName().length() == 0 ? element.getName() : webFilter.filterName();
        filter.setFilterName(filterName);
        filter.setAsyncSupported(webFilter.asyncSupported());
        if (webFilter.initParams() != null) {
            ArrayList<ParamValueMetaData> initParams = new ArrayList<ParamValueMetaData>();
            for (WebInitParam webInitParam : webFilter.initParams()) {
                ParamValueMetaData paramValue = new ParamValueMetaData();
                paramValue.setParamName(webInitParam.name());
                paramValue.setParamValue(webInitParam.value());
                initParams.add(paramValue);
            }
            filter.setInitParam(initParams);
        }
        if ((descriptionGroup = ProcessorUtils.getDescriptionGroup((String)webFilter.description(), (String)webFilter.displayName(), (String)webFilter.smallIcon(), (String)webFilter.largeIcon())) != null) {
            filter.setDescriptionGroup(descriptionGroup);
        }
        filters.add((MappableMetaData)filter);
        metaData.setFilters(filters);
        if (webFilter.urlPatterns() != null || webFilter.value() != null || webFilter.servletNames() != null) {
            ArrayList<FilterMappingMetaData> filterMappings = new ArrayList<FilterMappingMetaData>();
            FilterMappingMetaData filterMapping = new FilterMappingMetaData();
            filterMapping.setFilterName(filterName);
            if (webFilter.urlPatterns() != null || webFilter.value() != null) {
                ArrayList<String> urlPatterns = new ArrayList<String>();
                if (webFilter.urlPatterns() != null) {
                    for (String string : webFilter.urlPatterns()) {
                        urlPatterns.add(string);
                    }
                }
                if (webFilter.value() != null) {
                    for (String string : webFilter.value()) {
                        urlPatterns.add(string);
                    }
                }
                filterMapping.setUrlPatterns(urlPatterns);
            }
            if (webFilter.servletNames() != null) {
                ArrayList<String> servletNames = new ArrayList<String>();
                for (String string : webFilter.servletNames()) {
                    servletNames.add(string);
                }
                filterMapping.setServletNames(servletNames);
            }
            if (webFilter.dispatcherTypes() != null) {
                ArrayList<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>();
                for (String string : webFilter.dispatcherTypes()) {
                    dispatcherTypes.add(DispatcherType.valueOf(string.toString()));
                }
                filterMapping.setDispatchers(dispatcherTypes);
            }
            filterMappings.add(filterMapping);
            metaData.setFilterMappings(filterMappings);
        }
        return metaData;
    }

    public void process(WebMetaData metaData, Class<?> type) {
        WebFilter annotation = (WebFilter)this.finder.getAnnotation(type, WebFilter.class);
        if (annotation == null) {
            return;
        }
        WebMetaData filterMetaData = this.create(type);
        if (metaData.getFilters() == null) {
            metaData.setFilters(filterMetaData.getFilters());
        } else {
            metaData.getFilters().addAll((Collection)((Object)filterMetaData.getFilters()));
        }
        if (metaData.getFilterMappings() == null) {
            metaData.setFilterMappings(filterMetaData.getFilterMappings());
        } else if (filterMetaData.getFilterMappings() != null) {
            metaData.getFilterMappings().addAll(filterMetaData.getFilterMappings());
        }
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(WebFilter.class);
    }
}

