/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.Collection;
import java.util.List;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.metadata.ejb.spec.AbstractCommonMessageDrivenSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.AbstractEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.CMPFieldsMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.DependsOnMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.ejb.spec.EjbType;
import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenDestinationMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.PersistenceType;
import org.jboss.metadata.ejb.spec.QueriesMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;
import org.jboss.metadata.ejb.spec.SubscriptionDurability;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public abstract class AbstractGenericBeanMetaData
extends AbstractCommonMessageDrivenSessionBeanMetaData {
    private static final long serialVersionUID = 1L;
    private PersistenceType persistenceType;
    private String primKeyClass;
    private Boolean reentrant;
    private String cmpVersion;
    private String abstractSchemaName;
    private CMPFieldsMetaData cmpFields;
    private String primKeyField;
    private QueriesMetaData queries;
    private String messagingType;
    private String messageDestinationType;
    private String messageDestinationLink;
    private ActivationConfigMetaData activationConfig;
    private String messageSelector;
    private String acknowledgeMode;
    private SubscriptionDurability subscriptionDurability;
    private String home;
    private String remote;
    private String localHome;
    private String local;
    private BusinessLocalsMetaData businessLocals;
    private BusinessRemotesMetaData businessRemotes;
    private String serviceEndpoint;
    private SessionType sessionType;
    private InitMethodsMetaData initMethods;
    private RemoveMethodsMetaData removeMethods;
    private LifecycleCallbacksMetaData postActivates;
    private LifecycleCallbacksMetaData prePassivates;
    private AsyncMethodsMetaData asyncMethods;
    private EmptyMetaData localBean;
    private Boolean initOnStartup;
    private ConcurrentMethodsMetaData concurrentMethods;
    private LockType beanLevelLockType;
    private AccessTimeoutMetaData beanLevelAccessTimeout;
    private ConcurrencyManagementType concurrencyManagementType;
    private DependsOnMetaData dependsOn;
    private NamedMethodMetaData afterBeginMethod;
    private NamedMethodMetaData beforeCompletionMethod;
    private NamedMethodMetaData afterCompletionMethod;
    private StatefulTimeoutMetaData statefulTimeout;

    protected AbstractGenericBeanMetaData() {
    }

    private final void assertUnknownEntityOrSessionBean() {
        if (this.getEjbType() != null && this.getEjbType() != EjbType.ENTITY && this.getEjbType() != EjbType.SESSION) {
            throw new IllegalStateException("Bean " + this + " is not an unknown, entity or session bean, but " + (Object)((Object)this.getEjbType()));
        }
    }

    private final void assertUnknownOrEntityBean() {
        if (this.getEjbType() != null && this.getEjbType() != EjbType.ENTITY) {
            throw new IllegalStateException("Bean " + this + " is not an unknown or entity bean, but " + (Object)((Object)this.getEjbType()));
        }
    }

    private final void assertUnknownOrMessageDrivenBean() {
        if (this.getEjbType() != null && this.getEjbType() != EjbType.MESSAGE_DRIVEN) {
            throw new IllegalStateException("Bean " + this + " is not an unknown or message driven bean, but " + (Object)((Object)this.getEjbType()));
        }
    }

    private final void assertUnknownOrSessionBean() {
        if (this.getEjbType() != null && this.getEjbType() != EjbType.SESSION) {
            throw new IllegalStateException("Bean " + this + " is not an unknown or session bean, but " + (Object)((Object)this.getEjbType()));
        }
    }

    private final void assertUnknownOrSessionBean31() {
        this.assertUnknownOrSessionBean();
        EjbJarMetaData ejbJarMetaData = this.getEjbJarMetaData();
        if (ejbJarMetaData != null && ejbJarMetaData.getEjbJarVersion() != EjbJarVersion.EJB_3_1) {
            throw new IllegalStateException("Bean " + this + " is not an 3.1 EJB, but " + (Object)((Object)ejbJarMetaData.getEjbJarVersion()));
        }
    }

    @Override
    protected abstract AbstractEnterpriseBeanMetaData createMerged(AbstractEnterpriseBeanMetaData var1);

    public String getMessagingType() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messagingType;
    }

    public boolean isJMS() {
        this.assertUnknownOrMessageDrivenBean();
        String messagingType = this.getMessagingType();
        return messagingType == null || "javax.jms.MessageListener".equals(messagingType);
    }

    public void setMessagingType(String messagingType) {
        this.assertUnknownOrMessageDrivenBean();
        if (messagingType == null) {
            throw new IllegalArgumentException("Null messagingType");
        }
        this.messagingType = messagingType;
    }

    public String getMessageDestinationType() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messageDestinationType;
    }

    public void setMessageDestinationType(String messageDestinationType) {
        this.assertUnknownOrMessageDrivenBean();
        if (messageDestinationType == null) {
            throw new IllegalArgumentException("Null messageDestinationType");
        }
        this.messageDestinationType = messageDestinationType;
    }

    public String getMessageDestinationLink() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messageDestinationLink;
    }

    public void setMessageDestinationLink(String messageDestinationLink) {
        this.assertUnknownOrMessageDrivenBean();
        if (messageDestinationLink == null) {
            throw new IllegalArgumentException("Null messageDestinationLink");
        }
        this.messageDestinationLink = messageDestinationLink;
    }

    public ActivationConfigMetaData getActivationConfig() {
        this.assertUnknownOrMessageDrivenBean();
        return this.activationConfig;
    }

    public void setActivationConfig(ActivationConfigMetaData activationConfig) {
        this.assertUnknownOrMessageDrivenBean();
        if (activationConfig == null) {
            throw new IllegalArgumentException("Null activationConfig");
        }
        this.activationConfig = activationConfig;
    }

    public String getMessageSelector() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.assertUnknownOrMessageDrivenBean();
        if (messageSelector == null) {
            throw new IllegalArgumentException("Null messageSelector");
        }
        this.messageSelector = messageSelector;
    }

    public String getAcknowledgeMode() {
        this.assertUnknownOrMessageDrivenBean();
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.assertUnknownOrMessageDrivenBean();
        if (acknowledgeMode == null) {
            throw new IllegalArgumentException("Null acknowledgeMode");
        }
        this.acknowledgeMode = acknowledgeMode;
    }

    public SubscriptionDurability getSubscriptionDurability() {
        this.assertUnknownOrMessageDrivenBean();
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability) {
        this.assertUnknownOrMessageDrivenBean();
        if (subscriptionDurability == null) {
            throw new IllegalArgumentException("Null subscriptionDurability");
        }
        this.subscriptionDurability = subscriptionDurability;
    }

    public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd) {
        this.assertUnknownOrMessageDrivenBean();
        this.setMessageDestinationType(mdd.getDestinationType());
        String durability = mdd.getSubscriptionDurability();
        SubscriptionDurability sd = SubscriptionDurability.NonDurable;
        if (durability != null && durability.equalsIgnoreCase("Durable")) {
            sd = SubscriptionDurability.Durable;
        }
        this.setSubscriptionDurability(sd);
    }

    public String getHome() {
        this.assertUnknownEntityOrSessionBean();
        return this.home;
    }

    public void setHome(String home) {
        this.assertUnknownEntityOrSessionBean();
        if (home == null) {
            throw new IllegalArgumentException("Null home");
        }
        this.home = home;
    }

    public String getRemote() {
        this.assertUnknownEntityOrSessionBean();
        return this.remote;
    }

    public void setRemote(String remote) {
        this.assertUnknownEntityOrSessionBean();
        if (remote == null) {
            throw new IllegalArgumentException("Null remote");
        }
        this.remote = remote;
    }

    public String getLocalHome() {
        this.assertUnknownEntityOrSessionBean();
        return this.localHome;
    }

    public void setLocalHome(String localHome) {
        this.assertUnknownEntityOrSessionBean();
        if (localHome == null) {
            throw new IllegalArgumentException("Null localHome");
        }
        this.localHome = localHome;
    }

    public String getLocal() {
        this.assertUnknownEntityOrSessionBean();
        return this.local;
    }

    public void setLocal(String local) {
        this.assertUnknownEntityOrSessionBean();
        if (local == null) {
            throw new IllegalArgumentException("Null local");
        }
        this.local = local;
    }

    public BusinessLocalsMetaData getBusinessLocals() {
        this.assertUnknownOrSessionBean();
        return this.businessLocals;
    }

    public void setBusinessLocals(BusinessLocalsMetaData businessLocals) {
        this.assertUnknownOrSessionBean();
        if (businessLocals == null) {
            throw new IllegalArgumentException("Null businessLocals");
        }
        this.businessLocals = businessLocals;
    }

    public BusinessRemotesMetaData getBusinessRemotes() {
        this.assertUnknownOrSessionBean();
        return this.businessRemotes;
    }

    public void setBusinessRemotes(BusinessRemotesMetaData businessRemotes) {
        this.assertUnknownOrSessionBean();
        if (businessRemotes == null) {
            throw new IllegalArgumentException("Null businessRemotes");
        }
        this.businessRemotes = businessRemotes;
    }

    public String getServiceEndpoint() {
        this.assertUnknownOrSessionBean();
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.assertUnknownOrSessionBean();
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException("Null serviceEndpoint");
        }
        this.serviceEndpoint = serviceEndpoint;
    }

    public SessionType getSessionType() {
        this.assertUnknownOrSessionBean();
        return this.sessionType;
    }

    public void setSessionType(SessionType sessionType) {
        this.assertUnknownOrSessionBean();
        if (sessionType == null) {
            throw new IllegalArgumentException("Null sessionType");
        }
        this.sessionType = sessionType;
    }

    public boolean isStateful() {
        this.assertUnknownOrSessionBean();
        if (this.sessionType == null) {
            return false;
        }
        return this.sessionType == SessionType.Stateful;
    }

    public boolean isStateless() {
        this.assertUnknownOrSessionBean();
        if (this.sessionType == null) {
            return false;
        }
        return this.sessionType == SessionType.Stateless;
    }

    @Override
    public void setTimeoutMethod(NamedMethodMetaData timeoutMethod) {
        if (this.getEjbType() != EjbType.MESSAGE_DRIVEN && this.getSessionType() != null && this.getSessionType() != SessionType.Stateless) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.8: Only stateless beans can have timeouts: " + this);
        }
        super.setTimeoutMethod(timeoutMethod);
    }

    public InitMethodsMetaData getInitMethods() {
        this.assertUnknownOrSessionBean();
        return this.initMethods;
    }

    public void setInitMethods(InitMethodsMetaData initMethods) {
        this.assertUnknownOrSessionBean();
        if (initMethods == null) {
            throw new IllegalArgumentException("Null initMethods");
        }
        this.initMethods = initMethods;
    }

    public RemoveMethodsMetaData getRemoveMethods() {
        this.assertUnknownOrSessionBean();
        return this.removeMethods;
    }

    public void setRemoveMethods(RemoveMethodsMetaData removeMethods) {
        this.assertUnknownOrSessionBean();
        if (removeMethods == null) {
            throw new IllegalArgumentException("Null removeMethods");
        }
        this.removeMethods = removeMethods;
    }

    public LifecycleCallbacksMetaData getPostActivates() {
        this.assertUnknownOrSessionBean();
        return this.postActivates;
    }

    public void setPostActivates(LifecycleCallbacksMetaData postActivates) {
        this.assertUnknownOrSessionBean();
        if (postActivates == null) {
            throw new IllegalArgumentException("Null postActivates");
        }
        this.postActivates = postActivates;
    }

    public LifecycleCallbacksMetaData getPrePassivates() {
        this.assertUnknownOrSessionBean();
        return this.prePassivates;
    }

    public void setPrePassivates(LifecycleCallbacksMetaData prePassivates) {
        this.assertUnknownOrSessionBean();
        if (prePassivates == null) {
            throw new IllegalArgumentException("Null prePassivates");
        }
        this.prePassivates = prePassivates;
    }

    private void mergeSessionBean(AbstractGenericBeanMetaData override, AbstractGenericBeanMetaData original) {
        if (override != null && override.home != null) {
            this.setHome(override.home);
        } else if (original != null && original.home != null) {
            this.setHome(original.home);
        }
        if (override != null && override.remote != null) {
            this.setRemote(override.remote);
        } else if (original != null && original.remote != null) {
            this.setRemote(original.remote);
        }
        if (override != null && override.localHome != null) {
            this.setLocalHome(override.localHome);
        } else if (original != null && original.localHome != null) {
            this.setLocalHome(original.localHome);
        }
        if (override != null && override.local != null) {
            this.setLocal(override.local);
        } else if (original != null && original.local != null) {
            this.setLocal(original.local);
        }
        this.businessLocals = AbstractGenericBeanMetaData.augment(new BusinessLocalsMetaData(), override != null ? override.businessLocals : null, original != null ? original.businessLocals : null);
        this.businessRemotes = AbstractGenericBeanMetaData.augment(new BusinessRemotesMetaData(), override != null ? override.businessRemotes : null, original != null ? original.businessRemotes : null);
        if (override != null && override.serviceEndpoint != null) {
            this.setServiceEndpoint(override.serviceEndpoint);
        } else if (original != null && original.serviceEndpoint != null) {
            this.setServiceEndpoint(original.serviceEndpoint);
        }
        if (override != null && override.sessionType != null) {
            this.setSessionType(override.sessionType);
        } else if (original != null && original.sessionType != null) {
            this.setSessionType(original.sessionType);
        }
        this.initMethods = AbstractGenericBeanMetaData.augment(new InitMethodsMetaData(), override != null ? override.initMethods : null, original != null ? original.initMethods : null);
        this.removeMethods = AbstractGenericBeanMetaData.augment(new RemoveMethodsMetaData(), override != null ? override.removeMethods : null, original != null ? original.removeMethods : null);
        this.postActivates = AbstractGenericBeanMetaData.augment(new LifecycleCallbacksMetaData(), override != null ? override.postActivates : null, original != null ? original.postActivates : null);
        this.prePassivates = AbstractGenericBeanMetaData.augment(new LifecycleCallbacksMetaData(), override != null ? override.prePassivates : null, original != null ? original.prePassivates : null);
        this.mergeSessionBean31(override, original);
    }

    @Override
    public void merge(AbstractEnterpriseBeanMetaData eoverride, AbstractEnterpriseBeanMetaData eoriginal) {
        super.merge(eoverride, eoriginal);
        if (!(eoverride instanceof AbstractGenericBeanMetaData)) {
            return;
        }
        AbstractGenericBeanMetaData override = (AbstractGenericBeanMetaData)eoverride;
        AbstractGenericBeanMetaData original = (AbstractGenericBeanMetaData)eoriginal;
        this.mergeEntityBean(override, original);
        this.mergeMessageDrivenBean(override, original);
        this.mergeSessionBean(override, original);
    }

    private void mergeEntityBean(AbstractGenericBeanMetaData override, AbstractGenericBeanMetaData original) {
        this.primKeyClass = AbstractGenericBeanMetaData.override(override != null ? override.primKeyClass : null, original != null ? original.primKeyClass : null);
        this.persistenceType = AbstractGenericBeanMetaData.override(override != null ? override.persistenceType : null, original != null ? original.persistenceType : null);
        this.reentrant = AbstractGenericBeanMetaData.override(override != null ? override.reentrant : null, original != null ? original.reentrant : null);
        this.cmpVersion = AbstractGenericBeanMetaData.override(override != null ? override.cmpVersion : null, original != null ? original.cmpVersion : null);
        this.abstractSchemaName = AbstractGenericBeanMetaData.override(override != null ? override.abstractSchemaName : null, original != null ? original.abstractSchemaName : null);
        this.cmpFields = AbstractGenericBeanMetaData.override(override != null ? override.cmpFields : null, original != null ? original.cmpFields : null);
        this.primKeyField = AbstractGenericBeanMetaData.override(override != null ? override.primKeyField : null, original != null ? original.primKeyField : null);
        this.queries = AbstractGenericBeanMetaData.override(override != null ? override.queries : null, original != null ? original.queries : null);
    }

    private void mergeMessageDrivenBean(AbstractGenericBeanMetaData override, AbstractGenericBeanMetaData original) {
        this.messagingType = AbstractGenericBeanMetaData.override(override != null ? override.messagingType : null, original != null ? original.messagingType : null);
        this.messageDestinationType = AbstractGenericBeanMetaData.override(override != null ? override.messageDestinationType : null, original != null ? original.messageDestinationType : null);
        this.messageDestinationLink = AbstractGenericBeanMetaData.override(override != null ? override.messageDestinationLink : null, original != null ? original.messageDestinationLink : null);
        this.activationConfig = AbstractGenericBeanMetaData.merged(new ActivationConfigMetaData(), override != null ? override.activationConfig : null, original != null ? original.activationConfig : null);
        this.messageSelector = AbstractGenericBeanMetaData.override(override != null ? override.messageSelector : null, original != null ? original.messageSelector : null);
        this.acknowledgeMode = AbstractGenericBeanMetaData.override(override != null ? override.acknowledgeMode : null, original != null ? original.acknowledgeMode : null);
        this.subscriptionDurability = AbstractGenericBeanMetaData.override(override != null ? override.subscriptionDurability : null, original != null ? original.subscriptionDurability : null);
    }

    public Boolean isInitOnStartup() {
        this.assertUnknownOrSessionBean();
        return this.initOnStartup;
    }

    public void setInitOnStartup(Boolean initOnStartup) {
        this.assertUnknownOrSessionBean31();
        this.initOnStartup = initOnStartup;
    }

    public AsyncMethodsMetaData getAsyncMethods() {
        this.assertUnknownOrSessionBean();
        return this.asyncMethods;
    }

    public void setAsyncMethods(AsyncMethodsMetaData asyncMethods) {
        this.assertUnknownOrSessionBean31();
        if (asyncMethods == null) {
            throw new IllegalArgumentException("asyncMethods is null");
        }
        this.asyncMethods = asyncMethods;
    }

    public EmptyMetaData getLocalBean() {
        this.assertUnknownOrSessionBean();
        return this.localBean;
    }

    public void setLocalBean(EmptyMetaData localBean) {
        this.assertUnknownOrSessionBean31();
        this.localBean = localBean;
    }

    public boolean isNoInterfaceBean() {
        this.assertUnknownOrSessionBean();
        return this.localBean != null;
    }

    public void setNoInterfaceBean(boolean isNoInterfaceBean) {
        this.assertUnknownOrSessionBean31();
        this.localBean = isNoInterfaceBean ? new EmptyMetaData() : null;
    }

    public boolean isSingleton() {
        this.assertUnknownOrSessionBean();
        if (this.getSessionType() == null) {
            return false;
        }
        return this.getSessionType() == SessionType.Singleton;
    }

    public void setConcurrencyManagementType(ConcurrencyManagementType concurrencyManagementType) {
        this.assertUnknownOrSessionBean31();
        if (concurrencyManagementType == null) {
            throw new IllegalArgumentException("Concurrency management type cannot be null");
        }
        this.concurrencyManagementType = concurrencyManagementType;
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        this.assertUnknownOrSessionBean();
        return this.concurrencyManagementType;
    }

    public void setConcurrentMethods(ConcurrentMethodsMetaData concurrentMethods) {
        this.assertUnknownOrSessionBean31();
        this.concurrentMethods = concurrentMethods;
    }

    public ConcurrentMethodsMetaData getConcurrentMethods() {
        this.assertUnknownOrSessionBean();
        return this.concurrentMethods;
    }

    public void setLockType(LockType lockType) {
        this.assertUnknownOrSessionBean31();
        this.beanLevelLockType = lockType;
    }

    public LockType getLockType() {
        this.assertUnknownOrSessionBean();
        return this.beanLevelLockType;
    }

    public void setAccessTimeout(AccessTimeoutMetaData accessTimeout) {
        this.assertUnknownOrSessionBean31();
        this.beanLevelAccessTimeout = accessTimeout;
    }

    public AccessTimeoutMetaData getAccessTimeout() {
        this.assertUnknownOrSessionBean();
        return this.beanLevelAccessTimeout;
    }

    public String[] getDependsOn() {
        if (this.dependsOn == null || this.dependsOn.getEjbNames() == null) {
            return null;
        }
        List<String> ejbNames = this.dependsOn.getEjbNames();
        return ejbNames.toArray(new String[ejbNames.size()]);
    }

    public void setDependsOn(String[] dependsOn) {
        this.assertUnknownOrSessionBean31();
        this.dependsOn = new DependsOnMetaData(dependsOn);
    }

    public void setDependsOnMetaData(DependsOnMetaData dependsOnMetaData) {
        this.assertUnknownOrSessionBean31();
        this.dependsOn = dependsOnMetaData;
    }

    public void setDependsOn(Collection<String> dependsOn) {
        this.assertUnknownOrSessionBean31();
        if (dependsOn == null) {
            return;
        }
        this.setDependsOn(dependsOn.toArray(new String[dependsOn.size()]));
    }

    public NamedMethodMetaData getAfterBeginMethod() {
        this.assertUnknownOrSessionBean();
        return this.afterBeginMethod;
    }

    public void setAfterBeginMethod(NamedMethodMetaData method) {
        this.assertUnknownOrSessionBean31();
        this.afterBeginMethod = method;
    }

    public NamedMethodMetaData getBeforeCompletionMethod() {
        this.assertUnknownOrSessionBean();
        return this.beforeCompletionMethod;
    }

    public void setBeforeCompletionMethod(NamedMethodMetaData method) {
        this.assertUnknownOrSessionBean31();
        this.beforeCompletionMethod = method;
    }

    public NamedMethodMetaData getAfterCompletionMethod() {
        this.assertUnknownOrSessionBean();
        return this.afterCompletionMethod;
    }

    public void setAfterCompletionMethod(NamedMethodMetaData method) {
        this.assertUnknownOrSessionBean31();
        this.afterCompletionMethod = method;
    }

    private void mergeSessionBean31(AbstractGenericBeanMetaData override, AbstractGenericBeanMetaData original) {
        if (this.asyncMethods == null) {
            this.asyncMethods = new AsyncMethodsMetaData();
        }
        if (override != null && override.asyncMethods != null) {
            this.asyncMethods.addAll(override.asyncMethods);
        }
        if (original != null && original.asyncMethods != null) {
            this.asyncMethods.addAll(original.asyncMethods);
        }
        this.afterBeginMethod = AbstractGenericBeanMetaData.override(override != null ? override.afterBeginMethod : null, original != null ? original.afterBeginMethod : null);
        this.beforeCompletionMethod = AbstractGenericBeanMetaData.override(override != null ? override.beforeCompletionMethod : null, original != null ? original.beforeCompletionMethod : null);
        this.afterCompletionMethod = AbstractGenericBeanMetaData.override(override != null ? override.afterCompletionMethod : null, original != null ? original.afterCompletionMethod : null);
        this.concurrentMethods = new ConcurrentMethodsMetaData();
        this.concurrentMethods.merge(override != null ? override.concurrentMethods : null, original != null ? original.concurrentMethods : null);
        this.statefulTimeout = AbstractGenericBeanMetaData.override(override != null ? override.statefulTimeout : null, original != null ? original.statefulTimeout : null);
        if (original != null) {
            if (original.localBean != null) {
                this.localBean = original.localBean;
            }
            if (original.initOnStartup != null) {
                this.initOnStartup = original.initOnStartup;
            }
            if (original.concurrencyManagementType != null) {
                this.concurrencyManagementType = original.concurrencyManagementType;
            }
            if (original.beanLevelLockType != null) {
                this.beanLevelLockType = original.beanLevelLockType;
            }
            if (original.beanLevelAccessTimeout != null) {
                this.beanLevelAccessTimeout = original.beanLevelAccessTimeout;
            }
            if (original.dependsOn != null) {
                this.dependsOn = original.dependsOn;
            }
        }
        if (override != null) {
            if (override.localBean != null) {
                this.localBean = override.localBean;
            }
            if (override.initOnStartup != null) {
                this.initOnStartup = override.initOnStartup;
            }
            if (override.concurrencyManagementType != null) {
                this.concurrencyManagementType = override.concurrencyManagementType;
            }
            if (override.beanLevelLockType != null) {
                this.beanLevelLockType = override.beanLevelLockType;
            }
            if (override.beanLevelAccessTimeout != null) {
                this.beanLevelAccessTimeout = override.beanLevelAccessTimeout;
            }
            if (override.dependsOn != null) {
                this.dependsOn = override.dependsOn;
            }
        }
    }

    public StatefulTimeoutMetaData getStatefulTimeout() {
        this.assertUnknownOrSessionBean();
        return this.statefulTimeout;
    }

    public void setStatefulTimeout(StatefulTimeoutMetaData statefulTimeout) {
        this.assertUnknownOrSessionBean31();
        this.statefulTimeout = statefulTimeout;
    }

    public boolean isCMP() {
        this.assertUnknownOrEntityBean();
        if (this.persistenceType == null) {
            return true;
        }
        return this.persistenceType == PersistenceType.Container;
    }

    public boolean isBMP() {
        this.assertUnknownOrEntityBean();
        return !this.isCMP();
    }

    public PersistenceType getPersistenceType() {
        this.assertUnknownOrEntityBean();
        return this.persistenceType;
    }

    public void setPersistenceType(PersistenceType persistenceType) {
        this.assertUnknownOrEntityBean();
        if (persistenceType == null) {
            throw new IllegalArgumentException("Null persistenceType");
        }
        this.persistenceType = persistenceType;
    }

    public String getPrimKeyClass() {
        this.assertUnknownOrEntityBean();
        return this.primKeyClass;
    }

    public void setPrimKeyClass(String primKeyClass) {
        this.assertUnknownOrEntityBean();
        if (primKeyClass == null) {
            throw new IllegalArgumentException("Null primKeyClass");
        }
        this.primKeyClass = primKeyClass;
    }

    public boolean isReentrant() {
        this.assertUnknownOrEntityBean();
        return this.reentrant == null ? false : this.reentrant;
    }

    public void setReentrant(boolean reentrant) {
        this.assertUnknownOrEntityBean();
        this.reentrant = reentrant;
    }

    public boolean isCMP1x() {
        this.assertUnknownOrEntityBean();
        if (this.cmpVersion == null) {
            return !this.getEjbJarMetaData().isEJB2x() && !this.getEjbJarMetaData().isEJB3x();
        }
        return "1.x".equals(this.cmpVersion);
    }

    public String getCmpVersion() {
        this.assertUnknownOrEntityBean();
        return this.cmpVersion;
    }

    public void setCmpVersion(String cmpVersion) {
        this.assertUnknownOrEntityBean();
        if (cmpVersion == null) {
            throw new IllegalArgumentException("Null cmpVersion");
        }
        this.cmpVersion = cmpVersion;
    }

    public String getAbstractSchemaName() {
        this.assertUnknownOrEntityBean();
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.assertUnknownOrEntityBean();
        if (abstractSchemaName == null) {
            throw new IllegalArgumentException("Null abstractSchemaName");
        }
        this.abstractSchemaName = abstractSchemaName;
    }

    public String getPrimKeyField() {
        this.assertUnknownOrEntityBean();
        return this.primKeyField;
    }

    public void setPrimKeyField(String primKeyField) {
        this.assertUnknownOrEntityBean();
        if (primKeyField == null) {
            throw new IllegalArgumentException("Null primKeyField");
        }
        this.primKeyField = primKeyField;
    }

    public CMPFieldsMetaData getCmpFields() {
        this.assertUnknownOrEntityBean();
        return this.cmpFields;
    }

    public void setCmpFields(CMPFieldsMetaData cmpFields) {
        this.assertUnknownOrEntityBean();
        if (cmpFields == null) {
            throw new IllegalArgumentException("Null cmpFields");
        }
        this.cmpFields = cmpFields;
    }

    public QueriesMetaData getQueries() {
        this.assertUnknownOrEntityBean();
        return this.queries;
    }

    public void setQueries(QueriesMetaData queries) {
        this.assertUnknownOrEntityBean();
        if (queries == null) {
            throw new IllegalArgumentException("Null queries");
        }
        this.queries = queries;
    }
}

