/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.jboss.ejb3;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.jboss.IIOPMetaData;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaDataParser;

public class IIOPMetaDataParser
extends AbstractEJBBoundMetaDataParser<IIOPMetaData> {
    @Override
    public IIOPMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        IIOPMetaData metaData = new IIOPMetaData();
        super.processElements(metaData, reader);
        return metaData;
    }

    @Override
    protected void processElement(IIOPMetaData metaData, XMLStreamReader reader) throws XMLStreamException {
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        switch (namespace) {
            case EJB3_IIOP: {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case BINDING_NAME: {
                        metaData.setBindingName(IIOPMetaDataParser.getElementText((XMLStreamReader)reader));
                        break;
                    }
                    case IOR_SECURITY_CONFIG: {
                        IORSecurityConfigMetaData iorSecurityMetaData = this.processIORSecurityConfig(reader);
                        metaData.setIorSecurityConfigMetaData(iorSecurityMetaData);
                        break;
                    }
                }
                return;
            }
        }
        super.processElement(metaData, reader);
    }

    protected IORSecurityConfigMetaData processIORSecurityConfig(XMLStreamReader reader) throws XMLStreamException {
        IORSecurityConfigMetaData iorSecurityMetaData = new IORSecurityConfigMetaData();
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT_CONFIG: {
                    IORTransportConfigMetaData transportConfig = this.processTransportConfig(reader);
                    iorSecurityMetaData.setTransportConfig(transportConfig);
                    continue block5;
                }
                case AS_CONTEXT: {
                    IORASContextMetaData asContext = this.processASContext(reader);
                    iorSecurityMetaData.setAsContext(asContext);
                    continue block5;
                }
                case SAS_CONTEXT: {
                    IORSASContextMetaData sasContext = this.processSASContext(reader);
                    iorSecurityMetaData.setSasContext(sasContext);
                    continue block5;
                }
            }
            throw IIOPMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return iorSecurityMetaData;
    }

    protected IORTransportConfigMetaData processTransportConfig(XMLStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.INTEGRITY, Attribute.CONFIDENTIALITY, Attribute.ESTABLISH_TRUST_IN_CLIENT, Attribute.ESTABLISH_TRUST_IN_TARGET);
        IORTransportConfigMetaData transportConfig = new IORTransportConfigMetaData();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTEGRITY: {
                    transportConfig.setIntegrity(attrValue);
                    break;
                }
                case CONFIDENTIALITY: {
                    transportConfig.setConfidentiality(attrValue);
                    break;
                }
                case DETECT_MISORDERING: {
                    transportConfig.setDetectMisordering(attrValue);
                    break;
                }
                case DETECT_REPLAY: {
                    transportConfig.setDetectReplay(attrValue);
                    break;
                }
                case ESTABLISH_TRUST_IN_CLIENT: {
                    transportConfig.setEstablishTrustInClient(attrValue);
                    break;
                }
                case ESTABLISH_TRUST_IN_TARGET: {
                    transportConfig.setEstablishTrustInTarget(attrValue);
                    break;
                }
                default: {
                    throw IIOPMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw IIOPMetaDataParser.missingRequired((XMLStreamReader)reader, requiredAttributes);
        }
        IIOPMetaDataParser.requireNoContent((XMLStreamReader)reader);
        return transportConfig;
    }

    protected IORASContextMetaData processASContext(XMLStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.AUTH_METHOD, Attribute.REALM, Attribute.REQUIRED);
        IORASContextMetaData asContext = new IORASContextMetaData();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTH_METHOD: {
                    asContext.setAuthMethod(attrValue);
                    break;
                }
                case REALM: {
                    asContext.setRealm(attrValue);
                    break;
                }
                case REQUIRED: {
                    asContext.setRequired(Boolean.valueOf(attrValue));
                    break;
                }
                default: {
                    throw IIOPMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw IIOPMetaDataParser.missingRequired((XMLStreamReader)reader, requiredAttributes);
        }
        IIOPMetaDataParser.requireNoContent((XMLStreamReader)reader);
        return asContext;
    }

    protected IORSASContextMetaData processSASContext(XMLStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.CALLER_PROPAGATION);
        IORSASContextMetaData sasContext = new IORSASContextMetaData();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CALLER_PROPAGATION: {
                    sasContext.setCallerPropagation(attrValue);
                    break;
                }
                default: {
                    throw IIOPMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
            requiredAttributes.remove((Object)attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            throw IIOPMetaDataParser.missingRequired((XMLStreamReader)reader, requiredAttributes);
        }
        IIOPMetaDataParser.requireNoContent((XMLStreamReader)reader);
        return sasContext;
    }

    static enum Attribute {
        UNKNOWN(null),
        INTEGRITY("integrity"),
        CONFIDENTIALITY("confidentiality"),
        DETECT_MISORDERING("detect-misordering"),
        DETECT_REPLAY("detect-replay"),
        ESTABLISH_TRUST_IN_CLIENT("establish-trust-in-client"),
        ESTABLISH_TRUST_IN_TARGET("establish-trust-in-target"),
        AUTH_METHOD("auth-method"),
        REALM("realm"),
        REQUIRED("required"),
        CALLER_PROPAGATION("caller-propagation");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute attribute = MAP.get(localName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                String name = attribute.name;
                if (name == null) continue;
                map.put(name, attribute);
            }
            MAP = map;
        }
    }

    static enum Element {
        UNKNOWN(null),
        BINDING_NAME("binding-name"),
        IOR_SECURITY_CONFIG("ior-security-config"),
        TRANSPORT_CONFIG("transport-config"),
        AS_CONTEXT("as-context"),
        SAS_CONTEXT("sas-context");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    static enum Namespace {
        UNKNOWN(null),
        EJB3_IIOP("urn:iiop");

        private final String namespaceURI;
        private static final Map<String, Namespace> MAP;

        private Namespace(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        String getUriString() {
            return this.namespaceURI;
        }

        static Namespace forUri(String uri) {
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }
}

