/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.Collection;
import java.util.List;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.metadata.ejb.spec.AbstractCommonMessageDrivenSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.AbstractEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.DependsOnMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.ejb.spec.EjbType;
import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenDestinationMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;
import org.jboss.metadata.ejb.spec.SubscriptionDurability;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public abstract class AbstractGenericBeanMetaData
extends AbstractCommonMessageDrivenSessionBeanMetaData {
    private static final long serialVersionUID = 1L;
    private String messagingType;
    private String messageDestinationType;
    private String messageDestinationLink;
    private ActivationConfigMetaData activationConfig;
    private String messageSelector;
    private String acknowledgeMode;
    private SubscriptionDurability subscriptionDurability;
    private String home;
    private String remote;
    private String localHome;
    private String local;
    private BusinessLocalsMetaData businessLocals;
    private BusinessRemotesMetaData businessRemotes;
    private String serviceEndpoint;
    private SessionType sessionType;
    private InitMethodsMetaData initMethods;
    private RemoveMethodsMetaData removeMethods;
    private LifecycleCallbacksMetaData postActivates;
    private LifecycleCallbacksMetaData prePassivates;
    private AsyncMethodsMetaData asyncMethods;
    private EmptyMetaData localBean;
    private Boolean initOnStartup;
    private ConcurrentMethodsMetaData concurrentMethods;
    private LockType beanLevelLockType;
    private AccessTimeoutMetaData beanLevelAccessTimeout;
    private ConcurrencyManagementType concurrencyManagementType;
    private DependsOnMetaData dependsOn;
    private NamedMethodMetaData afterBeginMethod;
    private NamedMethodMetaData beforeCompletionMethod;
    private NamedMethodMetaData afterCompletionMethod;
    private StatefulTimeoutMetaData statefulTimeout;

    protected AbstractGenericBeanMetaData() {
    }

    private final void assertUnknownOrMessageDrivenBean() {
        throw new RuntimeException("NYI: assertUnknownOrMessageDrivenBean");
    }

    private final void assertUnknownOrSessionBean() {
        if (this.getEjbType() != null && this.getEjbType() != EjbType.SESSION) {
            throw new IllegalStateException("Bean " + this + " is not an unknown or session bean, but " + (Object)((Object)this.getEjbType()));
        }
    }

    private final void assertUnknownOrSessionBean31() {
        this.assertUnknownOrSessionBean();
        EjbJarMetaData ejbJarMetaData = this.getEjbJarMetaData();
        if (ejbJarMetaData != null && ejbJarMetaData.getEjbJarVersion() != EjbJarVersion.EJB_3_1) {
            throw new IllegalStateException("Bean " + this + " is not an 3.1 EJB, but " + (Object)((Object)ejbJarMetaData.getEjbJarVersion()));
        }
    }

    @Override
    protected abstract AbstractEnterpriseBeanMetaData createMerged(AbstractEnterpriseBeanMetaData var1);

    public String getMessagingType() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messagingType;
    }

    public boolean isJMS() {
        this.assertUnknownOrMessageDrivenBean();
        String messagingType = this.getMessagingType();
        return messagingType == null || "javax.jms.MessageListener".equals(messagingType);
    }

    public void setMessagingType(String messagingType) {
        this.assertUnknownOrMessageDrivenBean();
        if (messagingType == null) {
            throw new IllegalArgumentException("Null messagingType");
        }
        this.messagingType = messagingType;
    }

    public String getMessageDestinationType() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messageDestinationType;
    }

    public void setMessageDestinationType(String messageDestinationType) {
        this.assertUnknownOrMessageDrivenBean();
        if (messageDestinationType == null) {
            throw new IllegalArgumentException("Null messageDestinationType");
        }
        this.messageDestinationType = messageDestinationType;
    }

    public String getMessageDestinationLink() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messageDestinationLink;
    }

    public void setMessageDestinationLink(String messageDestinationLink) {
        this.assertUnknownOrMessageDrivenBean();
        if (messageDestinationLink == null) {
            throw new IllegalArgumentException("Null messageDestinationLink");
        }
        this.messageDestinationLink = messageDestinationLink;
    }

    public ActivationConfigMetaData getActivationConfig() {
        this.assertUnknownOrMessageDrivenBean();
        return this.activationConfig;
    }

    public void setActivationConfig(ActivationConfigMetaData activationConfig) {
        this.assertUnknownOrMessageDrivenBean();
        if (activationConfig == null) {
            throw new IllegalArgumentException("Null activationConfig");
        }
        this.activationConfig = activationConfig;
    }

    public String getMessageSelector() {
        this.assertUnknownOrMessageDrivenBean();
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.assertUnknownOrMessageDrivenBean();
        if (messageSelector == null) {
            throw new IllegalArgumentException("Null messageSelector");
        }
        this.messageSelector = messageSelector;
    }

    public String getAcknowledgeMode() {
        this.assertUnknownOrMessageDrivenBean();
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.assertUnknownOrMessageDrivenBean();
        if (acknowledgeMode == null) {
            throw new IllegalArgumentException("Null acknowledgeMode");
        }
        this.acknowledgeMode = acknowledgeMode;
    }

    public SubscriptionDurability getSubscriptionDurability() {
        this.assertUnknownOrMessageDrivenBean();
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability) {
        this.assertUnknownOrMessageDrivenBean();
        if (subscriptionDurability == null) {
            throw new IllegalArgumentException("Null subscriptionDurability");
        }
        this.subscriptionDurability = subscriptionDurability;
    }

    public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd) {
        this.assertUnknownOrMessageDrivenBean();
        this.setMessageDestinationType(mdd.getDestinationType());
        String durability = mdd.getSubscriptionDurability();
        SubscriptionDurability sd = SubscriptionDurability.NonDurable;
        if (durability != null && durability.equalsIgnoreCase("Durable")) {
            sd = SubscriptionDurability.Durable;
        }
        this.setSubscriptionDurability(sd);
    }

    public String getHome() {
        this.assertUnknownOrSessionBean();
        return this.home;
    }

    public void setHome(String home) {
        this.assertUnknownOrSessionBean();
        if (home == null) {
            throw new IllegalArgumentException("Null home");
        }
        this.home = home;
    }

    public String getRemote() {
        this.assertUnknownOrSessionBean();
        return this.remote;
    }

    public void setRemote(String remote) {
        this.assertUnknownOrSessionBean();
        if (remote == null) {
            throw new IllegalArgumentException("Null remote");
        }
        this.remote = remote;
    }

    public String getLocalHome() {
        this.assertUnknownOrSessionBean();
        return this.localHome;
    }

    public void setLocalHome(String localHome) {
        this.assertUnknownOrSessionBean();
        if (localHome == null) {
            throw new IllegalArgumentException("Null localHome");
        }
        this.localHome = localHome;
    }

    public String getLocal() {
        this.assertUnknownOrSessionBean();
        return this.local;
    }

    public void setLocal(String local) {
        this.assertUnknownOrSessionBean();
        if (local == null) {
            throw new IllegalArgumentException("Null local");
        }
        this.local = local;
    }

    public BusinessLocalsMetaData getBusinessLocals() {
        this.assertUnknownOrSessionBean();
        return this.businessLocals;
    }

    public void setBusinessLocals(BusinessLocalsMetaData businessLocals) {
        this.assertUnknownOrSessionBean();
        if (businessLocals == null) {
            throw new IllegalArgumentException("Null businessLocals");
        }
        this.businessLocals = businessLocals;
    }

    public BusinessRemotesMetaData getBusinessRemotes() {
        this.assertUnknownOrSessionBean();
        return this.businessRemotes;
    }

    public void setBusinessRemotes(BusinessRemotesMetaData businessRemotes) {
        this.assertUnknownOrSessionBean();
        if (businessRemotes == null) {
            throw new IllegalArgumentException("Null businessRemotes");
        }
        this.businessRemotes = businessRemotes;
    }

    public String getServiceEndpoint() {
        this.assertUnknownOrSessionBean();
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.assertUnknownOrSessionBean();
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException("Null serviceEndpoint");
        }
        this.serviceEndpoint = serviceEndpoint;
    }

    public SessionType getSessionType() {
        this.assertUnknownOrSessionBean();
        return this.sessionType;
    }

    public void setSessionType(SessionType sessionType) {
        this.assertUnknownOrSessionBean();
        if (sessionType == null) {
            throw new IllegalArgumentException("Null sessionType");
        }
        this.sessionType = sessionType;
    }

    public boolean isStateful() {
        this.assertUnknownOrSessionBean();
        if (this.sessionType == null) {
            return false;
        }
        return this.sessionType == SessionType.Stateful;
    }

    public boolean isStateless() {
        this.assertUnknownOrSessionBean();
        if (this.sessionType == null) {
            return false;
        }
        return this.sessionType == SessionType.Stateless;
    }

    @Override
    public void setTimeoutMethod(NamedMethodMetaData timeoutMethod) {
        if (this.getSessionType() != null && this.getSessionType() != SessionType.Stateless) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.8: Only stateless beans can have timeouts: " + this);
        }
        super.setTimeoutMethod(timeoutMethod);
    }

    public InitMethodsMetaData getInitMethods() {
        this.assertUnknownOrSessionBean();
        return this.initMethods;
    }

    public void setInitMethods(InitMethodsMetaData initMethods) {
        this.assertUnknownOrSessionBean();
        if (initMethods == null) {
            throw new IllegalArgumentException("Null initMethods");
        }
        this.initMethods = initMethods;
    }

    public RemoveMethodsMetaData getRemoveMethods() {
        this.assertUnknownOrSessionBean();
        return this.removeMethods;
    }

    public void setRemoveMethods(RemoveMethodsMetaData removeMethods) {
        this.assertUnknownOrSessionBean();
        if (removeMethods == null) {
            throw new IllegalArgumentException("Null removeMethods");
        }
        this.removeMethods = removeMethods;
    }

    public LifecycleCallbacksMetaData getPostActivates() {
        this.assertUnknownOrSessionBean();
        return this.postActivates;
    }

    public void setPostActivates(LifecycleCallbacksMetaData postActivates) {
        this.assertUnknownOrSessionBean();
        if (postActivates == null) {
            throw new IllegalArgumentException("Null postActivates");
        }
        this.postActivates = postActivates;
    }

    public LifecycleCallbacksMetaData getPrePassivates() {
        this.assertUnknownOrSessionBean();
        return this.prePassivates;
    }

    public void setPrePassivates(LifecycleCallbacksMetaData prePassivates) {
        this.assertUnknownOrSessionBean();
        if (prePassivates == null) {
            throw new IllegalArgumentException("Null prePassivates");
        }
        this.prePassivates = prePassivates;
    }

    private void mergeSessionBean(AbstractGenericBeanMetaData override, AbstractGenericBeanMetaData original) {
        if (override != null && override.home != null) {
            this.setHome(override.home);
        } else if (original != null && original.home != null) {
            this.setHome(original.home);
        }
        if (override != null && override.remote != null) {
            this.setRemote(override.remote);
        } else if (original != null && original.remote != null) {
            this.setRemote(original.remote);
        }
        if (override != null && override.localHome != null) {
            this.setLocalHome(override.localHome);
        } else if (original != null && original.localHome != null) {
            this.setLocalHome(original.localHome);
        }
        if (override != null && override.local != null) {
            this.setLocal(override.local);
        } else if (original != null && original.local != null) {
            this.setLocal(original.local);
        }
        this.businessLocals = AbstractGenericBeanMetaData.augment(new BusinessLocalsMetaData(), override != null ? override.businessLocals : null, original != null ? original.businessLocals : null);
        this.businessRemotes = AbstractGenericBeanMetaData.augment(new BusinessRemotesMetaData(), override != null ? override.businessRemotes : null, original != null ? original.businessRemotes : null);
        if (override != null && override.serviceEndpoint != null) {
            this.setServiceEndpoint(override.serviceEndpoint);
        } else if (original != null && original.serviceEndpoint != null) {
            this.setServiceEndpoint(original.serviceEndpoint);
        }
        if (override != null && override.sessionType != null) {
            this.setSessionType(override.sessionType);
        } else if (original != null && original.sessionType != null) {
            this.setSessionType(original.sessionType);
        }
        this.initMethods = AbstractGenericBeanMetaData.augment(new InitMethodsMetaData(), override != null ? override.initMethods : null, original != null ? original.initMethods : null);
        this.removeMethods = AbstractGenericBeanMetaData.augment(new RemoveMethodsMetaData(), override != null ? override.removeMethods : null, original != null ? original.removeMethods : null);
        this.postActivates = AbstractGenericBeanMetaData.augment(new LifecycleCallbacksMetaData(), override != null ? override.postActivates : null, original != null ? original.postActivates : null);
        this.prePassivates = AbstractGenericBeanMetaData.augment(new LifecycleCallbacksMetaData(), override != null ? override.prePassivates : null, original != null ? original.prePassivates : null);
        this.mergeSessionBean31(override, original);
    }

    @Override
    public void merge(AbstractEnterpriseBeanMetaData eoverride, AbstractEnterpriseBeanMetaData eoriginal) {
        super.merge(eoverride, eoriginal);
        if (!(eoverride instanceof AbstractGenericBeanMetaData)) {
            return;
        }
        AbstractGenericBeanMetaData override = (AbstractGenericBeanMetaData)eoverride;
        AbstractGenericBeanMetaData original = (AbstractGenericBeanMetaData)eoriginal;
        this.mergeSessionBean(override, original);
    }

    public Boolean isInitOnStartup() {
        this.assertUnknownOrSessionBean31();
        return this.initOnStartup;
    }

    public void setInitOnStartup(Boolean initOnStartup) {
        this.assertUnknownOrSessionBean31();
        this.initOnStartup = initOnStartup;
    }

    public AsyncMethodsMetaData getAsyncMethods() {
        this.assertUnknownOrSessionBean31();
        return this.asyncMethods;
    }

    public void setAsyncMethods(AsyncMethodsMetaData asyncMethods) {
        this.assertUnknownOrSessionBean31();
        if (asyncMethods == null) {
            throw new IllegalArgumentException("asyncMethods is null");
        }
        this.asyncMethods = asyncMethods;
    }

    public EmptyMetaData getLocalBean() {
        this.assertUnknownOrSessionBean31();
        return this.localBean;
    }

    public void setLocalBean(EmptyMetaData localBean) {
        this.assertUnknownOrSessionBean31();
        this.localBean = localBean;
    }

    public boolean isNoInterfaceBean() {
        this.assertUnknownOrSessionBean31();
        return this.localBean != null;
    }

    public void setNoInterfaceBean(boolean isNoInterfaceBean) {
        this.assertUnknownOrSessionBean31();
        this.localBean = isNoInterfaceBean ? new EmptyMetaData() : null;
    }

    public boolean isSingleton() {
        this.assertUnknownOrSessionBean31();
        if (this.getSessionType() == null) {
            return false;
        }
        return this.getSessionType() == SessionType.Singleton;
    }

    public void setConcurrencyManagementType(ConcurrencyManagementType concurrencyManagementType) {
        this.assertUnknownOrSessionBean31();
        if (concurrencyManagementType == null) {
            throw new IllegalArgumentException("Concurrency management type cannot be null");
        }
        this.concurrencyManagementType = concurrencyManagementType;
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        this.assertUnknownOrSessionBean31();
        return this.concurrencyManagementType;
    }

    public void setConcurrentMethods(ConcurrentMethodsMetaData concurrentMethods) {
        this.assertUnknownOrSessionBean31();
        this.concurrentMethods = concurrentMethods;
    }

    public ConcurrentMethodsMetaData getConcurrentMethods() {
        this.assertUnknownOrSessionBean31();
        return this.concurrentMethods;
    }

    public void setLockType(LockType lockType) {
        this.assertUnknownOrSessionBean31();
        this.beanLevelLockType = lockType;
    }

    public LockType getLockType() {
        this.assertUnknownOrSessionBean31();
        return this.beanLevelLockType;
    }

    public void setAccessTimeout(AccessTimeoutMetaData accessTimeout) {
        this.assertUnknownOrSessionBean31();
        this.beanLevelAccessTimeout = accessTimeout;
    }

    public AccessTimeoutMetaData getAccessTimeout() {
        this.assertUnknownOrSessionBean31();
        return this.beanLevelAccessTimeout;
    }

    public String[] getDependsOn() {
        this.assertUnknownOrSessionBean31();
        if (this.dependsOn == null || this.dependsOn.getEjbNames() == null) {
            return null;
        }
        List<String> ejbNames = this.dependsOn.getEjbNames();
        return ejbNames.toArray(new String[ejbNames.size()]);
    }

    public void setDependsOn(String[] dependsOn) {
        this.assertUnknownOrSessionBean31();
        this.dependsOn = new DependsOnMetaData(dependsOn);
    }

    public void setDependsOnMetaData(DependsOnMetaData dependsOnMetaData) {
        this.assertUnknownOrSessionBean31();
        this.dependsOn = dependsOnMetaData;
    }

    public void setDependsOn(Collection<String> dependsOn) {
        this.assertUnknownOrSessionBean31();
        if (dependsOn == null) {
            return;
        }
        this.setDependsOn(dependsOn.toArray(new String[dependsOn.size()]));
    }

    public NamedMethodMetaData getAfterBeginMethod() {
        this.assertUnknownOrSessionBean31();
        return this.afterBeginMethod;
    }

    public void setAfterBeginMethod(NamedMethodMetaData method) {
        this.assertUnknownOrSessionBean31();
        this.afterBeginMethod = method;
    }

    public NamedMethodMetaData getBeforeCompletionMethod() {
        this.assertUnknownOrSessionBean31();
        return this.beforeCompletionMethod;
    }

    public void setBeforeCompletionMethod(NamedMethodMetaData method) {
        this.assertUnknownOrSessionBean31();
        this.beforeCompletionMethod = method;
    }

    public NamedMethodMetaData getAfterCompletionMethod() {
        this.assertUnknownOrSessionBean31();
        return this.afterCompletionMethod;
    }

    public void setAfterCompletionMethod(NamedMethodMetaData method) {
        this.assertUnknownOrSessionBean31();
        this.afterCompletionMethod = method;
    }

    private static <T> T override(T override, T original) {
        if (override != null) {
            return override;
        }
        return original;
    }

    private void mergeSessionBean31(AbstractGenericBeanMetaData override, AbstractGenericBeanMetaData original) {
        if (this.asyncMethods == null) {
            this.asyncMethods = new AsyncMethodsMetaData();
        }
        if (override != null && override.asyncMethods != null) {
            this.asyncMethods.addAll(override.asyncMethods);
        }
        if (original != null && original.asyncMethods != null) {
            this.asyncMethods.addAll(original.asyncMethods);
        }
        this.afterBeginMethod = AbstractGenericBeanMetaData.override(override != null ? override.afterBeginMethod : null, original != null ? original.afterBeginMethod : null);
        this.beforeCompletionMethod = AbstractGenericBeanMetaData.override(override != null ? override.beforeCompletionMethod : null, original != null ? original.beforeCompletionMethod : null);
        this.afterCompletionMethod = AbstractGenericBeanMetaData.override(override != null ? override.afterCompletionMethod : null, original != null ? original.afterCompletionMethod : null);
        this.concurrentMethods = new ConcurrentMethodsMetaData();
        this.concurrentMethods.merge(override != null ? override.concurrentMethods : null, original != null ? original.concurrentMethods : null);
        this.statefulTimeout = AbstractGenericBeanMetaData.override(override != null ? override.statefulTimeout : null, original != null ? original.statefulTimeout : null);
        if (override != null) {
            if (override.localBean != null) {
                this.localBean = override.localBean;
            }
            if (override.initOnStartup != null) {
                this.initOnStartup = override.initOnStartup;
            }
            if (override.concurrencyManagementType != null) {
                this.concurrencyManagementType = override.concurrencyManagementType;
            }
            if (override.beanLevelLockType != null) {
                this.beanLevelLockType = override.beanLevelLockType;
            }
            if (override.beanLevelAccessTimeout != null) {
                this.beanLevelAccessTimeout = override.beanLevelAccessTimeout;
            }
            if (override.dependsOn != null) {
                this.dependsOn = override.dependsOn;
            }
        } else if (original != null) {
            if (original.localBean != null) {
                this.localBean = original.localBean;
            }
            if (original.initOnStartup != null) {
                this.initOnStartup = original.initOnStartup;
            }
            if (original.concurrencyManagementType != null) {
                this.concurrencyManagementType = original.concurrencyManagementType;
            }
            if (original.beanLevelLockType != null) {
                this.beanLevelLockType = original.beanLevelLockType;
            }
            if (original.beanLevelAccessTimeout != null) {
                this.beanLevelAccessTimeout = original.beanLevelAccessTimeout;
            }
            if (original.dependsOn != null) {
                this.dependsOn = original.dependsOn;
            }
        }
    }

    public StatefulTimeoutMetaData getStatefulTimeout() {
        this.assertUnknownOrSessionBean31();
        return this.statefulTimeout;
    }

    public void setStatefulTimeout(StatefulTimeoutMetaData statefulTimeout) {
        this.assertUnknownOrSessionBean31();
        this.statefulTimeout = statefulTimeout;
    }
}

