/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.NamedMethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.ScheduleMetaDataParser;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.ScheduleMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class TimerMetaDataParser
extends AbstractMetaDataParser<TimerMetaData> {
    public static final TimerMetaDataParser INSTANCE = new TimerMetaDataParser();

    @Override
    public TimerMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        TimerMetaData timerMetaData = new TimerMetaData();
        this.processElements(timerMetaData, reader);
        return timerMetaData;
    }

    @Override
    protected void processElement(TimerMetaData timer, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case TIMEZONE: {
                String timezone = TimerMetaDataParser.getElementText((XMLStreamReader)reader);
                timer.setTimezone(timezone);
                return;
            }
            case INFO: {
                String info = TimerMetaDataParser.getElementText((XMLStreamReader)reader);
                timer.setInfo(info);
                return;
            }
            case PERSISTENT: {
                String persistent = TimerMetaDataParser.getElementText((XMLStreamReader)reader);
                if (persistent == null || persistent.trim().isEmpty()) {
                    throw TimerMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected null or empty value for <persistent> element"));
                }
                timer.setPersistent(Boolean.parseBoolean(persistent));
                return;
            }
            case TIMEOUT_METHOD: {
                NamedMethodMetaData timeoutMethod = NamedMethodMetaDataParser.INSTANCE.parse(reader);
                timer.setTimeoutMethod(timeoutMethod);
                return;
            }
            case START: {
                throw new RuntimeException("<start> element parsing in ejb-jar.xml is not yet implemented");
            }
            case END: {
                throw new RuntimeException("<end> element parsing in ejb-jar.xml is not yet implemented");
            }
            case SCHEDULE: {
                ScheduleMetaData schedule = ScheduleMetaDataParser.INSTANCE.parse(reader);
                timer.setSchedule(schedule);
                return;
            }
        }
        throw TimerMetaDataParser.unexpectedElement((XMLStreamReader)reader);
    }
}

