/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AssemblyDescriptorMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AssemblyDescriptorMetaDataParserFactory;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.EjbJarNamespaceMapping;
import org.jboss.metadata.ejb.parser.spec.EjbJarVersion;
import org.jboss.metadata.ejb.parser.spec.EnterpriseBeansMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.InterceptorsMetaDataParser;
import org.jboss.metadata.ejb.spec.EjbJar1xMetaData;
import org.jboss.metadata.ejb.spec.EjbJar20MetaData;
import org.jboss.metadata.ejb.spec.EjbJar21MetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJar31MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class EjbJarMetaDataParser
extends MetaDataElementParser {
    public static EjbJarMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info) throws XMLStreamException {
        String schemaLocation;
        reader.require(7, null, null);
        EjbJarVersion ejbJarVersion = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = info.getSystemID()) == null) continue;
            ejbJarVersion = EjbJarNamespaceMapping.getEjbJarVersion(dtdLocation);
        }
        if (ejbJarVersion == null && (schemaLocation = EjbJarMetaDataParser.readSchemaLocation((XMLStreamReader)reader)) != null) {
            ejbJarVersion = EjbJarNamespaceMapping.getEjbJarVersion(schemaLocation);
        }
        if (ejbJarVersion == null) {
            ejbJarVersion = EjbJarMetaDataParser.readVersionAttribute(reader);
        }
        if (ejbJarVersion == null) {
            ejbJarVersion = EjbJarVersion.EJB_3_1;
        }
        EjbJarMetaData ejbJarMetaData = EjbJarMetaDataParser.getEjbJarMetaData(ejbJarVersion);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            EjbJarAttribute ejbJarAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i));
            switch (ejbJarAttribute) {
                case ID: {
                    ejbJarMetaData.setId(value);
                    continue block6;
                }
                case VERSION: {
                    ejbJarMetaData.setVersion(value);
                    continue block6;
                }
                case METADATA_COMPLETE: {
                    if (ejbJarMetaData instanceof EjbJar3xMetaData) {
                        if (!Boolean.TRUE.equals(Boolean.valueOf(value))) continue block6;
                        ((EjbJar3xMetaData)ejbJarMetaData).setMetadataComplete(true);
                        continue block6;
                    }
                    throw EjbJarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
                default: {
                    throw EjbJarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        EjbJarMetaDataParser.parseEjbJarElements(ejbJarMetaData, ejbJarVersion, reader);
        return ejbJarMetaData;
    }

    private static EjbJarMetaData getEjbJarMetaData(EjbJarVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(EjbJarVersion.class.getSimpleName() + " is null. Cannot return " + EjbJarMetaData.class);
        }
        switch (version) {
            case EJB_1_1: {
                return new EjbJar1xMetaData();
            }
            case EJB_2_0: {
                return new EjbJar20MetaData();
            }
            case EJB_2_1: {
                return new EjbJar21MetaData();
            }
            case EJB_3_0: {
                return new EjbJar30MetaData();
            }
            case EJB_3_1: {
                return new EjbJar31MetaData();
            }
        }
        throw new IllegalArgumentException("Unknown ejb-jar version: " + version.name());
    }

    private static EjbJarVersion readVersionAttribute(XMLStreamReader reader) throws XMLStreamException {
        EjbJarVersion ejbJarVersion = null;
        String versionString = null;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            EjbJarAttribute ejbJarVersionAttribute;
            if (reader.getAttributeNamespace(i) != null || (ejbJarVersionAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i))) != EjbJarAttribute.VERSION) continue;
            versionString = reader.getAttributeValue(i);
        }
        if ("1.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_1_1;
        } else if ("2.0".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_2_0;
        } else if ("2.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_2_1;
        } else if ("3.0".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_0;
        } else if ("3.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_1;
        }
        return ejbJarVersion;
    }

    private static void parseEjbJarElements(EjbJarMetaData ejbJarMetaData, EjbJarVersion ejbJarVersion, XMLStreamReader reader) throws XMLStreamException {
        AssemblyDescriptorMetaDataParser assemblyDescriptorParser = AssemblyDescriptorMetaDataParserFactory.getParser(ejbJarVersion);
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (ejbJarMetaData.getDescriptionGroup() != null) continue;
                ejbJarMetaData.setDescriptionGroup(descriptionGroup);
                continue;
            }
            EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
            switch (ejbJarElement) {
                case MODULE_NAME: {
                    if (ejbJarMetaData.isEJB31() && ejbJarMetaData instanceof EjbJar31MetaData) {
                        String moduleName = EjbJarMetaDataParser.getElementText((XMLStreamReader)reader);
                        ((EjbJar31MetaData)ejbJarMetaData).setModuleName(moduleName);
                        continue block8;
                    }
                    throw EjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case ENTERPRISE_BEANS: {
                    EnterpriseBeansMetaData enterpriseBeans = EnterpriseBeansMetaDataParser.parse(reader, ejbJarVersion);
                    if (enterpriseBeans != null) {
                        enterpriseBeans.setEjbJarMetaData(ejbJarMetaData);
                    }
                    ejbJarMetaData.setEnterpriseBeans(enterpriseBeans);
                    continue block8;
                }
                case INTERCEPTORS: {
                    if (ejbJarMetaData.isEJB3x() && ejbJarMetaData instanceof EjbJar3xMetaData) {
                        InterceptorsMetaData intercpetors = InterceptorsMetaDataParser.INSTANCE.parse(reader);
                        ((EjbJar3xMetaData)ejbJarMetaData).setInterceptors(intercpetors);
                        continue block8;
                    }
                    throw EjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case RELATIONSHIPS: {
                    continue block8;
                }
                case ASSEMBLY_DESCRIPTOR: {
                    ejbJarMetaData.setAssemblyDescriptor(assemblyDescriptorParser.parse(reader));
                    continue block8;
                }
                case EJB_CLIENT_JAR: {
                    String ejbClientJar = EjbJarMetaDataParser.getElementText((XMLStreamReader)reader);
                    ejbJarMetaData.setEjbClientJar(ejbClientJar);
                    continue block8;
                }
            }
            throw EjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
    }
}

