/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.spi;

public final class KnownInterfaces {
    public static final String LOCAL = "local";
    public static final String LOCAL_HOME = "localHome";
    public static final String REMOTE = "remote";
    public static final String HOME = "home";
    public static final String UNKNOWN = "unknown";

    public static boolean isKnownInterface(String iface) {
        boolean isKnownInterface = HOME.equalsIgnoreCase(iface) || LOCAL.equalsIgnoreCase(iface) || LOCAL_HOME.equalsIgnoreCase(iface) || REMOTE.equalsIgnoreCase(iface);
        return isKnownInterface;
    }

    public static KnownInterfaceType classifyInterface(String iface) {
        KnownInterfaceType ifaceType = KnownInterfaceType.UNKNOWN;
        if (HOME.equalsIgnoreCase(iface)) {
            ifaceType = KnownInterfaceType.REMOTE_HOME;
        } else if (LOCAL.equalsIgnoreCase(iface)) {
            ifaceType = KnownInterfaceType.BUSINESS_LOCAL;
        } else if (LOCAL_HOME.equalsIgnoreCase(iface)) {
            ifaceType = KnownInterfaceType.LOCAL_HOME;
        } else if (REMOTE.equalsIgnoreCase(iface)) {
            ifaceType = KnownInterfaceType.BUSINESS_REMOTE;
        }
        return ifaceType;
    }

    public static enum KnownInterfaceType {
        BUSINESS_LOCAL("local"),
        BUSINESS_REMOTE("remote"),
        LOCAL_HOME("localHome"),
        REMOTE_HOME("home"),
        UNKNOWN("unknown");

        private final String suffix;

        public String toSuffix() {
            return this.suffix;
        }

        private KnownInterfaceType(String suffix) {
            this.suffix = suffix;
        }
    }
}

