/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndi.resolver.impl;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;

public abstract class AbstractJNDIPolicyBasedJNDINameResolver {
    private static Logger logger = Logger.getLogger(AbstractJNDIPolicyBasedJNDINameResolver.class);
    protected DefaultJndiBindingPolicy jndiBindingPolicy;
    protected boolean ignoreJNDIBindingPolicyOnMetaData;

    public AbstractJNDIPolicyBasedJNDINameResolver() {
        this(DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy());
    }

    public AbstractJNDIPolicyBasedJNDINameResolver(DefaultJndiBindingPolicy jndibindingPolicy) {
        if (jndibindingPolicy == null) {
            throw new IllegalArgumentException("JNDI binding policy cannot be null, for a JNDI binding policy based jndi-name resolver");
        }
        this.jndiBindingPolicy = jndibindingPolicy;
    }

    public boolean isIgnoreJNDIBindingPolicyOnMetaData() {
        return this.ignoreJNDIBindingPolicyOnMetaData;
    }

    public void setIgnoreJNDIBindingPolicyOnMetaData(boolean ignoreJNDIBindingPolicyOnMetaData) {
        this.ignoreJNDIBindingPolicyOnMetaData = ignoreJNDIBindingPolicyOnMetaData;
    }

    protected EjbDeploymentSummary getEjbDeploymentSummary(JBossEnterpriseBeanMetaData metadata) {
        DeploymentSummary dsummary = metadata.getJBossMetaData().getDeploymentSummary();
        if (dsummary == null) {
            dsummary = new DeploymentSummary();
        }
        return new EjbDeploymentSummary(metadata, dsummary);
    }

    protected DefaultJndiBindingPolicy getJNDIBindingPolicy(JBossEnterpriseBeanMetaData metadata) {
        if (this.isIgnoreJNDIBindingPolicyOnMetaData()) {
            return this.jndiBindingPolicy;
        }
        String jndiBindingPolicyClassName = metadata.getJndiBindingPolicy();
        if (jndiBindingPolicyClassName == null || jndiBindingPolicyClassName.trim().isEmpty()) {
            return this.jndiBindingPolicy;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> jndiBindingPolicyOnMetaDataClass = Class.forName(jndiBindingPolicyClassName, true, tccl);
            if (!DefaultJndiBindingPolicy.class.isAssignableFrom(jndiBindingPolicyOnMetaDataClass)) {
                throw new RuntimeException("JNDI binding class: " + jndiBindingPolicyClassName + " on EJB named " + metadata.getEjbName() + " does not implement " + DefaultJndiBindingPolicy.class);
            }
            return (DefaultJndiBindingPolicy)jndiBindingPolicyOnMetaDataClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load jndi binding policy: " + jndiBindingPolicyClassName + " from metadata for EJB named " + metadata.getEjbName(), cnfe);
        }
        catch (InstantiationException ine) {
            throw new RuntimeException("Could not create an instance of jndi binding policy: " + jndiBindingPolicyClassName + " from metadata for EJB named " + metadata.getEjbName(), ine);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException while trying to create an instance of jndi binding policy: " + jndiBindingPolicyClassName + " from metadata for EJB named " + metadata.getEjbName(), iae);
        }
    }
}

