/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.Stateful;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.jboss.AbstractSessionBeanProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.ConcurrencyManagementProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossSerializedConcurrentAccessProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.PostActivateMethodProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.PrePassivateMethodProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.RemoveProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;

public class StatefulProcessor
extends AbstractSessionBeanProcessor {
    protected StatefulProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new JBossSerializedConcurrentAccessProcessor(finder));
        this.addMethodProcessor(new RemoveProcessor(finder));
        this.addMethodProcessor(new PostActivateMethodProcessor(finder));
        this.addMethodProcessor(new PrePassivateMethodProcessor(finder));
        this.addTypeProcessor(new ConcurrencyManagementProcessor(finder));
    }

    @Override
    public JBossSessionBeanMetaData create(Class<?> beanClass) {
        Stateful annotation = (Stateful)this.finder.getAnnotation(beanClass, Stateful.class);
        if (annotation == null) {
            return null;
        }
        JBossSessionBeanMetaData beanMetaData = this.create(beanClass, annotation);
        beanMetaData.setSessionType(SessionType.Stateful);
        return beanMetaData;
    }

    protected JBossSessionBeanMetaData create(Class<?> beanClass, Stateful annotation) {
        return this.create(beanClass, annotation.name(), annotation.mappedName(), annotation.description());
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Stateful.class);
    }
}

