/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.AbstractEnterpriseBeanProcessor;
import org.jboss.metadata.annotation.creator.ejb.ScheduleProcessor;
import org.jboss.metadata.annotation.creator.ejb.TimeoutProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;

public class MessageDrivenProcessor
extends AbstractEnterpriseBeanProcessor<MessageDrivenBeanMetaData> {
    public MessageDrivenProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addMethodProcessor(new TimeoutProcessor(finder));
        this.addMethodProcessor(new ScheduleProcessor(finder));
    }

    @Override
    protected MessageDrivenBeanMetaData create(Class<?> beanClass) {
        MessageDriven annotation = (MessageDriven)this.finder.getAnnotation(beanClass, MessageDriven.class);
        if (annotation == null) {
            return null;
        }
        MessageDrivenBeanMetaData metaData = new MessageDrivenBeanMetaData();
        metaData.setEjbClass(beanClass.getName());
        if (annotation.name().length() > 0) {
            metaData.setEjbName(annotation.name());
        } else {
            metaData.setEjbName(beanClass.getSimpleName());
        }
        if (annotation.description().length() > 0) {
            DescriptionGroupMetaData dg = ProcessorUtils.getDescriptionGroup((String)annotation.description());
            metaData.setDescriptionGroup(dg);
        }
        if (annotation.mappedName().length() > 0) {
            metaData.setMappedName(annotation.mappedName());
        }
        if (annotation.messageListenerInterface() != Object.class) {
            metaData.setMessagingType(annotation.messageListenerInterface().getName());
        }
        ActivationConfigProperty[] props = annotation.activationConfig();
        ActivationConfigMetaData config = new ActivationConfigMetaData();
        ActivationConfigPropertiesMetaData configProps = new ActivationConfigPropertiesMetaData();
        config.setActivationConfigProperties(configProps);
        for (ActivationConfigProperty prop : props) {
            ActivationConfigPropertyMetaData acp = new ActivationConfigPropertyMetaData();
            acp.setActivationConfigPropertyName(prop.propertyName());
            acp.setValue(prop.propertyValue());
            configProps.add((MappableMetaData)acp);
        }
        metaData.setActivationConfig(config);
        return metaData;
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(MessageDriven.class);
    }
}

