/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.IsolationLevelType;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.PropertyMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class DataSourceMetaDataParser
extends MetaDataElementParser {
    public static DataSourceMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        DataSourceMetaData dataSource = new DataSourceMetaData();
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    dataSource.setId(value);
                    continue block22;
                }
                default: {
                    throw DataSourceMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block23: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions)) {
                if (dataSource.getDescriptions() != null) continue;
                dataSource.setDescriptions(descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    dataSource.setName(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case CLASS_NAME: {
                    dataSource.setClassName(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case SERVER_NAME: {
                    dataSource.setServerName(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case PORT_NUMBER: {
                    dataSource.setPortNumber(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case DATABASE_NAME: {
                    dataSource.setDatabaseName(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case URL: {
                    dataSource.setUrl(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case USER: {
                    dataSource.setUser(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case PASSWORD: {
                    dataSource.setPassword(DataSourceMetaDataParser.getElementText(reader));
                    continue block23;
                }
                case PROPERTY: {
                    PropertiesMetaData properties = dataSource.getProperties();
                    if (properties == null) {
                        properties = new PropertiesMetaData();
                        dataSource.setProperties(properties);
                    }
                    properties.add(PropertyMetaDataParser.parse(reader));
                    continue block23;
                }
                case LOGIN_TIMEOUT: {
                    dataSource.setLoginTimeout(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case TRANSACTIONAL: {
                    dataSource.setTransactional(Boolean.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case ISOLATION_LEVEL: {
                    dataSource.setIsolationLevel(IsolationLevelType.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case INITAL_POOL_SIZE: {
                    dataSource.setInitialPoolSize(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case MAX_POOL_SIZE: {
                    dataSource.setMaxPoolSize(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case MIN_POOL_SIZE: {
                    dataSource.setMinPoolSize(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case MAX_IDLE_TIME: {
                    dataSource.setMaxIdleTime(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
                case MAX_STATEMENTS: {
                    dataSource.setMaxStatements(Integer.valueOf(DataSourceMetaDataParser.getElementText(reader)));
                    continue block23;
                }
            }
            throw DataSourceMetaDataParser.unexpectedElement(reader);
        }
        return dataSource;
    }
}

