/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.util;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MetaDataElementParser
implements XMLStreamConstants {
    private static final Comparator<Object> NATURAL = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    protected static XMLStreamException unexpectedValue(XMLStreamReader reader, Throwable t) {
        return new XMLStreamException("Unexpected value '" + reader.getName() + "' encountered", reader.getLocation(), t);
    }

    protected static XMLStreamException unexpectedElement(XMLStreamReader reader) {
        return new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    protected static XMLStreamException unexpectedAttribute(XMLStreamReader reader, int index) {
        return new XMLStreamException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    protected static XMLStreamException missingRequired(XMLStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required attribute(s): " + b, reader.getLocation());
    }

    protected static XMLStreamException missingRequiredElement(XMLStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required element(s): " + b, reader.getLocation());
    }

    protected static void requireNoAttributes(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw MetaDataElementParser.unexpectedAttribute(reader, 0);
        }
    }

    protected static String getElementText(XMLStreamReader reader) throws XMLStreamException {
        return reader.getElementText().trim();
    }

    protected static void requireNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw MetaDataElementParser.unexpectedElement(reader);
        }
    }

    protected static XMLStreamException duplicateNamedElement(XMLStreamReader reader, String name) {
        return new XMLStreamException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    protected static boolean readBooleanAttributeElement(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        MetaDataElementParser.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        MetaDataElementParser.requireNoContent(reader);
        return value;
    }

    protected static String readStringAttributeElement(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        MetaDataElementParser.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        MetaDataElementParser.requireNoContent(reader);
        return value;
    }

    private static void requireSingleAttribute(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw MetaDataElementParser.missingRequired(reader, Collections.singleton(attributeName));
        }
        if (reader.getAttributeNamespace(0) != null || !attributeName.equals(reader.getAttributeLocalName(0))) {
            throw MetaDataElementParser.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw MetaDataElementParser.unexpectedAttribute(reader, 1);
        }
    }

    protected static String readSchemaLocation(XMLStreamReader reader) throws XMLStreamException {
        int pos;
        int count = reader.getAttributeCount();
        if (count == 0) {
            return null;
        }
        String loc = null;
        for (int i = 0; i < count; ++i) {
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(reader.getAttributeNamespace(i)) || !"schemaLocation".equals(reader.getAttributeLocalName(i))) continue;
            loc = reader.getAttributeValue(i);
            break;
        }
        if (loc != null && (pos = loc.indexOf(32)) > 0) {
            loc = loc.substring(pos + 1);
        }
        return loc;
    }

    protected static String readDTDLocation(XMLStreamReader reader) throws XMLStreamException {
        int begin;
        if (reader.getEventType() != 11) {
            return null;
        }
        String loc = reader.getText();
        int end = loc.lastIndexOf(34);
        if (end > 0 && (begin = loc.lastIndexOf(34, end - 1)) > 0) {
            loc = loc.substring(begin + 1, end).trim();
        }
        return loc;
    }

    protected static QName parseQName(String qname) {
        int end;
        int begin = qname.indexOf(123);
        if (begin < (end = qname.indexOf(125)) && end < qname.length()) {
            String ns = qname.substring(begin + 1, end);
            String local = qname.substring(end + 1);
            return new QName(ns, local);
        }
        throw new IllegalArgumentException("Invalid QName: " + qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <K, V> NavigableMap<K, V> safeCopyMap(NavigableMap<K, V> toCopy) {
        NavigableMap<K, V> navigableMap = toCopy;
        synchronized (navigableMap) {
            return new TreeMap<K, V>(toCopy);
        }
    }

    private static <T> Comparator<? super T> comparatorOf(SortedMap<T, ?> map) {
        Comparator<T> comparator = map.comparator();
        if (comparator != null) {
            return comparator;
        }
        return NATURAL;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static class DTDInfo
    implements XMLResolver {
        private String publicID;
        private String systemID;
        private String baseURI;
        private String namespace;

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            this.publicID = publicID;
            this.systemID = systemID;
            this.baseURI = baseURI;
            this.namespace = namespace;
            return new ByteArrayInputStream(new byte[0]);
        }

        public String getPublicID() {
            return this.publicID;
        }

        public String getSystemID() {
            return this.systemID;
        }

        public String getBaseURI() {
            return this.baseURI;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("{");
            builder.append("publicID=").append(this.publicID).append(", ");
            builder.append("systemID=").append(this.systemID).append(", ");
            builder.append("baseURI=").append(this.baseURI).append(", ");
            builder.append("namespace=").append(this.namespace);
            builder.append("}");
            return builder.toString();
        }
    }
}

